<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateNoteComment extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {

        Schema::create('note_comment', function (Blueprint $table) {

            $table->increments('id');
            $table->timestamps();

            $table->integer('memberUserId')->nullable()->comment('用户');
            $table->integer('noteId')->nullable()->comment('文章');

            $table->integer('rootCommentId')->nullable()->comment('所属评论');

            $table->integer('likeCount')->nullable()->comment('喜欢数');

            $table->string('content', 1000)->nullable()->comment('内容');

            $table->index(['memberUserId']);
            $table->index(['noteId']);

        });

        Schema::create('comment_like', function (Blueprint $table) {

            $table->increments('id');
            $table->timestamps();

            $table->integer('commentId')->nullable()->comment('评论');
            $table->integer('memberUserId')->nullable()->comment('用户');

            $table->unique(['commentId', 'memberUserId']);

        });


    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {

    }
}
