<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateTopic extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {

        Schema::create('topic', function (Blueprint $table) {

            $table->increments('id');
            $table->timestamps();

            $table->string('alias', 16)->nullable()->comment('Alias');

            $table->integer('memberUserId')->nullable()->comment('用户');

            $table->string('cover', 200)->nullable()->comment('封面');
            $table->string('title', 50)->nullable()->comment('标题');
            $table->string('description', 400)->nullable()->comment('公告');

            $table->tinyInteger('pushEnable')->nullable()->comment('允许投稿');
            $table->tinyInteger('pushVerify')->nullable()->comment('投稿是否需要审核');

            $table->integer('noteCount')->nullable()->comment('文章数');
            $table->integer('followerCount')->nullable()->comment('关注数');

            $table->unique(['alias']);
            $table->index(['memberUserId']);
        });


        Schema::create('topic_note', function (Blueprint $table) {

            $table->increments('id');
            $table->timestamps();

            $table->integer('topicId')->nullable()->comment('专题');
            $table->integer('noteId')->nullable()->comment('文章');

            $table->tinyInteger('isDeleted')->nullable()->comment('已删除');

            $table->index(['topicId']);
            $table->index(['noteId']);

        });


        Schema::create('topic_note_apply', function (Blueprint $table) {

            $table->increments('id');
            $table->timestamps();

            $table->integer('topicId')->nullable()->comment('专题');
            $table->integer('noteId')->nullable()->comment('文章');

            $table->index(['topicId']);
            $table->index(['noteId']);

        });

        Schema::create('topic_follower', function (Blueprint $table) {

            $table->increments('id');
            $table->timestamps();

            $table->integer('topicId')->nullable()->comment('专题');
            $table->integer('followerMemberUserId')->nullable()->comment('用户ID');

            $table->index(['topicId']);
            $table->index(['followerMemberUserId', 'topicId']);
        });

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {

    }
}
