<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateNoteTip extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {

        Schema::create('note_tip', function (Blueprint $table) {

            $table->increments('id');
            $table->timestamps();

            $table->tinyInteger('status')->nullable()->comment('状态');

            $table->integer('memberUserId')->nullable()->comment('收到打赏的用户');
            $table->integer('tipMemberUserId')->nullable()->comment('打赏用户');
            $table->integer('noteId')->nullable()->comment('文章');
            $table->decimal('money', 20, 2)->nullable()->comment('打赏金额');
            $table->string('msg', 400)->nullable()->comment('打赏消息');

            $table->index(['memberUserId']);
            $table->index(['tipMemberUserId']);
            $table->index(['noteId']);

        });

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {

    }
}
