<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateNoteTipOff extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {

        Schema::create('note_tip_off', function (Blueprint $table) {

            $table->increments('id');
            $table->timestamps();

            $table->tinyInteger('status')->nullable()->comment('已处理');

            $table->integer('memberUserId')->nullable()->comment('用户');
            $table->integer('noteId')->nullable()->comment('文章');

            $table->string('type', 200)->nullable()->comment('类型');
            $table->string('remark', 400)->nullable()->comment('说明');

            $table->index(['memberUserId']);
            $table->index(['noteId']);
        });

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {

    }
}
