<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class ChangeNote20181112 extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {

        Schema::table('note', function (Blueprint $table) {
            /** @see \App\Types\NoteStatus */
            $table->tinyInteger('status')->nullable()->comment('');
            $table->string('statusRemark', 100)->nullable()->comment('');
        });

        \TechOnline\Laravel\Dao\ModelUtil::model('note')
            ->whereNull('status')
            ->update(['status' => \App\Types\NoteStatus::VERIFY_PASS]);

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {

    }
}
