@extends('admin::frame')

@section('pageTitle','后台首页')

@section('adminScript')
    @parent
    @include('soft::admin.dashboardVersion')
@endsection

@section('bodyContent')

    @include('soft::admin.dashboardDemo')

    <div class="uk-grid">
        <div class="uk-width-1-4">
            <div class="admin-block-stat">
                <div class="icon green">
                    <i class="uk-icon-users"></i>
                </div>
                <a class="number" href="{{action('\App\Http\Controllers\Admin\MemberController@dataList')}}">
                    {{number_format(\TechOnline\Laravel\Dao\ModelUtil::count('member_user'))}}
                </a>
                <div class="name">
                    会员总数
                </div>
            </div>
        </div>
        <div class="uk-width-1-4">
            <div class="admin-block-stat">
                <div class="icon red">
                    <i class="uk-icon-list"></i>
                </div>
                <a class="number" href="{{action('\App\Http\Controllers\Admin\NoteController@dataList')}}">
                    {{number_format(\TechOnline\Laravel\Dao\ModelUtil::count('note'))}}
                </a>
                <div class="name">
                    文章总数
                </div>
            </div>
        </div>
        <div class="uk-width-1-4">
            <div class="admin-block-stat">
                <div class="icon dark">
                    <i class="uk-icon-th"></i>
                </div>
                <a class="number" href="{{action('\App\Http\Controllers\Admin\TopicController@dataList')}}">
                    {{number_format(\TechOnline\Laravel\Dao\ModelUtil::count('topic'))}}
                </a>
                <div class="name">
                    专题总数
                </div>
            </div>
        </div>
        <div class="uk-width-1-4">
            <div class="admin-block-stat">
                <div class="icon blue">
                    <i class="uk-icon-comment"></i>
                </div>
                <a class="number" href="{{action('\App\Http\Controllers\Admin\NoteCommentController@dataList')}}">
                    {{number_format(\TechOnline\Laravel\Dao\ModelUtil::count('note_comment'))}}
                </a>
                <div class="name">
                    评论总数
                </div>
            </div>
        </div>
    </div>

    <div class="admin-block">
        <div class="head"><i class="uk-icon-tasks"></i> 待处理</div>
        <div class="body">
            <div class="uk-grid">
                <div class="uk-width-1-5">
                    <?php $count = \TechOnline\Laravel\Dao\ModelUtil::count('member_money_cash',['status'=>\TechSoft\Laravel\MemberMoney\Types\MemberMoneyCashStatus::VERIFYING]); ?>
                    <div class="admin-block-card @if($count>0) red @endif">
                        <div class="name">
                            <i class="uk-icon-cny"></i>
                            提现申请
                        </div>
                        <a class="number" href="<?php echo htmlspecialchars(action('\App\Http\Controllers\Admin\MemberMoneyCashController@dataList').'#{"page":1,"field":[],"order":[],"search":[{"status":{"equal":"1"}}]}'); ?>">
                            {{number_format($count)}}
                        </a>
                    </div>
                </div>
                <div class="uk-width-1-5">
                    <?php $count = \TechOnline\Laravel\Dao\ModelUtil::count('note_tip_off',['status'=>\App\Types\NoteTipOffStatus::WAIT_PROCESS]); ?>
                    <div class="admin-block-card @if($count>0) red @endif">
                        <div class="name">
                            <i class="uk-icon-bell"></i>
                            举报待处理
                        </div>
                        <a class="number" href="<?php echo htmlspecialchars(action('\App\Http\Controllers\Admin\NoteTipOffController@dataList').'#{"page":1,"field":[],"order":[],"search":[{"status":{"equal":"1"}}]}'); ?>">
                            {{number_format($count)}}
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @include('soft::admin.dashboardCopyright')

@endsection

