@if(!empty($notes))
    @foreach($notes as $note)
        <div class="item">
            <div class="author">
                <a href="/member/{{$note['memberUserId']}}" class="avatar">
                    <img src="{{\TechSoft\Laravel\Assets\AssetsUtil::fixOrDefault($note['_memberUser']['avatar'],'assets/lib/img/avatar_big.png')}}" />
                </a>
                <a class="name" href="/member/{{$note['memberUserId']}}">
                    {{$note['_memberUser']['username']}}
                </a>
                <span class="time">
                    <time datetime="{{$note['created_at']}}"></time>
                </span>
            </div>
            @if(!empty($note['_cover']))
                <div class="cover">
                    <a href="/n/{{$note['alias']}}" data-src="{{\TechSoft\Laravel\Assets\AssetsUtil::fix($note['_cover'])}}">
                    </a>
                </div>
            @endif
            <a href="/n/{{$note['alias']}}" class="title">
                {{$note['title']}}
            </a>
            <div class="summary">
                <div class="text">
                    {{$note['_summary']}}
                </div>
            </div>
            <div class="stat">
                <a href="/n/{{$note['alias']}}">
                    <i class="uk-icon-eye"></i> {{$note['viewCount'] or 0}}
                </a>
                &nbsp;&nbsp;
                <a href="/n/{{$note['alias']}}">
                    <i class="uk-icon-heart"></i> {{$note['likeCount'] or 0}}
                </a>
                &nbsp;&nbsp;
                <a href="/n/{{$note['alias']}}">
                    <i class="uk-icon-comment"></i> {{$note['commentCount'] or 0}}
                </a>
            </div>
            @if(!empty($topic) && $_memberUserId==$topic['memberUserId'])
                <div class="action">
                    <a href="javascript:;" data-ajax-request="/topic/note_remove/{{$topic['id']}}/{{$note['id']}}" data-ajax-request-loading data-confirm="确定从专题移除文件？"><i class="uk-icon-remove"></i> 移除</a>
                </div>
            @endif
        </div>
    @endforeach
@endif