@extends('theme.default.m.frame')

@section('pageTitle',htmlspecialchars(\TechSoft\Laravel\Config\ConfigUtil::get('siteName')))
@section('headerLeft',' ')

@section('bodyScript')
    <script src="@assets('assets/m/home.js')"></script>
@endsection

@section('bodyContent')

    <div class="pb pb-search-bar uk-margin-bottom-remove uk-margin-top-remove">
        <div class="body uk-padding-bottom-remove">
            <?php
            $searchUrl = '/search';
            if(in_array($base_request_path,['/search/note','/search/user','/search/topic'])){
                $searchUrl = $base_request_path;
            }
            ?>
            <form action="{{$searchUrl}}" class="search" method="get">
                <div class="mui-input-row mui-search">
                    <input type="search" class="mui-input-clear" name="keyword" placeholder="搜索 文章/专题/用户" value="{{\Illuminate\Support\Facades\Input::get('keyword')}}">
                </div>
            </form>
        </div>
    </div>

    <div class="pb pb-home-banner">
        <div class="swiper-container">
            <div class="swiper-wrapper">
                @if(empty($banners))
                    <a href="javascript:;" class="swiper-slide" style="background-image:url('/placeholder/640x320');"></a>
                @else
                    @foreach($banners as $banner)
                        <a class="swiper-slide"
                           style="background-image:url({{\TechSoft\Laravel\Assets\AssetsUtil::fix($banner['image'])}});"
                           @if($banner['link']) href="{{$banner['link']}}" target="_blank" @else href="javascript:;" @endif></a>
                    @endforeach
                @endif
            </div>
            <div class="swiper-pagination swiper-pagination-white"></div>
        </div>
    </div>

    <div class="pb pb-home-topic-list">
        <div class="head">
            <h2>推荐专题</h2>
        </div>
        <div class="body">
            @if(empty($hotTopics))
                <div class="empty">暂无推荐专题</div>
            @else
                <div class="swiper-container">
                    <div class="swiper-wrapper">
                        @foreach($hotTopics as $topic)
                            <div class="swiper-slide">
                                <a href="/t/{{$topic['alias']}}" class="item">
                                    <img src="{{\TechSoft\Laravel\Assets\AssetsUtil::fix($topic['cover'])}}" />
                                    <span class="name">
                                        {{$topic['title']}}
                                    </span>
                                </a>
                            </div>
                        @endforeach
                    </div>
                </div>

            @endif
        </div>
    </div>


    <div class="pb pb-tab">
        <div class="body">
            <div class="uk-grid">
                <div class="uk-width-1-4">
                    <a class="active" href="javascript:;" data-note-list-tab="recommend">
                        推荐文章
                    </a>
                </div>
                <div class="uk-width-1-4">
                    <a href="javascript:;" data-note-list-tab="comment">
                        热论文章
                    </a>
                </div>
                <div class="uk-width-1-4">
                    <a href="javascript:;" data-note-list-tab="hot">
                        最热文章
                    </a>
                </div>
                <div class="uk-width-1-4">
                    <a href="javascript:;" data-note-list-tab="latest">
                        最新文章
                    </a>
                </div>
            </div>
        </div>
    </div>
    <div class="pb pb-note-list">
        <div class="body">
            <div id="recommendNotes" data-note-list="recommend">
                <div class="list">
                    <?php $notes = $recommendNotes; ?>
                    @include('theme.default.m.fragment.noteListItems')
                </div>
                <div class="loading">
                    <i class="uk-icon-refresh uk-icon-spin"></i>
                    正在加载...
                </div>
                <div class="no-more">
                    没有更多了~
                </div>
            </div>
            <div id="commentNotes" data-note-list="comment">
                <div class="list">
                    <?php $notes = $commentNotes; ?>
                    @include('theme.default.m.fragment.noteListItems')
                </div>
                <div class="loading">
                    <i class="uk-icon-refresh uk-icon-spin"></i>
                    正在加载...
                </div>
                <div class="no-more">
                    没有更多了~
                </div>
            </div>
            <div id="hotNotes" data-note-list="hot">
                <div class="list">
                    <?php $notes = $hotNotes; ?>
                    @include('theme.default.m.fragment.noteListItems')
                </div>
                <div class="loading">
                    <i class="uk-icon-refresh uk-icon-spin"></i>
                    正在加载...
                </div>
                <div class="no-more">
                    没有更多了~
                </div>
            </div>
            <div id="latestNotes" style="display:none;" data-note-list="latest">
                <div class="list">
                    <?php $notes = $latestNotes; ?>
                    @include('theme.default.m.fragment.noteListItems')
                </div>
                <div class="loading">
                    <i class="uk-icon-refresh uk-icon-spin"></i>
                    正在加载...
                </div>
                <div class="no-more">
                    没有更多了~
                </div>
            </div>
        </div>
    </div>

@endsection