@extends('theme.default.m.member.frame')

@section('bodyScript')
    @parent
    <script>
        (function () {
            var $container = $('#list');
            var infiniteScroller = new window.api.infiniteScroller({
                container: window,
                tail: $container.find('.loading'),
                autoStart: false,
                initCallback: function () {
                },
                nextCallback: function (page) {
                    $.post('?', {page: page}, function (res) {
                        window.api.base.defaultFormCallback(res, {
                            success: function () {
                                $container.find('.list').append(res.data.html);
                                $("[datetime]").timeago();
                                $('[data-src]').lazyload({data_attribute: 'src'});
                                if (res.data.html) {
                                    infiniteScroller.nextDone();
                                } else {
                                    infiniteScroller.done();
                                }
                            }
                        });
                    });
                },
                doneCallback: function () {
                    $container.find('.loading').hide();
                    $container.find('.no-more').show();
                },
                resetCallback: function () {
                    $container.find('.list').html('');
                    $container.find('.loading').show();
                    $container.find('.no-more').hide();
                }
            });

            infiniteScroller.setPage(1);
            infiniteScroller.start();
        })();
    </script>
@endsection

@section('memberBodyContentWrap')

    <div class="pb pb-tab">
        <div class="body">
            <div class="uk-grid">
                <div class="uk-width-1-2">
                    <a class="item active" href="/member/{{$memberUser['id']}}/following">
                        <i class="uk-icon-heart-o"></i> 关注用户
                    </a>
                </div>
                <div class="uk-width-1-2">
                    <a class="item" href="/member/{{$memberUser['id']}}/followers">
                        <i class="uk-icon-users"></i> 粉丝
                    </a>
                </div>
            </div>
        </div>
    </div>

    <div id="list" class="pb pb-member-list uk-margin-top-remove">
        <div class="body">
            <div class="list">
            </div>
            <div class="loading">
                <i class="uk-icon-refresh uk-icon-spin"></i>
                正在加载...
            </div>
            <div class="no-more">
                没有更多了~
            </div>
        </div>
    </div>

@endsection