@extends('theme.default.m.frame')

@section('pageTitleMain',htmlspecialchars($memberUser['username']))

@section('bodyContent')

    <div class="pb pb-member-info">

        <div class="body">

            <div class="box">
                <div class="avatar">
                    <a href="/member/{{$memberUser['id']}}">
                        <img src="{{\TechSoft\Laravel\Assets\AssetsUtil::fixOrDefault($memberUser['avatarBig'],'assets/lib/img/avatar_big.png')}}" />
                    </a>
                </div>
                <div class="name">
                    <a href="/member/{{$memberUser['id']}}">
                        {{$memberUser['username']}}
                    </a>
                    @if($memberUser['gender']==\TechSoft\Laravel\Member\Type\Gender::MALE)
                        <span class="gender male"><i class="uk-icon-male"></i></span>
                    @endif
                    @if($memberUser['gender']==\TechSoft\Laravel\Member\Type\Gender::FEMALE)
                        <span class="gender female"><i class="uk-icon-female"></i></span>
                    @endif
                </div>
                <div class="stat">
                    <a href="/member/{{$memberUser['id']}}/following">
                        <span>{{$memberUser['followCount'] or 0}}</span>
                        关注
                    </a>
                    <a href="/member/{{$memberUser['id']}}/followers">
                        <span>{{$memberUser['followerCount'] or 0}}</span>
                        粉丝
                    </a>
                    <a class="info" href="javascript:;">
                        <span>{{$memberUser['wordCount'] or 0}}</span>
                        字数
                    </a>
                    <a class="info" href="javascript:;">
                        <span>{{$memberUser['noteCount'] or 0}}</span>
                        文章
                    </a>
                </div>
                <div class="signature">
                    @if($memberUser['signature'])
                        {!! \TechSoft\Laravel\Util\HtmlUtil::text2html($memberUser['signature']) !!}
                    @else
                        <p class="uk-text-muted">这个家伙很懒，什么也没留下~</p>
                    @endif
                </div>
                @if($_memberUserId && $_memberUserId!=$memberUser['id'])
                    <div class="action">
                        <a href="/member/message_chat_create/{{$memberUser['id']}}" class="msg">
                            <i class="uk-icon-comment"></i>
                            发私信
                        </a>
                        <div class="user-follow-box" data-user-id="{{$memberUser['id']}}">
                            <a href="javascript:;" class="follow @if(!$memberUser['_isFollowed']) show @endif ">
                                <i class="uk-icon-plus"></i> 关注
                            </a>
                            <a href="javascript:;" class="unfollow @if($memberUser['_isFollowed']) show @endif ">
                                <i class="uk-icon-minus"></i> 取消关注
                            </a>
                        </div>
                    </div>
                @endif
            </div>

        </div>

    </div>

    @section('memberBodyContentWrap')

        @if($_memberUser['id']==$memberUser['id'] || !empty($topics))
            <div class="pb pb-simple-topic-list">
                <div class="head">
                    @if($_memberUser['id']==$memberUser['id'])
                        <div class="more">
                            <a href="/topic/edit">
                                <i class="uk-icon-plus"></i> 新建专题
                            </a>
                        </div>
                    @endif
                    <h2>
                        @if($_memberUser['id']==$memberUser['id'])
                            我创建的专题
                        @else
                            TA创建的专题
                        @endif
                    </h2>
                </div>
                <div class="body">
                    @if(empty($topics))
                        <div class="empty">
                            暂无专题~
                        </div>
                    @else
                        @foreach($topics as $topic)
                            <a href="/t/{{$topic['alias']}}" class="item">
                                <img src="{{\TechSoft\Laravel\Assets\AssetsUtil::fix($topic['cover'])}}" />
                                {{$topic['title']}}
                            </a>
                        @endforeach
                    @endif
                </div>
            </div>
        @endif

        @section('memberBodyContent')
        @show

    @show

@endsection