@extends('theme.default.m.frame')

@section('pageTitleMain','我和 '.$chat['_chatMemberUser']['username'].' 的对话')
@section('headerRight',' ')
@section('footerNav',' ')

@section('bodyScript')
    <script>
        var __app = {
            device:'mobile',
            url:"/member/message_chat_room/{{$chat['id']}}",
            cdn:"{{\TechSoft\Laravel\Assets\AssetsUtil::cdn()}}"
        };
    </script>
    <script src="@assets('assets/m/memberChat.js')"></script>
@endsection

@section('bodyContent')

    <div class="pb pb-member-chat-room">
        <div class="chat-messages" id="chatMessages" v-cloak>
            <div class="list">
                <div class="list-container">
                    <div class="loading" v-show="initing || loading">
                        <i class="uk-icon-refresh uk-icon-spin"></i>
                        正在加载...
                    </div>
                    <div class="more" v-show="!initing && hasHistory && !loading" v-on:click="loadMore()">
                        <i class="uk-icon-angle-double-up"></i>
                        加载历史
                    </div>
                    <div class="empty" v-show="!initing && !hasHistory && !loading && msgs.length==0">
                        暂无消息
                    </div>
                    <div v-for="msg in msgs" class="item" :class="{ send:msg.senderMemberUserId!={{$_memberUserId}} }">
                        <a :href="'/member/'+msg.senderMemberUserId" class="avatar" target="_blank">
                            <img :src="msg.senderMemberUserAvatar" />
                        </a>
                        <div class="message">
                            <div class="content">
                                <span class="arrow"></span>
                                <div class="text" v-if="msg.type=={{\TechSoft\Laravel\MemberChat\Type\MemberChatMsgType::TEXT}}" v-html="msg.content"></div>
                                <div class="image" v-if="msg.type=={{\TechSoft\Laravel\MemberChat\Type\MemberChatMsgType::IMAGE}}" v-html="msg.content"></div>
                                <div class="time">
                                    <time :datetime="msg.time"></time>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="chat-message-editor" data-message-chat-editor>
                <div class="message-editor">
                    <textarea id="chatMessageEditor" style="display:none;"></textarea>
                </div>
            </div>
        </div>
    </div>

@endsection