@extends('theme.default.m.frame')

@section('pageTitleMain','消息通知')

@section('bodyScript')
    @parent
    <script>
        (function () {
            var $container = $('#list');
            var load = function (page,cb) {
                $.post('?', {page: page}, function (res) {
                    window.api.base.defaultFormCallback(res, {
                        success: function () {
                            cb(res.data);
                        }
                    });
                });
            };
            var infiniteScroller = new window.api.infiniteScroller({
                container: $('#list'),
                tail: $container.find('.loading'),
                autoStart: false,
                pullToRefresh: true,
                pullToRefreshDom: $container.find('.pull-refresh'),
                pullToRefreshCallback: function () {
                    load(1,function (data) {
                        $container.find('.list').html(data.html);
                        $("[datetime]").timeago();
                        infiniteScroller.pullToRefreshDone();
                    });
                },
                initCallback: function () {
                },
                nextCallback: function (page) {
                    load(page,function (data) {
                        if(page==1){
                            $container.find('.list').html(data.html);
                        }else{
                            $container.find('.list').append(data.html);
                        }
                        $("[datetime]").timeago();
                        if (data.html) {
                            infiniteScroller.nextDone();
                        } else {
                            infiniteScroller.done();
                        }
                    });
                },
                doneCallback: function () {
                    $container.find('.loading').hide();
                    $container.find('.no-more').show();
                },
                resetCallback: function () {
                    $container.find('.loading').show();
                    $container.find('.no-more').hide();
                }
            });

            infiniteScroller.setPage(2);
            infiniteScroller.start();
        })();
    </script>
@endsection

@section('bodyContent')

    <div class="pb pb-tab">
        <div class="body">
            <div class="uk-grid">
                <div class="uk-width-1-2">
                    <a href="/member/message" class="item @if($base_request_path=='/member/message') active @endif">
                        未读消息
                    </a>
                </div>
                <div class="uk-width-1-2">
                    <a href="/member/message_all" class="item @if($base_request_path=='/member/message_all') active @endif">
                        所有消息
                    </a>
                </div>
            </div>
        </div>
    </div>

    <div id="list" class="pb pb-member-message-list">
        <div class="body">
            <div class="pull-refresh">
                <div class="status pull" style="display:none;">
                    <div class="uk-icon-arrow-down"></div>
                    下拉刷新
                </div>
                <div class="status refreshing" style="display:none;">
                    <div class="uk-icon-spin uk-icon-refresh"></div>
                    正在刷新
                </div>
            </div>
            <div class="list">
                @include('theme.default.m.memberMessage.messageItems')
            </div>
            <div class="loading">
                <i class="uk-icon-refresh uk-icon-spin"></i>
                正在加载...
            </div>
            <div class="no-more">
                没有更多了~
            </div>
        </div>
    </div>

@endsection