@extends('theme.default.m.frame')

@section('pageTitleMain','余额提现')

@section('bodyContent')

    <div class="pb-account">
        <form action="?" method="post" data-ajax-form onsubmit="return false;">

            <div class="mui-input-group">
                <div class="mui-input-row">
                    <label>账户余额</label>
                    <input type="text" disabled class="mui-input" value="￥{{sprintf('%0.2f',$total)}}" />
                </div>
            </div>

            @if($total>=100)


                <div class="mui-input-group">
                    <div class="mui-input-row">
                        <label>提现金额</label>
                        <input type="text" name="money" class="mui-input-clear mui-input" value="100" />
                    </div>
                    <div class="mui-input-row">
                        <label>支付宝姓名</label>
                        <input type="text" name="alipayRealname" class="mui-input-clear mui-input" value="" placeholder="如 张三" />
                    </div>
                    <div class="mui-input-row">
                        <label>支付宝账号</label>
                        <input type="text" name="alipayAccount" class="mui-input-clear mui-input" value="" placeholder="如 tecmz@alipay.com" />
                    </div>
                </div>

                <div class="submit">
                    <button type="submit" class="mui-btn mui-btn-block mui-btn-primary">提交</button>
                </div>

                <div class="mui-content-padded uk-text-muted">
                    <p>每次提现最小额度为￥100.00</p>
                    <p>每次提现收取 {{\TechSoft\Laravel\Config\ConfigUtil::get('customTipCashRate',0)}}% 手续费</p>
                    <p>提现会在 3-5 个工作日内到账</p>
                </div>

            @else

                <div class="mui-content-padded">
                    <div class="uk-text-danger uk-text-center">
                        当前账户余额不满 100 元 不能提现
                    </div>
                </div>

            @endif

        </form>
    </div>


@endsection