@foreach($records as $record)
    <li class="mui-table-view-cell">
        <div class="mui-table">
            <div class="mui-table-cell mui-col-xs-8">
                <h4 class="mui-ellipsis">
                    <span class="uk-text-success">￥{{$record['money']}}</span>
                </h4>
                <p class="mui-h6 mui-ellipsis"><i class="uk-icon-clock-o"></i> {{$record['created_at']}}</p>
                <p class="mui-h6 mui-ellipsis">到账金额：<span class="uk-text-success">￥{{$record['moneyAfterTax']}}</span></p>
                <p class="mui-h6 mui-ellipsis">备注：{{$record['remark']}}</p>
                <p class="mui-h6 mui-ellipsis">
                    @if($record['type']==\TechSoft\Laravel\MemberMoney\Types\MemberMoneyCashType::ALIPAY)
                        支付宝
                        -
                        {{$record['realname']}}
                        -
                        {{$record['account']}}
                    @endif
                </p>
            </div>
            <div class="mui-table-cell mui-col-xs-4 mui-text-right">
                <span class="mui-h5">
                    @if($record['status']==\TechSoft\Laravel\MemberMoney\Types\MemberMoneyCashStatus::VERIFYING)
                        <span class="mui-badge mui-badge-danger">等待发放</span>
                    @endif
                    @if($record['status']==\TechSoft\Laravel\MemberMoney\Types\MemberMoneyCashStatus::SUCCESS)
                        <span class="mui-badge mui-badge-success">已经发放</span>
                    @endif
                </span>
            </div>
        </div>
    </li>
@endforeach