@extends('theme.default.m.frame')

@section('pageTitleMain','搜索 '.htmlspecialchars($keyword).' 的结果')

@section('bodyScript')
    @parent
    <script>
        (function () {
            $('.pb-search-bar').show();
            var $container = $('#list');
            var infiniteScroller = new window.api.infiniteScroller({
                container: window,
                tail: $container.find('.loading'),
                autoStart: false,
                initCallback: function () {
                },
                nextCallback: function (page) {
                    $.post('?', {keyword:<?php echo json_encode($keyword); ?>,page: page}, function (res) {
                        window.api.base.defaultFormCallback(res, {
                            success: function () {
                                $container.find('.list').append(res.data.html);
                                $("[datetime]").timeago();
                                $('[data-src]').lazyload({data_attribute: 'src'});
                                if (res.data.html) {
                                    infiniteScroller.nextDone();
                                } else {
                                    infiniteScroller.done();
                                }
                            }
                        });
                    });
                },
                doneCallback: function () {
                    $container.find('.loading').hide();
                    $container.find('.no-more').show();
                },
                resetCallback: function () {
                    $container.find('.list').html('');
                    $container.find('.loading').show();
                    $container.find('.no-more').hide();
                }
            });

            infiniteScroller.setPage(1);
            infiniteScroller.start();
        })();
    </script>
@endsection

@section('bodyContent')

    <div class="pb pb-search-bar uk-margin-bottom-remove uk-margin-top-remove">
        <div class="body uk-padding-bottom-remove">
            <?php
            $searchUrl = '/search';
            if(in_array($base_request_path,['/search/note','/search/user','/search/topic'])){
                $searchUrl = $base_request_path;
            }
            ?>
            <form action="{{$searchUrl}}" class="search" method="get">
                <div class="mui-input-row mui-search">
                    <input type="search" class="mui-input-clear" name="keyword" placeholder="搜索 文章/专题/用户" value="{{\Illuminate\Support\Facades\Input::get('keyword')}}">
                </div>
            </form>
        </div>
    </div>

    <div class="pb pb-tab">
        <div class="body">
            <div class="uk-grid">
                <div class="uk-width-1-3">
                    <a class="item @if(in_array($base_request_path,['/search/note'])) active @endif" href="/search/note?keyword={{urlencode($keyword)}}"><i class="uk-icon-list"></i> 文章</a>
                </div>
                <div class="uk-width-1-3">
                    <a class="item @if(in_array($base_request_path,['/search/topic'])) active @endif" href="/search/topic?keyword={{urlencode($keyword)}}"><i class="uk-icon-cube"></i> 专题</a>
                </div>
                <div class="uk-width-1-3">
                    <a class="item @if(in_array($base_request_path,['/search/user'])) active @endif" href="/search/user?keyword={{urlencode($keyword)}}"><i class="uk-icon-users"></i> 用户</a>
                </div>
            </div>
        </div>
    </div>

    @if($base_request_path=='/search/note')
        <div id="list" class="pb pb-note-list uk-margin-top-remove">
            <div class="body">
                <div class="list">
                </div>
                <div class="loading">
                    <i class="uk-icon-refresh uk-icon-spin"></i>
                    正在加载...
                </div>
                <div class="no-more">
                    没有更多了~
                </div>
            </div>
        </div>
    @endif

    @if($base_request_path=='/search/topic')
        <div id="list" class="pb pb-topic-list uk-margin-top-remove">
            <div class="body">
                <div class="list">
                </div>
                <div class="loading">
                    <i class="uk-icon-refresh uk-icon-spin"></i>
                    正在加载...
                </div>
                <div class="no-more">
                    没有更多了~
                </div>
            </div>
        </div>
    @endif

    @if($base_request_path=='/search/user')
        <div id="list" class="pb pb-member-list uk-margin-top-remove">
            <div class="body">
                <div class="list">
                </div>
                <div class="loading">
                    <i class="uk-icon-refresh uk-icon-spin"></i>
                    正在加载...
                </div>
                <div class="no-more">
                    没有更多了~
                </div>
            </div>
        </div>
    @endif

@endsection