@extends('theme.default.m.frame')

@if($topic)
    @section('pageTitleMain','修改专题')
@else
    @section('pageTitleMain','新建专题')
@endif

@section('bodyScript')
    @parent
    <script>
        $(function () {
            var $pushVerifyBox = $('#pushVerifyBox');
            var check = function () {
                if($('input[name=pushEnable]:checked').val()==1){
                    $pushVerifyBox.show();
                }else{
                    $pushVerifyBox.hide();
                }
            };
            $('input[name=pushEnable]').on('change',check);
            check();
        });
    </script>
@endsection

@section('bodyContent')

    <div class="pb">

        <form action="?" method="post" data-ajax-form onsubmit="return false;">

            <div class="mui-input-group">
                <div class="mui-input-row">
                    <label>名称</label>
                    <input name="title" type="text" class="mui-input-clear mui-input" placeholder="请输入" value="{{$topic['title'] or ''}}">
                </div>
                <div class="mui-input-row image">
                    <label>封面</label>
                    <div class="file">
                        <div data-image-widget>
                            <input type="hidden" name="cover" data-image value="{{$topic['cover'] or ''}}" />
                            @if(empty($topic['cover']))
                                <span class="image" style="background-image:url(@assets('assets/lib/img/none.png'));"></span>
                            @else
                                <span class="image" style="background-image:url({{\TechSoft\Laravel\Assets\AssetsUtil::fix($topic['cover'])}});"></span>
                            @endif
                            <span class="add"><i class="uk-icon-plus"></i></span>
                            <span class="delete"><i class="uk-icon-remove"></i></span>
                        </div>
                    </div>
                </div>
            </div>

            <div class="mui-input-group">
                <div class="mui-input-row mui-radio mui-left">
                    <label>
                        <input type="radio" @if(!$topic || !empty($topic['pushEnable'])) checked @endif name="pushEnable" value="1" >
                        允许投稿
                    </label>
                </div>
                <div class="mui-input-row mui-radio mui-left">
                    <label>
                        <input type="radio" @if($topic && empty($topic['pushEnable'])) checked @endif name="pushEnable" value="0" >
                        不允许投稿
                    </label>
                </div>
            </div>

            <div id="pushVerifyBox" style="display:none;">
                <div class="mui-input-group">
                    <div class="mui-input-row mui-radio mui-left">
                        <label>
                            <input type="radio" @if(!$topic || !empty($topic['pushVerify'])) checked @endif name="pushVerify" value="1" >
                            投稿需要审核
                        </label>
                    </div>
                    <div class="mui-input-row mui-radio mui-left">
                        <label>
                            <input type="radio" @if($topic && empty($topic['pushVerify'])) checked @endif name="pushVerify" value="0" >
                            投稿不需要审核
                        </label>
                    </div>
                </div>
            </div>

            <h5 class="mui-content-padded">描述</h5>
            <div class="mui-input-row mui-content-padded">
                <textarea name="description" rows="2" placeholder="输入您的专题描述">{{$topic['description'] or ''}}</textarea>
            </div>

            <div class="mui-content-padded">
                <button type="submit" class="mui-btn mui-btn-block mui-btn-primary">提交</button>
            </div>

        </form>

    </div>

@endsection