@extends('theme.default.pc.frame')

@section('pageTitleMain','关注的专题')

@section('bodyScript')
    @parent
    <script>
        (function () {
            var currentPage = 1;
            var load = function (page) {
                currentPage = page || currentPage;
                $.post('?',{page:page},function (res){
                    window.api.base.defaultFormCallback(res,{success:function(res){
                        $('#list').html(res.data.html);
                        pager.render(res.data.total,res.data.pageSize,res.data.page);
                        $("[datetime]").timeago();
                    }});
                });
            };
            var pager = new window.api.pager('.page-container',load,{jump:false,total:false});
            pager.render({{$total}},{{$pageSize}},1);
            window.__refresh = load;
        })();
    </script>
@endsection

@section('bodyContent')

    <div class="main-container">

        <div class="uk-grid">
            <div class="uk-width-1-4">

                <div class="pb pb-member-profile-menu">
                    <div class="body">
                        <div class="list">
                            <a class="active" href="/follow/topics"><i class="uk-icon-cube"></i> 关注的专题</a>
                            <a href="/follow/users"><i class="uk-icon-users"></i> 关注的用户</a>
                        </div>
                    </div>
                </div>

                <div class="pb pb-home-writing">
                    <div class="body">
                        <a href="/topic/edit">
                            <i class="uk-icon-edit"></i>
                            创建我的专题
                        </a>
                    </div>
                </div>

                <div class="pb pb-home-topic-list">
                    <div class="head">
                        <h2>推荐专题</h2>
                    </div>
                    <div class="body">
                        @if(empty($hotTopics))
                            <div class="empty">暂无推荐专题</div>
                        @else
                            @foreach($hotTopics as $topic)
                                <a href="/t/{{$topic['alias']}}" class="item">
                                <span class="contribute">
                                    投稿
                                </span>
                                <span class="name">
                                    <img src="{{\TechSoft\Laravel\Assets\AssetsUtil::fix($topic['cover'])}}" />
                                    {{$topic['title']}}
                                </span>
                                </a>
                            @endforeach
                        @endif
                    </div>
                </div>

            </div>
            <div class="uk-width-3-4">

                <div class="pb pb-note-list" style="margin-top:15px;">
                    <div class="head" style="border-bottom:none;">
                        <div class="uk-tab">
                            <li class="uk-active"><a href="javascript:;"><i class="uk-icon-list"></i> 最新文章</a></li>
                        </div>
                    </div>
                    <div class="body" id="list">
                        @include('theme.default.pc.fragment.noteListItems')
                    </div>
                </div>

                <div class="pb">
                    <div class="page-container"></div>
                </div>

            </div>
        </div>
    </div>


@endsection