@extends('theme.default.pc.frame')

@section('pageTitleMain','关注的用户')

@section('bodyScript')
    @parent
    <script>
        (function () {
            var currentPage = 1;
            var load = function (page) {
                currentPage = page || currentPage;
                $.post('?',{page:page},function (res){
                    window.api.base.defaultFormCallback(res,{success:function(res){
                        $('#list').html(res.data.html);
                        pager.render(res.data.total,res.data.pageSize,res.data.page);
                        $("[datetime]").timeago();
                    }});
                });
            };
            var pager = new window.api.pager('.page-container',load,{jump:false,total:false});
            pager.render({{$total}},{{$pageSize}},1);
            window.__refresh = load;
        })();
    </script>
@endsection

@section('bodyContent')

    <div class="main-container">

        <div class="uk-grid">
            <div class="uk-width-1-4">

                <div class="pb pb-member-profile-menu">
                    <div class="body">
                        <div class="list">
                            <a href="/follow/topics"><i class="uk-icon-cube"></i> 关注的专题</a>
                            <a class="active" href="/follow/users"><i class="uk-icon-users"></i> 关注的用户</a>
                        </div>
                    </div>
                </div>

                <div class="pb pb-home-writing">
                    <div class="body">
                        <a href="/writer">
                            <i class="uk-icon-edit"></i>
                            开始创作
                        </a>
                    </div>
                </div>

                <div class="pb pb-home-member-list">
                    <div class="head">
                        <h2>推荐用户</h2>
                    </div>
                    <div class="body">
                        @if(empty($hotMemberUsers))
                            <div class="empty">暂无记录</div>
                        @else
                            @foreach($hotMemberUsers as $memberUser)
                                <div class="item">
                                    @if($_memberUserId!=$memberUser['id'])
                                        <div class="user-follow-box" data-user-id="{{$memberUser['id']}}">
                                            <a href="javascript:;" class="follow @if(!$memberUser['_isFollowed']) show @endif ">
                                                <i class="uk-icon-plus"></i> 关注
                                            </a>
                                            <a href="javascript:;" class="unfollow @if($memberUser['_isFollowed']) show @endif ">
                                                <i class="uk-icon-minus"></i> 取消关注
                                            </a>
                                        </div>
                                    @endif
                                    <a href="/member/{{$memberUser['id']}}" class="user">
                                        <img src="{{\TechSoft\Laravel\Assets\AssetsUtil::fixOrDefault($memberUser['avatar'],'assets/lib/img/avatar.png')}}" />
                                        {{$memberUser['username']}}
                                    </a>
                                </div>
                            @endforeach
                        @endif
                    </div>
                </div>


            </div>
            <div class="uk-width-3-4">

                <div class="pb pb-note-list" style="margin-top:15px;">
                    <div class="head" style="border-bottom:none;">
                        <div class="uk-tab">
                            <li class="uk-active"><a href="/follow/users"><i class="uk-icon-list"></i> 最新文章</a></li>
                        </div>
                    </div>
                    <div class="body" id="list">
                        @include('theme.default.pc.fragment.noteListItems')
                    </div>
                </div>

                <div class="pb">
                    <div class="page-container"></div>
                </div>

            </div>
        </div>
    </div>


@endsection