@if(empty($topics))
    <div class="empty">
        没有记录
    </div>
@else
    @foreach($topics as $item)
        <div class="item">
            <div class="action">
                @if($_memberUserId)
                    <div class="topic-follow-box" data-topic-id="{{$item['id']}}">
                        <a href="javascript:;" class="follow @if(!$item['_isFollowed']) show @endif ">
                            <i class="uk-icon-plus"></i> 关注
                        </a>
                        <a href="javascript:;" class="unfollow @if($item['_isFollowed']) show @endif ">
                            <i class="uk-icon-minus"></i> 取消关注
                        </a>
                    </div>
                @else
                    <a href="/t/{{$item['alias']}}" class="contribute">
                        <i class="uk-icon-paper-plane"></i> 投稿
                    </a>
                @endif
            </div>
            <a href="/t/{{$item['alias']}}" class="cover">
                <img src="{{\TechSoft\Laravel\Assets\AssetsUtil::fixOrDefault($item['cover'],'assets/lib/img/none.png')}}" />
            </a>
            <a class="name" href="/t/{{$item['alias']}}">
                {{$item['title']}}
            </a>
            <span class="stat">
                关注 {{$item['followerCount'] or 0}}
                ·
                文章 {{$item['noteCount'] or 0}}
            </span>
        </div>
    @endforeach
@endif