<!doctype html>
<html class="no-js">
<head>
    <meta charset="utf-8">
    <link rel="shortcut icon" href="{{\TechSoft\Laravel\Assets\AssetsUtil::fixOrDefault(\TechSoft\Laravel\Config\ConfigUtil::get('siteFavIco'),'default_favicon.ico')}}" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
    <meta name="keywords" content="@yield('pageKeywords',\TechSoft\Laravel\Config\ConfigUtil::get('siteKeywords'))">
    <meta name="description" content="@yield('pageDescription',\TechSoft\Laravel\Config\ConfigUtil::get('siteDescription'))">
    <meta name="viewport" content="width=device-width, minimum-scale=0.5, maximum-scale=5, user-scalable=no">
    <meta name="renderer" content="webkit">
    <meta http-equiv="Cache-Control" content="no-siteapp"/>
    <script src="@assets('assets/init.js')"></script>
    <title>@section('pageTitle')@yield('pageTitleMain') - {{\TechSoft\Laravel\Config\ConfigUtil::get('siteName')}} - {{\TechSoft\Laravel\Config\ConfigUtil::get('siteSlogan')}}@show</title>
    @section('headScript')
        <link rel="stylesheet" href="@assets('assets/uikit/css/ui.css')"/>
        <link rel="stylesheet" href="@assets('theme/default/pc/css/style.css')"/>
    @show
    @section('headAppend')@show
    @if(\TechSoft\Laravel\Config\ConfigUtil::get('systemCounterPosition','head')=='head')
        {!! \TechSoft\Laravel\Config\ConfigUtil::get('systemCounter') !!}
    @endif
</head>
<body>
@section('body')

    @include('base::browserOutdated')

    <header>
        <div class="main-container">
            <nav class="uk-navbar">
                <ul class="uk-navbar-nav uk-navbar-nav-right">
                    @if(empty($_memberUser))
                        <li><a href="/register">注册</a></li>
                        <li><a href="/login">登录</a></li>
                    @else
                        <li @if(in_array($base_request_path,['/member/message'])) class="uk-active" @endif>
                            <a href="/member/message" class="notice">
                                <i class="uk-icon-bell"></i>
                                消息
                                <div class="count @if(($_memberUser['newMessageCount'] || $_memberUser['newChatMsgCount']) && !\Illuminate\Support\Str::startsWith($base_request_path,'/member/message')) show @endif" data-member-notification-count>
                                    {{intval($_memberUser['newMessageCount'])+intval($_memberUser['newChatMsgCount'])}}
                                </div>
                            </a>
                        </li>
                        <li class="uk-parent" data-uk-dropdown>
                            <a href="/member/{{$_memberUser['id']}}" class="username">
                                <img class="avatar" src="{{\TechSoft\Laravel\Assets\AssetsUtil::fixOrDefault($_memberUser['avatar'],'assets/lib/img/avatar.png')}}" />
                                <span>
                                    {{\TechSoft\Laravel\Member\MemberUtil::viewName($_memberUser)}}
                                </span>
                                <i class="uk-icon-caret-down"></i>
                            </a>
                            <div class="uk-dropdown uk-dropdown-navbar uk-dropdown-bottom" style="top: 40px; left: 0px;">
                                <ul class="uk-nav uk-nav-navbar">
                                    <li><a href="/member/{{$_memberUser['id']}}"><i class="uk-icon-user"></i> 我的中心</a></li>
                                    <li><a href="/member/profile"><i class="uk-icon-list-alt"></i> 我的资料</a></li>
                                    <li><a data-confirm="确定退出?" data-href="/logout"><i class="uk-icon-sign-out"></i> 退出</a></li>
                                </ul>
                            </div>
                        </li>
                    @endif
                </ul>
                <a class="uk-navbar-brand" href="/"><img src="{{\TechSoft\Laravel\Assets\AssetsUtil::fixOrDefault(\TechSoft\Laravel\Config\ConfigUtil::get('siteLogo'),'/placeholder/160x50')}}" /></a>
                <ul class="uk-navbar-nav">
                    <li @if($base_request_path=='/') class="uk-active" @endif><a href="/">发现</a></li>
                    <li @if($base_request_path=='/topics') class="uk-active" @endif><a href="/topics">专题</a></li>
                    <li @if(\Illuminate\Support\Str::startsWith($base_request_path,'/follow')) class="uk-active" @endif><a href="/follow/topics">关注</a></li>
                    @if(!empty($_memberUser))
                        <li ><a href="/writer">写作模式</a></li>
                    @endif
                    <li>
                        <?php
                            $searchUrl = '/search';
                            if(in_array($base_request_path,['/search/note','/search/user','/search/topic'])){
                                $searchUrl = $base_request_path;
                            }
                        ?>
                        <form action="{{$searchUrl}}" class="search uk-form" method="get">
                            <input type="text" name="keyword" value="{{\Illuminate\Support\Facades\Input::get('keyword')}}" placeholder="搜索 文章/专题/用户" />
                            <button type="submit"><i class="uk-icon-search"></i></button>
                        </form>
                    </li>
                </ul>
            </nav>
        </div>
    </header>

    @section('bodyContent')@show

    <footer>
        <div class="main-container">
            <div class="articles">
                @foreach($footerArticles as $footerArticle)
                    <a href="/article/{{$footerArticle['id']}}">{{$footerArticle['title']}}</a>
                @endforeach
            </div>
            <div class="copyright">
                <a href="http://www.miitbeian.gov.cn" target="_blank">{{\TechSoft\Laravel\Config\ConfigUtil::get('siteBeian','[网站备案信息]')}}</a>
                &copy;
                {{\TechSoft\Laravel\Config\ConfigUtil::get('siteDomain')}}
                @if(\TechSoft\Laravel\Config\ConfigUtil::get('systemCounterPosition','head')=='body')
                    {!! \TechSoft\Laravel\Config\ConfigUtil::get('systemCounter') !!}
                @endif
            </div>
        </div>
    </footer>

    <div class="pb-footer-toolbox">
        <a href="javascript:;" class="top" data-uk-smooth-scroll="{offset:0}" data-uk-tooltip="{pos:'left'}" title="返回顶部">
            <i class="uk-icon-arrow-up"></i>
        </a>
    </div>

@show
@section('bodyScript')
    <script src="@assets('assets/main/basic.js')"></script>
@show
@section('bodyAppend')@show
</body>
</html>
