@extends('theme.default.pc.frame')

@section('pageTitle',htmlspecialchars(\TechSoft\Laravel\Config\ConfigUtil::get('siteName').' - '.\TechSoft\Laravel\Config\ConfigUtil::get('siteSlogan')))

@section('bodyScript')
    <script src="@assets('assets/main/home.js')"></script>
@endsection

@section('bodyContent')


    <div class="main-container">

        <div class="pb pb-banner">
            <div class="swiper-container">
                <div class="swiper-wrapper">
                    @if(empty($banners))
                        <a href="javascript:;" class="swiper-slide" style="background-image:url('/placeholder/1400x300');"></a>
                        <a href="javascript:;" class="swiper-slide" style="background-image:url('/placeholder/1400x300');"></a>
                        <a href="javascript:;" class="swiper-slide" style="background-image:url('/placeholder/1400x300');"></a>
                    @else
                        @foreach($banners as $banner)
                            <a class="swiper-slide"
                               style="background-image:url({{\TechSoft\Laravel\Assets\AssetsUtil::fix($banner['image'])}});"
                               @if($banner['link']) href="{{$banner['link']}}" target="_blank" @else href="javascript:;" @endif></a>
                        @endforeach
                    @endif
                </div>
                <div class="swiper-pagination swiper-pagination-white"></div>
                <div class="swiper-button-next swiper-button-white"></div>
                <div class="swiper-button-prev swiper-button-white"></div>
            </div>
        </div>

        <div class="uk-grid">
            <div class="uk-width-2-3">

                <div class="pb pb-note-list" style="margin-top:15px;">
                    <div class="head" style="border-bottom:none;">
                        <div class="uk-tab" data-uk-switcher="{connect:'#noteBox'}">
                            <li><a href="javascript:;"><i class="uk-icon-list"></i> 推荐文章</a></li>
                            <li><a href="javascript:;"><i class="uk-icon-list-alt"></i> 热论文章</a></li>
                            <li><a href="javascript:;"><i class="uk-icon-fire"></i> 最热文章</a></li>
                            <li><a href="javascript:;"><i class="uk-icon-list"></i> 最新文章</a></li>
                        </div>
                    </div>
                    <div class="body">
                        <div id="noteBox" class="uk-switcher">
                            <div id="recommendNotes">
                                <div class="list">
                                    <?php $notes = $recommendNotes; ?>
                                    @include('theme.default.pc.fragment.noteListItems')
                                </div>
                                <div class="loading">
                                    <i class="uk-icon-refresh uk-icon-spin"></i>
                                    正在加载...
                                </div>
                                <div class="no-more">
                                    没有更多了~
                                </div>
                            </div>
                            <div id="commentNotes">
                                <div class="list">
                                    <?php $notes = $commentNotes; ?>
                                    @include('theme.default.pc.fragment.noteListItems')
                                </div>
                                <div class="loading">
                                    <i class="uk-icon-refresh uk-icon-spin"></i>
                                    正在加载...
                                </div>
                                <div class="no-more">
                                    没有更多了~
                                </div>
                            </div>
                            <div id="hotNotes">
                                <div class="list">
                                    <?php $notes = $hotNotes; ?>
                                    @include('theme.default.pc.fragment.noteListItems')
                                </div>
                                <div class="loading">
                                    <i class="uk-icon-refresh uk-icon-spin"></i>
                                    正在加载...
                                </div>
                                <div class="no-more">
                                    没有更多了~
                                </div>
                            </div>
                            <div id="latestNotes">
                                <div class="list">
                                    <?php $notes = $latestNotes; ?>
                                    @include('theme.default.pc.fragment.noteListItems')
                                </div>
                                <div class="loading">
                                    <i class="uk-icon-refresh uk-icon-spin"></i>
                                    正在加载...
                                </div>
                                <div class="no-more">
                                    没有更多了~
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
            <div class="uk-width-1-3">

                <div class="pb pb-home-writing">
                    <div class="body">
                        <a href="/writer">
                            <i class="uk-icon-edit"></i>
                            @if($_memberUserId)
                                开始创作
                            @else
                                立即登录 开始创作
                            @endif
                        </a>
                    </div>
                </div>

                <div class="pb pb-home-topic-list">
                    <div class="head">
                        <h2>推荐专题</h2>
                    </div>
                    <div class="body">
                        @if(empty($hotTopics))
                            <div class="empty">暂无推荐专题</div>
                        @else
                            @foreach($hotTopics as $topic)
                                <a href="/t/{{$topic['alias']}}" class="item">
                                    <span class="contribute">
                                        投稿
                                    </span>
                                    <span class="name">
                                        <img src="{{\TechSoft\Laravel\Assets\AssetsUtil::fix($topic['cover'])}}" />
                                        {{$topic['title']}}
                                    </span>
                                </a>
                            @endforeach
                        @endif
                    </div>
                </div>

                <div class="pb pb-home-member-list">
                    <div class="head">
                        <div class="uk-tab" data-uk-switcher="{connect:'#userBox'}">
                            <li><a href="javascript:;">推荐用户</a></li>
                            <li><a href="javascript:;">最新用户</a></li>
                        </div>
                    </div>
                    <div class="body">
                        <div id="userBox" class="uk-switcher">
                            <div>
                                @if(empty($hotMemberUsers))
                                    <div class="empty">暂无记录</div>
                                @else
                                    @foreach($hotMemberUsers as $memberUser)
                                        <div class="item">
                                            @if($_memberUserId!=$memberUser['id'])
                                                <div class="user-follow-box" data-user-id="{{$memberUser['id']}}">
                                                    <a href="javascript:;" class="follow @if(!$memberUser['_isFollowed']) show @endif ">
                                                        <i class="uk-icon-plus"></i> 关注
                                                    </a>
                                                    <a href="javascript:;" class="unfollow @if($memberUser['_isFollowed']) show @endif ">
                                                        <i class="uk-icon-minus"></i> 取消关注
                                                    </a>
                                                </div>
                                            @endif
                                            <a href="/member/{{$memberUser['id']}}" class="user">
                                                <img src="{{\TechSoft\Laravel\Assets\AssetsUtil::fixOrDefault($memberUser['avatar'],'assets/lib/img/avatar.png')}}" />
                                                {{$memberUser['username']}}
                                            </a>
                                        </div>
                                    @endforeach
                                @endif
                            </div>
                            <div>
                                @if(empty($latestMemberUsers))
                                    <div class="empty">暂无记录</div>
                                @else
                                    @foreach($latestMemberUsers as $memberUser)
                                        <div class="item">
                                            @if($_memberUserId && $_memberUserId!=$memberUser['id'])
                                                <div class="user-follow-box" data-user-id="{{$memberUser['id']}}">
                                                    <a href="javascript:;" class="follow @if(!$memberUser['_isFollowed']) show @endif ">
                                                        <i class="uk-icon-plus"></i> 关注
                                                    </a>
                                                    <a href="javascript:;" class="unfollow @if($memberUser['_isFollowed']) show @endif ">
                                                        <i class="uk-icon-minus"></i> 取消关注
                                                    </a>
                                                </div>
                                            @endif
                                            <a href="/member/{{$memberUser['id']}}" class="user">
                                                <img src="{{\TechSoft\Laravel\Assets\AssetsUtil::fixOrDefault($memberUser['avatar'],'assets/lib/img/avatar.png')}}" />
                                                {{$memberUser['username']}}
                                            </a>
                                        </div>
                                    @endforeach
                                @endif
                            </div>
                        </div>
                    </div>
                </div>

                @if(\TechSoft\Laravel\Config\ConfigUtil::get('customPCHomeSideBannerImage'))
                    <div class="pb pb-side-banner">
                        @if(\TechSoft\Laravel\Config\ConfigUtil::get('customPCHomeSideBannerUrl'))
                            <a href="{{\TechSoft\Laravel\Config\ConfigUtil::get('customPCHomeSideBannerUrl')}}" target="_blank">
                                <img src="{{\TechSoft\Laravel\Assets\AssetsUtil::fix(\TechSoft\Laravel\Config\ConfigUtil::get('customPCHomeSideBannerImage'))}}" />
                            </a>
                        @else
                            <img src="{{\TechSoft\Laravel\Assets\AssetsUtil::fix(\TechSoft\Laravel\Config\ConfigUtil::get('customPCHomeSideBannerImage'))}}" />
                        @endif
                    </div>
                @endif

            </div>
        </div>

    </div>

@endsection