@extends('theme.default.pc.member.frame')

@section('pageTitleMain',$memberUser['username'])

@section('bodyScript')
    @parent
    <script>
        (function () {
            var pager = new window.api.pager('.page-container',function (page) {
                $.post('?',{page:page},function (res) {
                    window.api.base.defaultFormCallback(res,{success:function(res){
                        $('#list').html(res.data.html);
                        pager.render(res.data.total,res.data.pageSize,res.data.page);
                    }});
                });
            },{jump:false,total:false});
            pager.render({{$total}},{{$pageSize}},1);
        })();
    </script>
@endsection

@section('memberBodyContent')

    <div class="pb pb-member-list-tab">
        <div class="body">
            <div class="menu">
                <a href="/member/{{$memberUser['id']}}/like_notes"><i class="uk-icon-heart-o"></i> 喜欢的文章</a>
                <a class="active" href="/member/{{$memberUser['id']}}/followed_topics"><i class="uk-icon-th"></i> 关注的专题</a>
            </div>
        </div>
    </div>

    <div class="pb pb-topic-list">
        <div class="body" id="list">
            @include('theme.default.pc.fragment.topicListItems')
        </div>
    </div>

    <div class="pb">
        <div class="page-container"></div>
    </div>

@endsection