@extends('theme.default.pc.member.frame')

@section('pageTitleMain',$memberUser['username'])

@section('bodyScript')
    @parent
    <script>
        (function () {
            var pager = new window.api.pager('.page-container',function (page) {
                $.post('?',{page:page},function (res) {
                    window.api.base.defaultFormCallback(res,{success:function(res){
                        $('#list').html(res.data.html);
                        pager.render(res.data.total,res.data.pageSize,res.data.page);
                    }});
                });
            },{jump:false,total:false});
            pager.render({{$total}},{{$pageSize}},1);
        })();
    </script>
@endsection

@section('memberBodyContent')

    <div class="pb pb-member-list-tab">
        <div class="body">
            <div class="menu">
                <a href="/member/{{$memberUser['id']}}/following"><i class="uk-icon-heart-o"></i> 关注用户</a>
                <a class="active" href="/member/{{$memberUser['id']}}/followers"><i class="uk-icon-users"></i> 粉丝</a>
            </div>
        </div>
    </div>

    <div class="pb pb-member-list">
        <div class="body" id="list">
            @include('theme.default.pc.fragment.memberUserListItems')
        </div>
    </div>

    <div class="pb">
        <div class="page-container"></div>
    </div>

@endsection