@extends('theme.default.pc.frame')

@section('bodyContent')

    <div class="main-container">

        <div class="uk-grid">
            <div class="uk-width-2-3">

                <div class="pb pb-member-info">

                    <div class="body">

                        <div class="box">
                            <div class="avatar">
                                <a href="/member/{{$memberUser['id']}}">
                                    <img src="{{\TechSoft\Laravel\Assets\AssetsUtil::fixOrDefault($memberUser['avatarBig'],'assets/lib/img/avatar_big.png')}}" />
                                </a>
                            </div>
                            @if($_memberUserId && $_memberUserId!=$memberUser['id'])
                                <div class="action">
                                    <a href="/member/message_chat_create/{{$memberUser['id']}}" class="msg">
                                        <i class="uk-icon-comment"></i>
                                        发私信
                                    </a>
                                    <div class="user-follow-box" data-user-id="{{$memberUser['id']}}">
                                        <a href="javascript:;" class="follow @if(!$memberUser['_isFollowed']) show @endif ">
                                            <i class="uk-icon-plus"></i> 关注
                                        </a>
                                        <a href="javascript:;" class="unfollow @if($memberUser['_isFollowed']) show @endif ">
                                            <i class="uk-icon-minus"></i> 取消关注
                                        </a>
                                    </div>
                                </div>
                            @endif
                            <div class="name">
                                <a href="/member/{{$memberUser['id']}}">
                                    {{$memberUser['username']}}
                                </a>
                                @if($memberUser['gender']==\TechSoft\Laravel\Member\Type\Gender::MALE)
                                    <span class="gender male"><i class="uk-icon-male"></i></span>
                                @endif
                                @if($memberUser['gender']==\TechSoft\Laravel\Member\Type\Gender::FEMALE)
                                    <span class="gender female"><i class="uk-icon-female"></i></span>
                                @endif
                            </div>
                            <div class="stat">
                                <a href="/member/{{$memberUser['id']}}/following">
                                    <span>{{$memberUser['followCount'] or 0}}</span>
                                    <br>
                                    关注
                                </a>
                                <a href="/member/{{$memberUser['id']}}/followers">
                                    <span>{{$memberUser['followerCount'] or 0}}</span>
                                    <br>
                                    粉丝
                                </a>
                                <a class="info" href="javascript:;">
                                    <span>{{$memberUser['wordCount'] or 0}}</span>
                                    <br>
                                    字数
                                </a>
                                <a class="info" href="javascript:;">
                                    <span>{{$memberUser['noteCount'] or 0}}</span>
                                    <br>
                                    文章
                                </a>
                            </div>
                        </div>

                    </div>

                </div>

                @section('memberBodyContent')@show


            </div>
            <div class="uk-width-1-3">

                <div class="pb">
                    <div class="head">
                        @if($_memberUser['id']==$memberUser['id'])
                            <div class="more">
                                <a href="/member/profile_setting" class="uk-text-muted"><i class="uk-icon-edit"></i></a>
                            </div>
                        @endif
                        <h2>
                            个人介绍
                        </h2>
                    </div>
                    <div class="body">
                        @if($memberUser['signature'])
                            {!! \TechSoft\Laravel\Util\HtmlUtil::text2html($memberUser['signature']) !!}
                        @else
                            <p class="uk-text-muted">这个家伙很懒，什么也没留下~</p>
                        @endif
                    </div>
                </div>

                <div class="pb-spacer"></div>

                <div class="pb pb-member-right-menu">
                    <div class="body">
                        <a href="/member/{{$memberUser['id']}}/like_notes" class="item">
                            <i class="uk-icon-heart-o"></i>
                            喜欢的文章
                        </a>
                        <a href="/member/{{$memberUser['id']}}/followed_topics" class="item">
                            <i class="uk-icon-list"></i>
                            关注的专题
                        </a>
                    </div>
                </div>

                <div class="pb-spacer"></div>

                <div class="pb pb-simple-topic-list">
                    <div class="head">
                        @if($_memberUser['id']==$memberUser['id'])
                            <div class="more">
                                <a href="/topic/edit">
                                    <i class="uk-icon-plus"></i> 新建专题
                                </a>
                            </div>
                        @endif
                        <h2>
                            @if($_memberUser['id']==$memberUser['id'])
                                我创建的专题
                            @else
                                TA创建的专题
                            @endif
                        </h2>
                    </div>
                    <div class="body">
                        @if(empty($topics))
                            <div class="empty">
                                暂无专题~
                            </div>
                        @else
                            @foreach($topics as $topic)
                                <a href="/t/{{$topic['alias']}}" class="item">
                                    <img src="{{\TechSoft\Laravel\Assets\AssetsUtil::fix($topic['cover'])}}" />
                                    {{$topic['title']}}
                                </a>
                            @endforeach
                        @endif
                    </div>
                </div>

            </div>
        </div>

    </div>

@endsection