@extends('theme.default.pc.frame')

@section('pageTitleMain','消息通知')

@section('bodyScript')
    @parent
    <script>
        (function () {
            var currentPage = 1;
            var load = function (page) {
                currentPage = page || currentPage;
                $.post('?',{page:page},function (res){
                    window.api.base.defaultFormCallback(res,{success:function(res){
                        $('#list').html(res.data.html);
                        pager.render(res.data.total,res.data.pageSize,res.data.page);
                        $("[datetime]").timeago();
                    }});
                });
            };
            var pager = new window.api.pager('.page-container',load,{jump:false,total:false});
            pager.render({{$total}},{{$pageSize}},1);
            window.__refresh = load;
        })();
    </script>
@endsection

@section('bodyContent')

    <div class="main-container">

        <div class="uk-grid">
            <div class="uk-width-1-4">
                @include('theme.default.pc.memberMessage.menu')
            </div>
            <div class="uk-width-3-4">

                <div class="pb pb-member-chat-list">
                    <div class="head">
                        <div class="more">
                            <a href="javascript:;" class="uk-text-muted" data-ajax-request-loading data-ajax-request="/member/message_chat_mark_all_read">全部标记已读</a>
                        </div>
                        <h2>
                            我的私信
                        </h2>
                    </div>
                    <div class="body" id="list">
                        @include('theme.default.pc.memberMessage.chatItems')
                    </div>
                </div>

                <div class="pb">
                    <div class="page-container"></div>
                </div>

            </div>
        </div>
    </div>


@endsection