@if(empty($chats))
    <div class="empty">
        暂无记录
    </div>
@else
    @foreach($chats as $chat)
        <div class="item">
            <a href="javascript:;" data-confirm="确定删除?" data-ajax-request-loading data-ajax-request="/member/message_chat_delete/{{$chat['id']}}" class="remove" data-uk-tooltip title="删除对话"><i class="uk-icon-trash"></i></a>
            <a href="/member/{{$chat['chatMemberUserId']}}" target="_blank" class="avatar">
                <img src="{{\TechSoft\Laravel\Assets\AssetsUtil::fixOrDefault($chat['_chatMemberUser']['avatar'],'assets/lib/img/avatar.png')}}" />
            </a>
            <div class="summary">
                <a href="/member/{{$chat['_lastMsg']['senderMemberUserId']}}" target="_blank">{{$chat['_chatMemberUser']['username']}}</a>
                @if($chat['_lastMsg'])
                    ·
                    <time datetime="{{$chat['_lastMsg']['created_at']}}"></time>
                    ·
                    <span class="uk-text-muted">
                        @if($chat['_lastMsg']['senderMemberUserId']==$_memberUserId)
                            我
                        @else
                            {{$chat['_chatMemberUser']['username']}}
                        @endif
                        ：
                        {{\TechSoft\Laravel\MemberChat\MemberChatUtil::summary($chat['_lastMsg'])}}
                    </span>
                @endif
            </div>
            <div class="bottom">
                <a class="view" href="/member/message_chat_room/{{$chat['id']}}"><i class="uk-icon-comment"></i> 查看对话</a>
                @if($chat['unreadMsgCount'])
                    <a class="view unread" href="/member/message_chat_room/{{$chat['id']}}">{{$chat['unreadMsgCount']}}条未读</a>
                @endif
            </div>
        </div>
    @endforeach
@endif