@extends('theme.default.pc.frame')

@section('pageTitleMain','我和 '.$chat['_chatMemberUser']['username'].' 的对话')

@section('bodyScript')
    <script>
        var __app = {
            device:'pc',
            url:'/member/message_chat_room/{{$chat['id']}}',
            cdn:"{{\TechSoft\Laravel\Assets\AssetsUtil::cdn()}}"
        };
    </script>
    <script src="@assets('assets/main/memberChat.js')"></script>
@endsection

@section('bodyContent')

    <div class="main-container">

        <div class="uk-grid">
            <div class="uk-width-1-4">
                @include('theme.default.pc.memberMessage.menu')
            </div>
            <div class="uk-width-3-4">

                <div class="pb pb-member-chat-room">
                    <div class="head">
                        <h2>
                            我和
                            <a target="_blank" href="/member/{{$chat['_chatMemberUser']['id']}}">{{$chat['_chatMemberUser']['username']}}</a>
                            的对话
                        </h2>
                    </div>
                    <div class="body">

                        <div class="chat-messages" id="chatMessages" v-cloak>
                            <div class="list">
                                <div class="list-container">
                                    <div class="loading" v-show="initing || loading">
                                        <i class="uk-icon-refresh uk-icon-spin"></i>
                                        正在加载...
                                    </div>
                                    <div class="more" v-show="!initing && hasHistory && !loading" v-on:click="loadMore()">
                                        <i class="uk-icon-angle-double-up"></i>
                                        加载历史
                                    </div>
                                    <div class="empty" v-show="!initing && !hasHistory && !loading && msgs.length==0">
                                        暂无消息
                                    </div>
                                    <div v-for="msg in msgs" class="item" :class="{ send:msg.senderMemberUserId!={{$_memberUserId}} }">
                                        <a :href="'/member/'+msg.senderMemberUserId" class="avatar" target="_blank">
                                            <img :src="msg.senderMemberUserAvatar" />
                                        </a>
                                        <div class="message">
                                            <div class="content">
                                                <span class="arrow"></span>
                                                <div class="text" v-if="msg.type=={{\TechSoft\Laravel\MemberChat\Type\MemberChatMsgType::TEXT}}" v-html="msg.content"></div>
                                                <div class="image" v-if="msg.type=={{\TechSoft\Laravel\MemberChat\Type\MemberChatMsgType::IMAGE}}" v-html="msg.content"></div>
                                                <div class="time">
                                                    <time :datetime="msg.time"></time>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="chat-message-editor" data-message-chat-editor>
                                <a href="/member/{{$_memberUserId}}" target="_blank" class="avatar">
                                    <img src="{{\TechSoft\Laravel\Assets\AssetsUtil::fixOrDefault($_memberUser['avatar'],'assets/lib/img/avatar.png')}}" />
                                </a>
                                <div>
                                    <div class="message-editor">
                                        <textarea id="chatMessageEditor" style="display:none;"></textarea>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>

            </div>
        </div>
    </div>


@endsection
