@extends('theme.default.pc.frame')

@section('pageTitleMain','消息通知')

@section('bodyScript')
    @parent
    <script>
        (function () {
            var currentPage = 1;
            var load = function (page) {
                currentPage = page || currentPage;
                $.post('?',{page:page},function (res){
                    window.api.base.defaultFormCallback(res,{success:function(res){
                        $('#list').html(res.data.html);
                        pager.render(res.data.total,res.data.pageSize,res.data.page);
                        $("[datetime]").timeago();
                    }});
                });
            };
            var pager = new window.api.pager('.page-container',load,{jump:false,total:false});
            pager.render({{$total}},{{$pageSize}},1);
            window.__refresh = load;
        })();
    </script>
@endsection

@section('bodyContent')

    <div class="main-container">

        <div class="uk-grid">
            <div class="uk-width-1-4">
                @include('theme.default.pc.memberMessage.menu')
            </div>
            <div class="uk-width-3-4">

                <div class="pb pb-member-message-list">
                    <div class="head">
                        <div class="more">
                            @if($base_request_path=='/member/message')
                                <a href="/member/message_all" class="uk-text-muted">
                                    <i class="uk-icon-list"></i>
                                    所有消息
                                </a>
                            @else
                                <a href="/member/message" class="uk-text-muted">
                                    <i class="uk-icon-list"></i>
                                    未读消息
                                </a>
                            @endif
                        </div>
                        <h2>
                            @if($base_request_path=='/member/message')
                                未读消息
                            @else
                                所有消息
                            @endif
                        </h2>
                    </div>
                    <div class="body" id="list">
                        @include('theme.default.pc.memberMessage.messageItems')
                    </div>
                </div>

                <div class="pb">
                    <div class="page-container"></div>
                </div>

            </div>
        </div>
    </div>


@endsection