@extends('theme.default.pc.frame')

@section('pageTitle','余额提现')

@section('bodyContent')

    <div class="main-container">

        <div class="uk-grid">
            <div class="uk-width-1-4">
                @include('theme.default.pc.memberProfile.menu')
            </div>
            <div class="uk-width-3-4">
                <div class="pb pb-member-profile-form">
                    <div class="head">
                        <h2>
                            余额提现
                        </h2>
                    </div>
                    <div class="body">
                        <form action="?" class="uk-form" method="post" data-ajax-form>
                            <div class="line">
                                <div class="label">账户余额</div>
                                <div class="field uk-text-danger">
                                    ￥{{sprintf('%0.2f',$total)}}
                                </div>
                            </div>
                            @if($total>=100)
                                <div class="line">
                                    <div class="label">提现金额</div>
                                    <div class="field">
                                        <input type="text" name="money" value="100" />
                                        <div class="help">
                                        </div>
                                    </div>
                                </div>
                                <div class="line">
                                    <div class="label">支付宝姓名</div>
                                    <div class="field">
                                        <input type="text" name="alipayRealname" value="" placeholder="如 张三" />
                                    </div>
                                </div>
                                <div class="line">
                                    <div class="label">支付宝账号</div>
                                    <div class="field">
                                        <input type="text" name="alipayAccount" value="" placeholder="如 tecmz@alipay.com" />
                                    </div>
                                </div>
                                <div class="line">
                                    <div class="label">&nbsp;</div>
                                    <div class="field">
                                        <button type="submit" class="uk-button uk-button-primary uk-button-large">提交</button>
                                    </div>
                                </div>
                            @else
                                <div class="line">
                                    <div class="label">&nbsp;</div>
                                    <div class="field">
                                        <div class="uk-alert uk-alert-danger">
                                            当前账户余额不满 100 元
                                        </div>
                                    </div>
                                </div>
                            @endif
                        </form>
                    </div>
                </div>
            </div>
        </div>

    </div>

@endsection