@extends('theme.default.pc.frame')

@section('pageTitle','提现记录')

@section('bodyScript')
    @parent
    <script>
        (function () {
            var currentPage = 1;
            var load = function (page) {
                currentPage = page || currentPage;
                $.post('?',{page:page},function (res){
                    window.api.base.defaultFormCallback(res,{success:function(res){
                        $('#list').html(res.data.html);
                        pager.render(res.data.total,res.data.pageSize,res.data.page);
                    }});
                });
            };
            var pager = new window.api.pager('.page-container',load,{jump:false,total:false});
            pager.render({{$total}},{{$pageSize}},1);
            window.__refresh = load;
        })();
    </script>
@endsection

@section('bodyContent')

    <div class="main-container">

        <div class="uk-grid">
            <div class="uk-width-1-4">
                @include('theme.default.pc.memberProfile.menu')
            </div>
            <div class="uk-width-3-4">
                <div class="pb pb-member-money">
                    <div class="head">
                        <h2>
                            提现记录
                        </h2>
                    </div>
                    <div class="body">
                        <table class="uk-table">
                            <thead>
                                <tr>
                                    <th>时间</th>
                                    <th>提现金额</th>
                                    <th>实际到账</th>
                                    <th>提现账户</th>
                                    <th>状态</th>
                                    <th>备注</th>
                                </tr>
                            </thead>
                            <tbody id="list">
                                @include('theme.default.pc.memberMoney.cashLogListItems')
                            </tbody>
                        </table>
                        <div class="page-container"></div>
                    </div>
                </div>
            </div>
        </div>

    </div>

@endsection