@if(empty($records))
    <tr>
        <td colspan="6">
            <div class="empty-container">暂无记录</div>
        </td>
    </tr>
@else
    @foreach($records as $record)
        <tr>
            <td>
                <span class="uk-text-muted">{{$record['created_at']}}</span>
            </td>
            <td>
                <span class="uk-text-muted">￥{{$record['money']}}</span>
            </td>
            <td>
                <span class="uk-text-success">￥{{$record['moneyAfterTax']}}</span>
            </td>
            <td>
                @if($record['type']==\TechSoft\Laravel\MemberMoney\Types\MemberMoneyCashType::ALIPAY)
                    <div>
                        支付宝
                        -
                        {{$record['realname']}}
                        -
                        {{$record['account']}}
                    </div>
                @endif
            </td>
            <td>
                @if($record['status']==\TechSoft\Laravel\MemberMoney\Types\MemberMoneyCashStatus::VERIFYING)
                    <span class="uk-text-danger">等待发放</span>
                @endif
                @if($record['status']==\TechSoft\Laravel\MemberMoney\Types\MemberMoneyCashStatus::SUCCESS)
                    <span class="uk-text-success">已经发放</span>
                @endif
            </td>
            <td>{{$record['remark']}}</td>
        </tr>
    @endforeach
@endif