@extends('theme.default.pc.frame')

@section('pageTitleMain','我的资料')

@section('bodyContent')

    <div class="main-container">

        <div class="uk-grid">
            <div class="uk-width-1-4">
                @include('theme.default.pc.memberProfile.menu')
            </div>
            <div class="uk-width-3-4">
                <div class="pb pb-member-profile-form">
                    <div class="head">
                        <h2>个人资料</h2>
                    </div>
                    <div class="body">
                        <form action="?" class="uk-form" method="post" data-ajax-form>
                            <div class="line">
                                <div class="label">头像</div>
                                <div class="field">
                                    <a href="/member/profile_avatar">
                                        <img style="width:80px;height:80px;border-radius:50%;border:1px solid #EEE;" src="{{\TechSoft\Laravel\Assets\AssetsUtil::fixOrDefault($_memberUser['avatar'],'assets/lib/img/avatar.png')}}">
                                    </a>
                                    <br>
                                    <a href="/member/profile_avatar">
                                        [修改头像]
                                    </a>
                                </div>
                            </div>
                            @if(\TechSoft\Laravel\Config\ConfigUtil::get('systemSmsEnable',false))
                                <div class="line">
                                    <div class="label">手机</div>
                                    <div class="field">
                                        @if(empty($_memberUser['phone']))
                                            <a href="/member/profile_phone">[立即绑定]</a>
                                        @else
                                            {{\TechOnline\Utils\StrUtil::mask($_memberUser['phone'],3,6)}}
                                            <a href="/member/profile_phone">[修改]</a>
                                        @endif
                                    </div>
                                </div>
                            @endif
                            @if(\TechSoft\Laravel\Config\ConfigUtil::get('systemEmailEnable',false))
                                <div class="line">
                                    <div class="label">邮箱</div>
                                    <div class="field">
                                        @if(empty($_memberUser['email']))
                                            <a href="/member/profile_email">[立即绑定]</a>
                                        @else
                                            {{$_memberUser['email']}}
                                            <a href="/member/profile_email">[修改]</a>
                                        @endif
                                    </div>
                                </div>
                            @endif
                            @if(\TechSoft\Laravel\Config\ConfigUtil::get('oauthWechatEnable',false))
                                <div class="line">
                                    <div class="label">绑定微信PC</div>
                                    <div class="field">
                                        @if($isWechatAuth)
                                            <div class="uk-text-success">已绑定</div>
                                        @else
                                            <a target="_blank" href="/oauth_login_wechat?redirect={{urlencode($base_request_path)}}">立即绑定</a>
                                        @endif
                                    </div>
                                </div>
                            @endif
                            @if(\TechSoft\Laravel\Config\ConfigUtil::get('oauthQQEnable',false))
                                <div class="line">
                                    <div class="label">绑定QQ</div>
                                    <div class="field">
                                        @if($isQQAuth)
                                            <div class="uk-text-success">已绑定</div>
                                        @else
                                            <a target="_blank" href="/oauth_login_qq?redirect={{urlencode($base_request_path)}}">立即绑定</a>
                                        @endif
                                    </div>
                                </div>
                            @endif
                            @if(\TechSoft\Laravel\Config\ConfigUtil::get('oauthWeiboEnable',false))
                                <div class="line">
                                    <div class="label">绑定微博</div>
                                    <div class="field">
                                        @if($isWeiboAuth)
                                            <div class="uk-text-success">已绑定</div>
                                        @else
                                            <a target="_blank" href="/oauth_login_weibo?redirect={{urlencode($base_request_path)}}">立即绑定</a>
                                        @endif
                                    </div>
                                </div>
                            @endif
                        </form>
                    </div>
                </div>
            </div>
        </div>

    </div>

@endsection