@extends('theme.default.pc.frame')

@section('pageTitle','基本设置')

@section('bodyContent')

    <div class="main-container">

        <div class="uk-grid">
            <div class="uk-width-1-4">
                @include('theme.default.pc.memberProfile.menu')
            </div>
            <div class="uk-width-3-4">
                <div class="pb pb-member-profile-form">
                    <div class="head">
                        <h2>基本设置</h2>
                    </div>
                    <div class="body">
                        <form action="?" class="uk-form" method="post" data-ajax-form>
                            <div class="line">
                                <div class="label">性别</div>
                                <div class="field">
                                    <label>
                                        <input @if($_memberUser['gender']==\TechSoft\Laravel\Member\Type\Gender::MALE) checked @endif type="radio" name="gender" value="{{\TechSoft\Laravel\Member\Type\Gender::MALE}}">
                                        <i class="uk-icon-male"></i> 男
                                    </label>
                                    &nbsp;&nbsp;
                                    <label>
                                        <input @if($_memberUser['gender']==\TechSoft\Laravel\Member\Type\Gender::FEMALE) checked @endif type="radio" name="gender" value="{{\TechSoft\Laravel\Member\Type\Gender::FEMALE}}">
                                        <i class="uk-icon-female"></i> 女
                                    </label>
                                </div>
                            </div>
                            <div class="line">
                                <div class="label">签名</div>
                                <div class="field">
                                    <textarea name="signature" class="uk-width-3-4 uk-form-large" rows="5">{{$_memberUser['signature']}}</textarea>
                                    <div class="help">
                                        最多400字
                                    </div>
                                </div>
                            </div>
                            <div class="line">
                                <div class="label">常用编辑器</div>
                                <div class="field">
                                    <label>
                                        <input @if(!$_memberUser['noteEditorType'] || $_memberUser['noteEditorType']==\TechSoft\Laravel\Html\HtmlType::RICH_TEXT) checked @endif type="radio" name="noteEditorType" value="{{\TechSoft\Laravel\Html\HtmlType::RICH_TEXT}}">
                                        富文本
                                    </label>
                                    &nbsp;&nbsp;
                                    <label>
                                        <input @if($_memberUser['noteEditorType']==\TechSoft\Laravel\Html\HtmlType::MARKDOWN) checked @endif type="radio" name="noteEditorType" value="{{\TechSoft\Laravel\Html\HtmlType::MARKDOWN}}">
                                        Markdown
                                    </label>
                                    <div class="help">
                                        切换后对新建文章生效
                                    </div>
                                </div>
                            </div>
                            <div class="line">
                                <div class="label">&nbsp;</div>
                                <div class="field">
                                    <button type="submit" class="uk-button uk-button-primary uk-button-large">提交</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>

    </div>

@endsection