@if(empty($topics))
    <div class="empty">
        没有记录
    </div>
@else
    @foreach($topics as $topic)
        <div class="item">
            <div class="action">
                @if($topic['_hasNote'])
                    <a href="javascript:;" class="revert" data-uk-tooltip title="点击撤回" data-ajax-request-loading data-ajax-request="/topic/note_remove/{{$topic['id']}}/{{$note['id']}}">已收录</a>
                @else
                    <a href="javascript:;" data-ajax-request-loading data-ajax-request="/topic/note_add/{{$topic['id']}}/{{$note['id']}}">收录</a>
                @endif
            </div>
            <a href="/t/{{$topic['alias']}}" class="title" target="_blank">
                <img src="{{\TechSoft\Laravel\Assets\AssetsUtil::fixOrDefault($topic['cover'],'assets/lib/img/none.png')}}" />
                {{$topic['title']}}
            </a>
        </div>
    @endforeach
@endif