@if(empty($comments))
    <div class="empty">
        暂无评论
    </div>
@else
    @foreach($comments as $comment)
        <div class="item" data-comment-id="{{$comment['id']}}">
            <div class="user">
                <a href="/member/{{$comment['_memberUser']['id']}}" class="avatar">
                    <img src="{{\TechSoft\Laravel\Assets\AssetsUtil::fixOrDefault($comment['_memberUser']['avatar'],'assets/lib/img/avatar.png')}}" />
                </a>
                <a class="name" href="/member/{{$comment['_memberUser']['id']}}">
                    {{$comment['_memberUser']['username']}}
                </a>
                <div class="time">
                    {{$comment['created_at']}}
                </div>
            </div>
            <div class="message">
                {!! $comment['content'] !!}
            </div>
            <div class="stat">
                <a class="like @if($comment['_isLiked']) liked @endif" data-note-comment-like="{{$comment['id']}}" href="javascript:;">
                    <i class="uk-icon-thumbs-up"></i>
                    <span class="count">{{$comment['likeCount'] or 0}}</span>人赞
                </a>
                <a class="reply" href="javascript:;" data-comment-reply="{{$comment['id']}}" data-comment-content="">
                    <i class="uk-icon-comments"></i>
                    <?php echo empty($comment['_replies'])?0:count($comment['_replies']); ?>人回复
                </a>
                @if($_memberUserId==$comment['memberUserId'])
                    <a href="javascript:;" class="delete" data-comment-delete="{{$comment['id']}}">
                        <i class="uk-icon-trash"></i> 删除
                    </a>
                @endif
            </div>
            <div class="reply">
                <div class="reply-list" data-comment-reply-list="{{$comment['id']}}">
                    @if(!empty($comment['_replies']))
                        @foreach($comment['_replies'] as $reply)
                            @include('theme.default.pc.note.commentReplyItem')
                        @endforeach
                    @endif
                </div>
                <div class="reply-new">
                    <a href="javascript:;" data-comment-reply="{{$comment['id']}}" data-comment-content="">
                        <i class="uk-icon-pencil"></i>
                        添加新评论
                    </a>
                </div>
                <div class="reply-editor" data-comment-reply-editor="{{$comment['id']}}">
                    <textarea style="display:none;"></textarea>
                </div>
            </div>
        </div>
    @endforeach
@endif