@extends('theme.default.pc.frame')

@section('pageTitleMain',htmlspecialchars($note['title']))
@section('pageKeywords',htmlspecialchars($note['title']))
@section('pageDescription',htmlspecialchars($note['_summary']))

@section('bodyScript')
    <script>
        var __app = {
            cdn:"{{\TechSoft\Laravel\Assets\AssetsUtil::cdn()}}",
            noteId:"{{$note['id']}}"
        };
    </script>
    <script src="@assets('assets/main/noteView.js')"></script>
@endsection

@section('bodyContent')

    <div class="main-container" style="max-width:600px;min-width:inherit;">

        <div class="pb pb-note-view">
            <h1>{{$note['title']}}</h1>
            <div class="author-top">
                <a class="avatar" href="/member/{{$note['_memberUser']['id']}}">
                    <img src="{{\TechSoft\Laravel\Assets\AssetsUtil::fixOrDefault($note['_memberUser']['avatar'],'assets/lib/img/avatar.png')}}" />
                </a>
                <div class="user">
                    <a class="name" href="/member/{{$note['_memberUser']['id']}}">
                        {{$note['_memberUser']['username']}}
                    </a>
                    @if($_memberUserId)
                        @if($_memberUserId==$note['_memberUser']['id'])
                            <a class="edit" href="/writer#note/{{$note['memberNoteId']}}">编辑文章</a>
                        @else
                            <div class="user-follow-box" data-user-id="{{$note['_memberUser']['id']}}">
                                <a href="javascript:;" class="follow @if(!$note['_memberUser']['_isFollowed']) show @endif">
                                    <i class="uk-icon-plus"></i> 关注
                                </a>
                                <a href="javascript:;" class="unfollow @if($note['_memberUser']['_isFollowed']) show @endif">
                                    <i class="uk-icon-minus"></i> 取消关注
                                </a>
                            </div>
                        @endif
                    @endif
                </div>
                <div class="stat">
                    <time datetime="{{$note['created_at']}}"></time>发布
                    ·
                    字数 {{$note['wordCount']}}
                    ·
                    阅读 {{$note['viewCount'] or 0}}
                    ·
                    评论 {{$note['commentCount'] or 0}}
                    ·
                    喜欢 {{$note['likeCount'] or 0}}
                </div>
            </div>
            <div class="content html-container">
                {!! \TechSoft\Laravel\Util\HtmlUtil::replaceImageSrcToLazyLoad($note['contentHtml'],'data-src',true) !!}
            </div>
            <div class="content-copyright">
                <a href="javascript:;" data-dialog-request="/note/tip_off/{{$note['id']}}">举报文章</a>
                &copy;著作权归作者所有
            </div>
            @if($note['_memberUser']['tipEnable'])
                <div class="tip">
                    <div class="action">
                        @if($_memberUserId)
                            <a href="javascript:;" data-tip-btn>打赏</a>
                        @else
                            <a href="/login?redirect={{urlencode('/n/'.$note['alias'])}}" data-uk-tooltip title="请先登录后再进行打赏">打赏</a>
                        @endif
                    </div>
                    @if(!empty($note['_noteTips']))
                        <div class="tip-users">
                            <div class="title">打赏过的用户</div>
                            <div class="list">
                                @foreach($note['_noteTips'] as $noteTip)
                                    <a href="/member/{{$noteTip['tipMemberUserId']}}" data-uk-tooltip title="{{$noteTip['_tipMemberUser']['username']}}">
                                        <img src="{{\TechSoft\Laravel\Assets\AssetsUtil::fix($noteTip['_tipMemberUser']['avatar'])}}" />
                                    </a>
                                @endforeach
                            </div>
                        </div>
                    @endif
                </div>
            @endif
            <div class="author-bottom">
                <a class="avatar" href="/member/{{$note['_memberUser']['id']}}">
                    <img src="{{\TechSoft\Laravel\Assets\AssetsUtil::fixOrDefault($note['_memberUser']['avatar'],'assets/lib/img/avatar.png')}}" />
                </a>
                @if($_memberUserId && $_memberUserId!=$note['_memberUser']['id'])
                    <div class="user-follow-box" data-user-id="{{$note['_memberUser']['id']}}">
                        <a href="javascript:;" class="follow @if(!$note['_memberUser']['_isFollowed']) show @endif">
                            <i class="uk-icon-plus"></i> 关注
                        </a>
                        <a href="javascript:;" class="unfollow @if($note['_memberUser']['_isFollowed']) show @endif">
                            <i class="uk-icon-minus"></i> 取消关注
                        </a>
                    </div>
                @endif
                <div class="user">
                    <a class="name" href="/member/{{$note['_memberUser']['id']}}">
                        {{$note['_memberUser']['username']}}
                    </a>
                </div>
                <div class="stat">
                    写了 {{$note['_memberUser']['wordCount'] or 0}} 字，被 {{$note['_memberUser']['followerCount'] or 0}} 人关注
                </div>
                <div class="signature">
                    {{$note['_memberUser']['signature']}}
                </div>
            </div>
            <div class="tool">
                <div class="share">
                    <div data-share-buttons data-sites="weibo,qq,qzone,wechat"></div>
                </div>
                <a class="note-like-box @if($note['_isLiked']) liked @endif" href="javascript:;" data-note-id="{{$note['id']}}">
                    <i class="uk-icon-heart-o"></i> 喜欢
                    |
                    <span class="count">{{$note['likeCount'] or 0}}</span>
                </a>
                @if($_memberUserId)
                    <a class="add-to-topic" href="javascript:;" data-dialog-request="/note/add_to_topic/{{$note['id']}}">
                        <i class="uk-icon-plus"></i>
                        收录到我的专题
                    </a>
                @endif
            </div>
        </div>

        <div class="pb pb-note-comment-post">
            @if($_memberUserId)
                <div class="post">
                    <div class="avatar">
                        <img src="{{\TechSoft\Laravel\Assets\AssetsUtil::fixOrDefault($_memberUser['avatar'],'assets/lib/img/avatar.png')}}" />
                    </div>
                    <div class="comment-editor">
                        <div class="message-editor">
                            <textarea id="noteComment" style="display:none;"></textarea>
                        </div>
                    </div>
                </div>
            @else
                <div class="login">
                    <a href="/login?redirect={{urlencode($base_request_path)}}">登录后开始评论</a>
                </div>
            @endif
        </div>

        <div class="pb pb-note-comment-list">
            <div class="title">
                {{$note['commentCount'] or 0}}条评论
            </div>
            <div class="list">
                <div class="loading">
                    <i class="uk-icon-refresh uk-icon-spin"></i>
                </div>
            </div>
            <div class="page page-container">
            </div>
        </div>

    </div>

    @if($note['_memberUser']['tipEnable'])
        <div id="tipDialog" class="uk-modal">
            <div class="uk-modal-dialog">
                <div class="pb pb-note-tip">
                    <div class="body">
                        <div class="uk-form">
                            <div class="tip-title">
                                打赏给用户
                            </div>
                            <div class="tip-value">
                                <input type="text" class="uk-form-large" name="money" value="{{$note['_memberUser']['defaultTipValue']}}" />
                            </div>
                            @if( \TechSoft\Laravel\Pay\PayUtil::hasPay() )

                                <div class="pay-list">

                                    @if(\TechSoft\Laravel\Pay\PayUtil::isAlipayEnable())
                                        <a href="javascript:;" data-type="{{\TechSoft\Laravel\Pay\Types\PayType::ALIPAY}}">
                                            <img src="@assets('assets/lib/img/pay/alipay.jpg')"/>
                                            支付宝
                                        </a>
                                    @endif

                                    @if(\TechSoft\Laravel\Pay\PayUtil::isWechatEnable())
                                        <a href="javascript:;" data-type="{{\TechSoft\Laravel\Pay\Types\PayType::WECHAT}}">
                                            <img src="@assets('assets/lib/img/pay/wechat.jpg')"/>
                                            微信支付
                                        </a>
                                    @endif

                                </div>

                                <div class="msg-title">
                                    留言
                                </div>
                                <div class="msg-value">
                                    <input type="text" class="uk-form-large" name="msg" value="支持一下~" />
                                </div>

                                <div class="pay-submit">
                                    <a href="javascript:;" data-pay-submit>确定支付</a>
                                </div>

                            @else

                                <div class="pay-list">
                                    <div class="uk-alert uk-alert-danger">
                                        没有开启任何支付方式 T_T
                                    </div>
                                </div>

                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    @endif


@endsection