@extends('theme.default.pc.frame')

@section('pageTitleMain','搜索 '.htmlspecialchars($keyword).' 的结果')

@section('bodyScript')
    @parent
    <script>
        (function () {
            var pager = new window.api.pager('.page-container',function (page) {
                $.post('?',{keyword:<?php echo json_encode($keyword); ?>,page:page},function (res) {
                    window.api.base.defaultFormCallback(res,{success:function(res){
                        $('#list').html(res.data.html);
                        pager.render(res.data.total,res.data.pageSize,res.data.page);
                    }});
                });
            },{jump:false,total:false});
            pager.render({{$total}},{{$pageSize}},1);
        })();
    </script>
@endsection


@section('bodyContent')

    <div class="main-container">

        <div class="uk-grid">
            <div class="uk-width-1-4">

                <div class="pb pb-member-profile-menu">
                    <div class="body">
                        <div class="list">
                            <a class="@if(in_array($base_request_path,['/search/note'])) active @endif" href="/search/note?keyword={{urlencode($keyword)}}"><i class="uk-icon-list"></i> 搜索文章</a>
                            <a class="@if(in_array($base_request_path,['/search/topic'])) active @endif" href="/search/topic?keyword={{urlencode($keyword)}}"><i class="uk-icon-cube"></i> 搜索专题</a>
                            <a class="@if(in_array($base_request_path,['/search/user'])) active @endif" href="/search/user?keyword={{urlencode($keyword)}}"><i class="uk-icon-users"></i> 搜索用户</a>
                        </div>
                    </div>
                </div>

            </div>
            <div class="uk-width-3-4">

                @if($base_request_path=='/search/note')
                    <div class="pb pb-note-list">
                        <div class="body" id="list">
                            @include('theme.default.pc.fragment.noteListItems')
                        </div>
                    </div>
                @endif

                @if($base_request_path=='/search/topic')
                    <div class="pb pb-topic-list">
                        <div class="body" id="list">
                            @include('theme.default.pc.fragment.topicListItems')
                        </div>
                    </div>
                @endif

                    @if($base_request_path=='/search/user')
                    <div class="pb pb-member-list">
                        <div class="body" id="list">
                            @include('theme.default.pc.fragment.memberUserListItems')
                        </div>
                    </div>
                @endif

                <div class="pb">
                    <div class="page-container"></div>
                </div>

            </div>
        </div>
    </div>


@endsection