@extends('theme.default.pc.frame')

@if($topic)
    @section('pageTitle','修改专题')
@else
    @section('pageTitle','新建专题')
@endif

@section('bodyScript')
    @parent
    <script>
        $(function () {
            var $pushVerifyBox = $('#pushVerifyBox');
            var check = function () {
                if($('input[name=pushEnable]:checked').val()==1){
                    $pushVerifyBox.show();
                }else{
                    $pushVerifyBox.hide();
                }
            };
            $('input[name=pushEnable]').on('change',check);
            check();
        });
    </script>
@endsection


@section('bodyContent')

    <div class="main-container">

        <div class="pb pb-topic-edit">
            <div class="head">
                <h1>@yield('pageTitle')</h1>
            </div>
            <div class="body">
                <form action="?" class="uk-form" method="post" data-ajax-form>
                    <div class="line">
                        <div class="label">封面</div>
                        <div class="field">
                            <div>
                                @if(empty($topic['cover']))
                                    <img data-member-image-upload-preview="cover"
                                         style="height:100px;width:100px;border:1px solid #CCC;vertical-align:bottom;border-radius:3px;"
                                         src="@assets('assets/lib/img/none.png')" />
                                @else
                                    <img data-member-image-upload-preview="cover"
                                         style="height:100px;width:100px;border:1px solid #CCC;vertical-align:bottom;border-radius:3px;"
                                         src="{{\TechSoft\Laravel\Assets\AssetsUtil::fix($topic['cover'])}}" />
                                @endif
                            </div>
                            <div>
                                <input type="hidden" name="cover" value="{{$topic['cover'] or ''}}" data-member-image-upload-value="cover" />
                                <a href="javascript:;" style="width:100px;" class="uk-button uk-button-default" data-member-image-upload="cover"><i class="uk-icon-plus"></i> 选择图片</a>
                            </div>
                        </div>
                    </div>
                    <div class="line">
                        <div class="label">名称</div>
                        <div class="field">
                            <input type="text" name="title" value="{{$topic['title'] or ''}}" class="uk-form-large uk-width-3-4" />
                        </div>
                    </div>
                    <div class="line">
                        <div class="label">描述</div>
                        <div class="field">
                            <textarea name="description" rows="3" class="uk-form-large uk-width-3-4">{{$topic['description'] or ''}}</textarea>
                        </div>
                    </div>
                    <div class="line">
                        <div class="label">是否允许投稿</div>
                        <div class="field">
                            <label>
                                <input type="radio" @if(!$topic || !empty($topic['pushEnable'])) checked @endif name="pushEnable" value="1" >
                                允许
                            </label>
                            &nbsp;&nbsp;
                            <label>
                                <input type="radio" @if($topic && empty($topic['pushEnable'])) checked @endif name="pushEnable" value="0" >
                                不允许
                            </label>
                        </div>
                    </div>
                    <div class="line" id="pushVerifyBox" style="display:none;">
                        <div class="label">投稿需要审核</div>
                        <div class="field">
                            <label>
                                <input type="radio" @if(!$topic || !empty($topic['pushVerify'])) checked @endif name="pushVerify" value="1" >
                                需要
                            </label>
                            &nbsp;&nbsp;
                            <label>
                                <input type="radio" @if($topic && empty($topic['pushVerify'])) checked @endif name="pushVerify" value="0" >
                                不需要
                            </label>
                        </div>
                    </div>
                    <div class="line">
                        <div class="label">&nbsp;</div>
                        <div class="field">
                            <button type="submit" class="uk-button uk-button-primary uk-button-large">提交</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>

    </div>

@endsection