@extends('theme.default.pc.frame')

@section('pageTitleMain',htmlspecialchars($topic['title']))
@section('pageKeywords',htmlspecialchars($topic['title']))
@section('pageDescription',htmlspecialchars($topic['description']))

@section('bodyScript')
    @parent
    <script>
        $('[data-dialog-request]').on('dialog.close',function () {
            window.location.reload();
        });
    </script>
@endsection

@section('bodyContent')

    <div class="main-container">

        <div class="uk-grid">
            <div class="uk-width-2-3">

                <div class="pb pb-topic-info">

                    <div class="body">

                        <div class="box">
                            <div class="cover">
                                <a href="/t/{{$topic['alias']}}">
                                    <img src="{{\TechSoft\Laravel\Assets\AssetsUtil::fix($topic['cover'])}}" />
                                </a>
                            </div>
                            <div class="action">
                                @if($_memberUserId)
                                    @if($_memberUserId==$topic['memberUserId'])
                                        <a href="javascript:;" class="msg" data-dialog-request="/topic/note_select/{{$topic['id']}}">
                                            <i class="uk-icon-tasks"></i>
                                            收录
                                        </a>
                                        @if($topic['pushEnable'])
                                            <a class="msg" data-dialog-request="/topic/note_contribute_verify/{{$topic['id']}}">
                                                <i class="uk-icon-paper-plane"></i>
                                                投稿审核
                                            </a>
                                        @endif
                                    @else
                                        @if($topic['pushEnable'])
                                            <a class="msg" data-dialog-request="/topic/note_contribute/{{$topic['id']}}">
                                                <i class="uk-icon-paper-plane"></i>
                                                投稿
                                            </a>
                                        @endif
                                    @endif
                                    @if($_memberUserId!=$topic['memberUserId'])
                                        <div class="topic-follow-box" data-topic-id="{{$topic['id']}}">
                                            <a href="javascript:;" class="follow @if(!$topic['_isFollowed']) show @endif">
                                                <i class="uk-icon-plus"></i>
                                                关注
                                            </a>
                                            <a href="javascript:;" class="unfollow @if($topic['_isFollowed']) show @endif">
                                                <i class="uk-icon-minus"></i>
                                                取消关注
                                            </a>
                                        </div>
                                    @endif
                                @else
                                    @if($topic['pushEnable'])
                                        <a class="msg" href="/login?redirect={{urlencode($base_request_path)}}" data-uk-tooltip title="请先登录">
                                            <i class="uk-icon-paper-plane"></i>
                                            投稿
                                        </a>
                                    @endif
                                @endif
                            </div>
                            <div class="name">
                                <a href="/t/{{$topic['alias']}}">
                                    {{$topic['title']}}
                                </a>
                                @if($_memberUserId==$topic['memberUserId'])
                                    <a href="/topic/edit/{{$topic['id']}}" data-uk-tooltip title="修改" class="uk-text-muted"><i class="uk-icon-edit"></i></a>
                                @endif
                            </div>
                            <div class="stat">
                                收录了{{$topic['noteCount'] or 0}}篇文章
                                ·
                                {{$topic['followerCount'] or 0}}人关注
                            </div>
                        </div>

                    </div>

                </div>

                @section('topicBodyContent')@show

            </div>
            <div class="uk-width-1-3">

                <div class="pb">
                    <div class="head">
                        <h2>{{$topic['title']}}</h2>
                    </div>
                    <div class="body html-container">
                        {!! \TechSoft\Laravel\Util\HtmlUtil::text2html($topic['description']) !!}
                    </div>
                </div>

                <div class="pb-spacer"></div>

                <div class="pb pb-member-right-menu">
                    <div class="head">
                        <h2>分享</h2>
                    </div>
                    <div class="body">
                        <div data-share-buttons data-sites="weibo,qq,qzone,wechat"></div>
                    </div>
                </div>

                <div class="pb-spacer"></div>

                <div class="pb pb-topic-manager">
                    <div class="head">
                        <h2>
                            管理员
                        </h2>
                    </div>
                    <div class="body">
                        <a class="item" href="/member/{{$topic['_memberUser']['id']}}">
                            <img src="{{\TechSoft\Laravel\Assets\AssetsUtil::fixOrDefault($topic['_memberUser']['avatar'],'assets/lib/img/avatar.png')}}" />
                            {{$topic['_memberUser']['username']}}
                        </a>
                    </div>
                </div>

                <div class="pb-spacer"></div>

                <div class="pb pb-topic-follower">
                    <div class="head">
                        <h2>
                            关注的人
                        </h2>
                    </div>
                    <div class="body">
                    @if(empty($latestFollowers))
                        <div class="empty">暂无用户</div>
                    @else
                        @foreach($latestFollowers as $follower)
                            <a class="item" href="/member/{{$follower['id']}}" data-uk-tooltip title="{{$follower['username']}}">
                                <img src="{{\TechSoft\Laravel\Assets\AssetsUtil::fixOrDefault($follower['avatar'],'assets/lib/img/avatar.png')}}" />
                            </a>
                        @endforeach
                        @if(count($latestFollowers)>0)
                            <a class="more" href="/t/{{$topic['alias']}}/followers" data-uk-tooltip title="查看全部">
                                <i class="uk-icon-ellipsis-h"></i>
                            </a>
                        @endif
                    @endif
                    </div>
                </div>

            </div>
        </div>

    </div>

@endsection