@if(empty($notes))
    <div class="empty">
        没有记录
    </div>
@else
    @foreach($notes as $note)
        <div class="item">
            <div class="action">
                @if($note['_isInTopic'])
                    <a href="javascript:;" class="revert" data-uk-tooltip title="点击撤回" data-ajax-request-loading data-ajax-request="/topic/note_remove/{{$topic['id']}}/{{$note['id']}}">已收录</a>
                @else
                    @if($note['_isInTopicApply'])
                        <a class="remove" href="javascript:;" data-uk-tooltip title="点击撤回投递申请" data-ajax-request-loading data-ajax-request="/topic/note_apply_revert/{{$topic['id']}}/{{$note['id']}}">正在审核</a>
                    @else
                        <a href="javascript:;" data-ajax-request-loading data-ajax-request="/topic/note_apply/{{$topic['id']}}/{{$note['id']}}">投递</a>
                    @endif
                @endif
            </div>
            <a href="/n/{{$note['alias']}}" class="title" target="_blank">
                {{$note['title']}}
            </a>
        </div>
    @endforeach
@endif