@if(empty($notes))
    <div class="empty">
        没有记录
    </div>
@else
    @foreach($notes as $note)
        <div class="item">
            <div class="action">
                @if($note['_isInTopic'])
                    <a href="javascript:;" class="revert" data-uk-tooltip title="点击撤回" data-ajax-request-loading data-ajax-request="/topic/note_remove/{{$topic['id']}}/{{$note['id']}}">已收录</a>
                @else
                    <a href="javascript:;" data-ajax-request-loading data-ajax-request="/topic/note_contribute_verify_pass/{{$topic['id']}}/{{$note['id']}}">接受投稿</a>
                    <a class="remove" href="javascript:;" data-ajax-request-loading data-ajax-request="/topic/note_contribute_verify_reject/{{$topic['id']}}/{{$note['id']}}">拒绝投稿</a>
                @endif
            </div>
            <a href="/n/{{$note['alias']}}" class="title" target="_blank">
                {{$note['title']}}
            </a>
        </div>
    @endforeach
@endif