@extends('theme.default.pc.frame')

@section('pageTitleMain','最新专题')

@section('bodyScript')
    @parent
    <script>
        (function () {
            var pager = new window.api.pager('.page-container',function (page) {
                $.post('?',{page:page},function (res) {
                    window.api.base.defaultFormCallback(res,{success:function(res){
                        $('#list').html(res.data.html);
                        pager.render(res.data.total,res.data.pageSize,res.data.page);
                    }});
                });
            },{jump:false,total:false});
            pager.render({{$total}},{{$pageSize}},1);
        })();
    </script>
@endsection


@section('bodyContent')

    <div class="main-container">

        <div class="uk-grid">
            <div class="uk-width-1-4">

                <div class="pb pb-member-profile-menu">
                    <div class="body">
                        <div class="list">
                            <a class="@if(in_array($base_request_path,['/topics'])) active @endif" href="/topics"><i class="uk-icon-cube"></i> 推荐专题</a>
                            <a class="@if(in_array($base_request_path,['/topics/latest'])) active @endif" href="/topics/latest"><i class="uk-icon-cube"></i> 最新专题</a>
                        </div>
                    </div>
                </div>

                <div class="pb pb-home-writing">
                    <div class="body">
                        <a href="/topic/edit">
                            <i class="uk-icon-edit"></i>
                            创建我的专题
                        </a>
                    </div>
                </div>

                @if(!empty($hotTopics))
                    <div class="pb pb-home-topic-list">
                        <div class="head">
                            <h2>推荐专题</h2>
                        </div>
                        <div class="body">
                            @foreach($hotTopics as $topic)
                                <a href="/t/{{$topic['alias']}}" class="item">
                                    <span class="contribute">
                                        投稿
                                    </span>
                                    <span class="name">
                                        <img src="{{\TechSoft\Laravel\Assets\AssetsUtil::fix($topic['cover'])}}" />
                                        {{$topic['title']}}
                                    </span>
                                </a>
                            @endforeach
                        </div>
                    </div>
                @endif

            </div>
            <div class="uk-width-3-4">

                <div class="pb pb-topic-list">
                    <div class="body" id="list">
                        @include('theme.default.pc.fragment.topicListItems')
                    </div>
                </div>

                <div class="pb">
                    <div class="page-container"></div>
                </div>

            </div>
        </div>
    </div>


@endsection