@extends('theme.default.pc.frame')

@section('pageTitleMain','写作模式')

@section('headScript')
    @parent
    <link rel="stylesheet" href="@assets('assets/editor.md/css/editormd.css')">
@endsection

@section('bodyScript')
    <script>
        var __app = {
            editorTypeRichText:{{\TechSoft\Laravel\Html\HtmlType::RICH_TEXT}},
            editorTypeMarkdown:{{\TechSoft\Laravel\Html\HtmlType::MARKDOWN}},
            defaultEditorType:{{$_memberUser['noteEditorType'] or \TechSoft\Laravel\Config\ConfigUtil::get('editorType',\TechSoft\Laravel\Html\HtmlType::RICH_TEXT)}}
        };
    </script>
    <script src="@assets('assets/editor.md/editormd.js')"></script>
    <script src="@assets('assets/vue/vue.js')"></script>
    <script src="@assets('assets/main/writer.js')"></script>
@endsection

@section('body')


    <div class="writer-container" id="app" v-cloak>

        <div class="category-box">
            <div class="logo">
                <a href="/" target="_blank">
                    <img src="{{\TechSoft\Laravel\Assets\AssetsUtil::fixOrDefault(\TechSoft\Laravel\Config\ConfigUtil::get('siteLogo'),'/placeholder/160x50')}}" />
                </a>
            </div>
            <div class="back">
                <a href="/">回首页</a>
            </div>
            <div class="add">
                <a href="javascript:;" v-on:click="addCategory()"><i class="uk-icon-plus"></i> 增加文集</a>
            </div>
            <div class="loading" v-show="categoryLoading">
                <i class="uk-icon-refresh uk-icon-spin"></i>
            </div>
            <div class="list">
                <div class="item" v-for="item in categories" v-bind:class="{active:item.id==currentCategoryId}" v-on:click="currentCategoryId=item.id">
                    <div class="operation" v-show="item.id==currentCategoryId && currentCategoryId>0">
                        <a href="javascript:;" v-on:click="editCategory(item)"><i class="uk-icon-cog"></i></a>
                    </div>
                    <a class="title" href="javascript:;">
                        @{{ item.title }}
                    </a>
                </div>
            </div>
        </div>

        <div class="note-box">
            <div class="add">
                <a href="javascript:;" v-on:click="addNote()">
                    <i class="uk-icon-plus-circle"></i> 新建文章
                </a>
            </div>
            <div class="empty" v-if="ready && !noteListLoading && notes.length==0">
                暂无文章
            </div>
            <div class="list">
                <div class="item" v-for="no in notes" v-bind:class="{active:editingNote&&editingNote.id==no.id}" >
                    <div class="icon" v-on:click="editNote(no.id)">
                        <i class="uk-icon-file active" data-uk-tooltip title="已发布" v-if="no.isPublished"></i>
                        <i class="uk-icon-file" data-uk-tooltip title="未发布" v-if="!no.isPublished"></i>
                    </div>
                    <div class="operation" v-show="editingNote&&editingNote.id==no.id">
                        <a href="javascript:;" v-on:click="operateNote(no)"><i class="uk-icon-cog"></i></a>
                    </div>
                    <div class="title" v-on:click="editNote(no.id)">
                        @{{ no.title }}
                    </div>
                    <div class="time" v-on:click="editNote(no.id)">
                        <i class="uk-icon-clock-o"></i>
                        @{{ no.time }}
                    </div>
                    <div class="summary" v-on:click="editNote(no.id)">
                        @{{ no.summary }}
                    </div>
                </div>
                <div class="loading" v-show="noteListLoading">
                    <i class="uk-icon-refresh uk-icon-spin"></i>
                </div>
                <div class="tail" v-show="ready && !noteListLoading && noteHasMore" v-on:click="loadNoteList()">
                    <i class="uk-icon-angle-double-down"></i> 点击加载更多
                </div>
            </div>
        </div>

        <div class="editor-box">
            <div class="title">
                <div class="action">
                    <a href="javascript:;" data-uk-tooltip title="保存(Ctrl+S)" v-on:click="saveNote()"><i class="uk-icon-save"></i></a>
                    <a v-show="note.id>0 && !note.isPublished" href="javascript:;" data-uk-tooltip title="发布" v-on:click="publishNote(true)"><i class="uk-icon-paper-plane"></i></a>
                    <a v-show="note.id>0 && note.isPublished" href="javascript:;" data-uk-tooltip title="同步发布" v-on:click="publishNote(false)"><i class="uk-icon-refresh"></i></a>
                    <a v-show="note.id>0 && note.isPublished" href="javascript:;" data-uk-tooltip title="查看发布" v-bind:href="'/n/'+note._publishNoteAlias" target="_blank"><i class="uk-icon-eye"></i></a>
                    <a v-show="note.id>0 && note.isPublished" href="javascript:;" data-uk-tooltip title="取消发布" v-on:click="cancelPublishNote()"><i class="uk-icon-eye-slash"></i></a>
                    <a v-show="note.id>0" href="javascript:;" data-uk-tooltip title="历史版本" v-on:click="historyNote()"><i class="uk-icon-clock-o"></i></a>
                </div>
                <div class="input">
                    <input type="text" v-model="note.title" placeholder="输入文章标题" />
                </div>
            </div>
            <div class="editor">
                <div class="rich-editor" id="richEditor">
                    <div id="rich_editor">
                    </div>
                </div>
                <div class="markdown-editor" id="markdownEditor">
                    <div id="markdown_editor">
                        <textarea style="display:none;"></textarea>
                    </div>
                </div>
            </div>
        </div>

        <div class="top-message loading">
            <i class="uk-icon-spin uk-icon-refresh"></i> 正在加载...
        </div>
        <div class="top-message success">
            <i class="uk-icon-check"></i> <span></span>
        </div>
        <div class="top-message error">
            <i class="uk-icon-warning"></i> <span></span>
        </div>

        <div id="categoryEditDialog" class="uk-modal">
            <div class="uk-modal-dialog" style="width:300px;">
                <button type="button" class="uk-modal-close uk-close"></button>
                <div class="uk-modal-header">
                    文集
                </div>
                <div class="uk-form">
                    <div class="line line-label-narrow">
                        <div class="label">名称</div>
                        <div class="field">
                            <input type="text" v-model="category.title" />
                        </div>
                    </div>
                </div>
                <div class="uk-modal-footer uk-text-right">
                    <button type="button" class="uk-button" v-show="category.id>0" v-on:click="deleteCategory()">删除</button>
                    <button type="button" class="uk-button uk-button-primary" v-on:click="saveCategory()">保存</button>
                </div>
            </div>
        </div>

        <div id="noteOperateDialog" class="uk-modal">
            <div class="uk-modal-dialog" style="width:300px;">
                <button type="button" class="uk-modal-close uk-close"></button>
                <div class="uk-modal-header">
                    文章
                </div>
                <div class="uk-form">
                    <div class="line line-label-narrow">
                        <div class="label">文集</div>
                        <div class="field">
                            <select v-model="note.categoryId">
                                <option v-for="item in categories" v-bind:value="item.id">@{{ item.title }}</option>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="uk-modal-footer uk-text-right">
                    <button type="button" class="uk-button" v-on:click="deleteNote()">删除</button>
                    <button type="button" class="uk-button uk-button-primary" v-on:click="saveNoteOperate()">保存</button>
                </div>
            </div>
        </div>

        <div id="noteHistoryDialog" class="uk-modal history-box">
            <div class="uk-modal-dialog" style="width:90%;height:90%;margin-top:10px;position:relative;">
                <button type="button" class="uk-modal-close uk-close"></button>
                <div class="uk-modal-header">
                    <i class="uk-icon-clock-o"></i>
                    历史版本
                </div>
                <div class="body">
                    <div class="empty" v-show="noteHistories.length==0">
                        暂无历史版本
                    </div>
                    <div class="list">
                        <div class="item" v-for="his in noteHistories" v-bind:class="{active:noteHistory&&noteHistory.id==his.id}" v-on:click="noteHistory=his">
                            <div class="time">
                                <i class="uk-icon-clock-o"></i>
                                <time v-bind:datetime="his.time"></time>
                            </div>
                            @{{ his.title }}
                        </div>
                    </div>
                    <div class="view" v-if="noteHistory">
                        <div class="head">
                            <div class="action">
                                <a href="javascript:;" class="uk-button uk-button-primary" v-on:click="revertNote(noteHistory)">恢复到这个版本</a>
                            </div>
                            @{{ noteHistory.title }}
                        </div>
                        <div class="content">
                            <div v-if="note.contentType=={{\TechSoft\Laravel\Html\HtmlType::MARKDOWN}}">
                                <pre class="markdown">@{{ noteHistory.content }}</pre>
                            </div>
                            <div v-if="note.contentType=={{\TechSoft\Laravel\Html\HtmlType::RICH_TEXT}}">
                                <pre class="rich html-container" v-html="noteHistory.content"></pre>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>

    </div>

@endsection