-- ----------------------------------------
-- EyouCms MySQL Data Transfer 
-- 
-- Server         : 127.0.0.1_3306
-- Server Version : 5.5.40
-- Host           : 127.0.0.1:3306
-- Database       : e22
-- 
-- Part : #1
-- Version : #v1.2.6
-- Date : 2019-01-16 16:12:58
-- -----------------------------------------

SET FOREIGN_KEY_CHECKS = 0;


-- -----------------------------
-- Table structure for `ey_ad`
-- -----------------------------
DROP TABLE IF EXISTS `ey_ad`;
CREATE TABLE `ey_ad` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '广告id',
  `pid` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '广告位置ID',
  `media_type` tinyint(1) DEFAULT '0' COMMENT '广告类型',
  `title` varchar(60) DEFAULT '' COMMENT '广告名称',
  `links` varchar(255) DEFAULT '' COMMENT '广告链接',
  `litpic` varchar(255) DEFAULT '' COMMENT '图片地址',
  `start_time` int(11) DEFAULT '0' COMMENT '投放时间',
  `end_time` int(11) DEFAULT '0' COMMENT '结束时间',
  `intro` text COMMENT '描述',
  `link_man` varchar(60) DEFAULT '' COMMENT '添加人',
  `link_email` varchar(60) DEFAULT '' COMMENT '添加人邮箱',
  `link_phone` varchar(60) DEFAULT '' COMMENT '添加人联系电话',
  `click` int(11) DEFAULT '0' COMMENT '点击量',
  `bgcolor` varchar(30) DEFAULT '' COMMENT '背景颜色',
  `status` tinyint(1) unsigned DEFAULT '1' COMMENT '1=显示，0=屏蔽',
  `sort_order` int(11) DEFAULT '0' COMMENT '排序',
  `target` varchar(50) DEFAULT '' COMMENT '是否开启浏览器新窗口',
  `admin_id` int(10) DEFAULT '0' COMMENT '管理员ID',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '多语言',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `position_id` (`pid`) USING BTREE,
  KEY `status` (`status`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=utf8;

-- -----------------------------
-- Records of `ey_ad`
-- -----------------------------
INSERT INTO `ey_ad` VALUES ('1', '1', '1', '幻灯二', 'http://www.eyoucms.com', '/public/upload/other/2018/06/08/945d12ec721885bda37888f56150990b.jpg', '1524215594', '0', '&lt;p&gt;填写广告的备注信息，方便于后期的跟进&lt;/p&gt;', '', '', '', '0', '', '1', '100', '0', '0', 'cn', '1524215652', '1528443111');
INSERT INTO `ey_ad` VALUES ('2', '1', '1', '幻灯一', 'http://www.eyoucms.com', '/public/upload/other/2018/06/08/476bcf5a41c664edfef6f335a0dd58b5.jpg', '0', '0', '&lt;p&gt;填写广告的备注信息，方便于后期的跟进&lt;/p&gt;', '', '', '', '0', '', '1', '100', '0', '0', 'cn', '1524214017', '1528443097');
INSERT INTO `ey_ad` VALUES ('4', '3', '1', '幻灯一', '', '/public/upload/other/2018/06/09/7fdb82318f01e91955d2748641d89c28.jpg', '0', '0', '', '', '', '', '0', '', '1', '100', '1', '0', 'cn', '1527667947', '1528505915');
INSERT INTO `ey_ad` VALUES ('5', '3', '1', '幻灯二', '', '/public/upload/other/2018/06/09/a9e9e0b453802466fdde1c082b6bc76f.jpg', '0', '0', '', '', '', '', '0', '', '1', '100', '1', '0', 'cn', '1527667963', '1528505928');

-- -----------------------------
-- Table structure for `ey_ad_position`
-- -----------------------------
DROP TABLE IF EXISTS `ey_ad_position`;
CREATE TABLE `ey_ad_position` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(60) DEFAULT '' COMMENT '广告位置名称',
  `width` smallint(5) unsigned DEFAULT '0' COMMENT '广告位宽度',
  `height` smallint(5) unsigned DEFAULT '0' COMMENT '广告位高度',
  `intro` text COMMENT '广告描述',
  `status` tinyint(1) DEFAULT '1' COMMENT '0关闭1开启',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '多语言',
  `admin_id` int(10) DEFAULT '0' COMMENT '管理员ID',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COMMENT='广告位置表';

-- -----------------------------
-- Records of `ey_ad_position`
-- -----------------------------
INSERT INTO `ey_ad_position` VALUES ('1', '头部-大幻灯片', '1903', '330', '', '1', 'cn', '0', '1524209276', '1528443128');
INSERT INTO `ey_ad_position` VALUES ('3', '手机端首页头部幻灯', '640', '270', '', '1', 'cn', '0', '1527667904', '1528279612');
INSERT INTO `ey_ad_position` VALUES ('6', 'PC端栏目页banner图', '1920', '313', '', '1', 'cn', '0', '1528332605', '1528332605');

-- -----------------------------
-- Table structure for `ey_admin`
-- -----------------------------
DROP TABLE IF EXISTS `ey_admin`;
CREATE TABLE `ey_admin` (
  `admin_id` smallint(5) unsigned NOT NULL AUTO_INCREMENT COMMENT '用户id',
  `user_name` varchar(20) NOT NULL DEFAULT '' COMMENT '用户名',
  `pen_name` varchar(50) DEFAULT '' COMMENT '笔名（发布文章后显示责任编辑的名字）',
  `true_name` varchar(20) DEFAULT '' COMMENT '真实姓名',
  `mobile` varchar(11) DEFAULT '' COMMENT '手机号码',
  `email` varchar(60) DEFAULT '' COMMENT 'email',
  `password` varchar(32) NOT NULL DEFAULT '' COMMENT '密码',
  `last_login` int(11) DEFAULT '0' COMMENT '最后登录时间',
  `last_ip` varchar(15) DEFAULT '' COMMENT '最后登录ip',
  `login_cnt` int(11) DEFAULT '0' COMMENT '登录次数',
  `session_id` varchar(50) DEFAULT '' COMMENT 'session_id',
  `parent_id` int(10) DEFAULT '0' COMMENT '父管理员ID',
  `role_id` int(10) NOT NULL DEFAULT '-1' COMMENT '角色组ID（-1表示超级管理员）',
  `mark_lang` varchar(50) DEFAULT 'cn' COMMENT '当前语言标识',
  `status` tinyint(1) DEFAULT '1' COMMENT '状态(0=屏蔽，1=正常)',
  `add_time` int(11) DEFAULT '0' COMMENT '添加时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`admin_id`),
  KEY `user_name` (`user_name`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

-- -----------------------------
-- Records of `ey_admin`
-- -----------------------------
INSERT INTO `ey_admin` VALUES ('1', 'admin', '', 'admin', '', '', '7959ec68e999edd0380ff0809f76fa42', '1547626351', '127.0.0.1', '2', 's53ctlu784v4bsstra2ejvog81', '0', '-1', 'cn', '1', '1547626343', '0');

-- -----------------------------
-- Table structure for `ey_admin_log`
-- -----------------------------
DROP TABLE IF EXISTS `ey_admin_log`;
CREATE TABLE `ey_admin_log` (
  `log_id` bigint(16) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `admin_id` int(10) DEFAULT NULL COMMENT '管理员id',
  `log_info` varchar(255) DEFAULT NULL COMMENT '日志描述',
  `log_ip` varchar(30) DEFAULT NULL COMMENT 'ip地址',
  `log_url` varchar(255) DEFAULT NULL COMMENT 'url',
  `log_time` int(10) DEFAULT NULL COMMENT '日志时间',
  PRIMARY KEY (`log_id`),
  KEY `admin_id` (`admin_id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=476 DEFAULT CHARSET=utf8;

-- -----------------------------
-- Records of `ey_admin_log`
-- -----------------------------
INSERT INTO `ey_admin_log` VALUES ('473', '1', '后台登录', '127.0.0.1', '/index.php/admin/Admin/login.html', '1540353399');
INSERT INTO `ey_admin_log` VALUES ('474', '1', '后台登录', '127.0.0.1', '/login.php', '1545639036');
INSERT INTO `ey_admin_log` VALUES ('475', '1', '后台登录', '127.0.0.1', '/login.php', '1547626351');

-- -----------------------------
-- Table structure for `ey_archives`
-- -----------------------------
DROP TABLE IF EXISTS `ey_archives`;
CREATE TABLE `ey_archives` (
  `aid` int(10) NOT NULL AUTO_INCREMENT,
  `typeid` int(10) NOT NULL DEFAULT '0' COMMENT '当前栏目',
  `channel` int(10) NOT NULL DEFAULT '0' COMMENT '模型ID',
  `is_b` tinyint(1) DEFAULT '0' COMMENT '加粗',
  `title` varchar(200) DEFAULT '' COMMENT '标题',
  `litpic` varchar(250) DEFAULT '' COMMENT '封面图',
  `is_head` tinyint(1) DEFAULT '0' COMMENT '头条（0=否，1=是）',
  `is_special` tinyint(1) DEFAULT '0' COMMENT '特荐（0=否，1=是）',
  `is_top` tinyint(1) DEFAULT '0' COMMENT '置顶（0=否，1=是）',
  `is_recom` tinyint(1) DEFAULT '0' COMMENT '推荐（0=否，1=是）',
  `is_jump` tinyint(1) DEFAULT '0' COMMENT '跳转链接（0=否，1=是）',
  `author` varchar(200) DEFAULT '' COMMENT '编辑者',
  `click` int(10) DEFAULT '0' COMMENT '浏览量',
  `arcrank` tinyint(1) DEFAULT '0' COMMENT '阅读权限：0=开放浏览，-1=待审核稿件',
  `jumplinks` varchar(200) DEFAULT '' COMMENT '外链跳转',
  `ismake` tinyint(1) DEFAULT '0' COMMENT '是否静态页面（0=动态，1=静态）',
  `seo_title` varchar(200) DEFAULT '' COMMENT 'SEO标题',
  `seo_keywords` varchar(200) DEFAULT '' COMMENT 'SEO关键词',
  `seo_description` text COMMENT 'SEO描述',
  `status` tinyint(1) DEFAULT '1' COMMENT '状态(0=屏蔽，1=正常)',
  `sort_order` int(10) DEFAULT '0' COMMENT '排序号',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `admin_id` int(10) DEFAULT '0' COMMENT '管理员ID',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`aid`),
  KEY `aid` (`typeid`,`channel`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=93 DEFAULT CHARSET=utf8 COMMENT='资讯表';

-- -----------------------------
-- Records of `ey_archives`
-- -----------------------------
INSERT INTO `ey_archives` VALUES ('1', '1', '6', '0', '关于我们', '', '0', '0', '0', '0', '0', '', '0', '0', '', '0', '', '', '', '1', '100', 'cn', '0', '1526539465', '1528443998');
INSERT INTO `ey_archives` VALUES ('38', '38', '1', '0', '荣誉证书一', '/public/upload/news/2018/05/30/20687501b7715f7a1402909db6fc11c3.jpg', '0', '0', '0', '0', '0', '', '113', '0', '', '0', '', '', '', '1', '100', 'cn', '0', '1527664149', '1527664149');
INSERT INTO `ey_archives` VALUES ('56', '36', '1', '0', '案例展示六', '/public/upload/news/2018/06/06/341687d061cae1721364333fe14ee506.jpg', '0', '0', '0', '0', '0', '', '150', '0', '', '0', '', '', '​核心价值观：诚信、创新、服务 企业核心： 诚信 企业精神： 团结拼搏、开拓求实、满足用户、科技进步。 客户：为客户提供高质量和最大价值的专业化产品和服务，以真诚和实力赢...', '1', '100', 'cn', '0', '1527665172', '1528450761');
INSERT INTO `ey_archives` VALUES ('53', '36', '1', '0', '案例展示三', '/public/upload/news/2018/06/06/034ce1ebb49861d95e65310ff4618102.jpg', '0', '0', '0', '0', '0', '', '196', '0', '', '0', '', '', '​核心价值观：诚信、创新、服务 企业核心： 诚信 企业精神： 团结拼搏、开拓求实、满足用户、科技进步。 客户：为客户提供高质量和最大价值的专业化产品和服务，以真诚和实力赢...', '1', '100', 'cn', '0', '1527665090', '1528450722');
INSERT INTO `ey_archives` VALUES ('54', '36', '1', '0', '案例展示四', '/public/upload/news/2018/06/06/a18156f012a8acfea4e0376e91852995.jpg', '0', '0', '0', '0', '0', '', '101', '0', '', '0', '', '', '​核心价值观：诚信、创新、服务 企业核心： 诚信 企业精神： 团结拼搏、开拓求实、满足用户、科技进步。 客户：为客户提供高质量和最大价值的专业化产品和服务，以真诚和实力赢...', '1', '100', 'cn', '0', '1527665111', '1528450735');
INSERT INTO `ey_archives` VALUES ('55', '36', '1', '0', '案例展示五', '/public/upload/news/2018/06/06/4e8b3896827bea75e993915c2dcaa5e3.jpg', '0', '0', '0', '0', '0', '', '184', '0', '', '0', '', '', '​核心价值观：诚信、创新、服务 企业核心： 诚信 企业精神： 团结拼搏、开拓求实、满足用户、科技进步。 客户：为客户提供高质量和最大价值的专业化产品和服务，以真诚和实力赢...', '1', '100', 'cn', '0', '1527665145', '1528450748');
INSERT INTO `ey_archives` VALUES ('51', '36', '1', '0', '案例展示一', '/public/upload/news/2018/06/06/c04ad9d7c96b307268f9189ce8abbb60.jpg', '0', '0', '0', '0', '0', '', '136', '0', '', '0', '', '', '核心价值观：诚信、创新、服务 企业核心： 诚信 企业精神： 团结拼搏、开拓求实、满足用户、科技进步。 客户：为客户提供高质量和最大价值的专业化产品和服务，以真诚和实力赢...', '1', '100', 'cn', '0', '1527665029', '1528450692');
INSERT INTO `ey_archives` VALUES ('52', '36', '1', '0', '案例展示二', '/public/upload/news/2018/06/06/0ebd21c4fd29ff98828c24f8d1bb4ad9.jpg', '0', '0', '0', '0', '0', '', '258', '0', '', '0', '', '', '​核心价值观：诚信、创新、服务 企业核心： 诚信 企业精神： 团结拼搏、开拓求实、满足用户、科技进步。 客户：为客户提供高质量和最大价值的专业化产品和服务，以真诚和实力赢...', '1', '100', 'cn', '0', '1527665066', '1528450710');
INSERT INTO `ey_archives` VALUES ('8', '15', '6', '0', '联系我们', '', '0', '0', '0', '0', '0', '', '0', '0', '', '0', '', '', '', '1', '100', 'cn', '0', '1526551000', '1528249149');
INSERT INTO `ey_archives` VALUES ('39', '38', '1', '0', '荣誉证书二', '/public/upload/news/2018/05/30/0b48980fcbc66f76b4b61317c1f14ee8.jpg', '0', '0', '0', '0', '0', '', '208', '0', '', '0', '', '', '', '1', '100', 'cn', '0', '1527664280', '1527664280');
INSERT INTO `ey_archives` VALUES ('71', '46', '1', '0', '美业信息化规模将现，门庭管店为他们提供了一套SaaS管理软件', '', '0', '0', '0', '0', '0', '', '258', '0', '', '0', '', '', '数据显示，2015年，我国服务业同比增长8.3%，分别高于国内生产总值和第二产业增加值增速1.4和2.3个百分点，占国内生产总值的比重达到50.5%，首次过半，而与发达国家相比，我国服务业仍有20%-30%的发展空间。美业属于实体服务业，整个市场有上千亿的规模，但是信息化程度和零售餐饮业相比着实比较低。其中的原因就是餐饮和零售客流量大，触达人群广，而美业客流量相对小，加上从业人员素质导致信息化程度低、管理效率低。美业现在的主要管理方式是纸质账本和简单的收银、结算软件，纸质管理约占行业客户的90%，功能简单只能用于管理会员卡的单机版管理软件约占9%。美业的客户与店面的粘性比较高，虽然是低频次消费，但是一旦用户选择一家店，在接收到较好服务之后很难再转向其它店，因此美业在预约管理、客户管理等需求上要高于餐饮和零售，应用的软件形态并不一定以结算收银为主，重点是CRM系统、收银、绩效考核、预约为一体的管理软件。36氪近日了解的门庭管店是一款美业SaaS产品，主要功能有 SCRM会员管理、智能预约、绩效工资、营销卡券、全能收银等。门庭管店产品在客户方是微信公众号和小程序；美容师端是用于客', '1', '100', 'cn', '0', '1527899934', '1528339694');
INSERT INTO `ey_archives` VALUES ('44', '39', '1', '0', '产品名称三', '/public/upload/news/2018/06/08/f66d41a5dd5b4fb148bc1ccb03863f36.jpg', '0', '0', '0', '0', '0', '', '184', '0', '', '0', '', '', '为客户降低采购成本和风险，为客户投资提供切实保障。追求永续发展的目标，并把它建立在客户满意的基础上。', '1', '100', 'cn', '0', '1527664498', '1528450387');
INSERT INTO `ey_archives` VALUES ('41', '38', '1', '0', '荣誉证书四', '/public/upload/news/2018/05/30/1e8911de906c5830f6471e2cea71f9b3.jpg', '0', '0', '0', '0', '0', '', '122', '0', '', '0', '', '', '', '1', '100', 'cn', '0', '1527664331', '1527664331');
INSERT INTO `ey_archives` VALUES ('42', '39', '1', '0', '产品名称一', '/public/upload/news/2018/06/08/0eeed1868a94aafede930ee6d208f5a5.jpg', '0', '0', '0', '0', '0', '', '247', '0', '', '0', '', '', '为客户降低采购成本和风险，为客户投资提供切实保障。追求永续发展的目标，并把它建立在客户满意的基础上。', '1', '100', 'cn', '0', '1527664373', '1528450284');
INSERT INTO `ey_archives` VALUES ('43', '39', '1', '0', '产品名称二', '/public/upload/news/2018/06/08/a469fefb9fe4657c22ecc5e5f2f333fd.jpg', '0', '0', '0', '1', '0', '', '167', '0', '', '0', '', '', '为客户降低采购成本和风险，为客户投资提供切实保障。追求永续发展的目标，并把它建立在客户满意的基础上。', '1', '100', 'cn', '0', '1527664459', '1528450323');
INSERT INTO `ey_archives` VALUES ('40', '38', '1', '0', '荣誉证书三', '/public/upload/news/2018/05/30/8f4ca775175358d31132c1369697525c.jpg', '0', '0', '0', '0', '0', '', '225', '0', '', '0', '', '', '', '1', '100', 'cn', '0', '1527664307', '1527664307');
INSERT INTO `ey_archives` VALUES ('45', '39', '1', '0', '产品名称四', '/public/upload/news/2018/06/08/2cf71ebc65093a16e688d05871d61e21.jpg', '0', '0', '0', '0', '0', 'admin', '296', '0', '', '0', '', '', '为客户降低采购成本和风险，为客户投资提供切实保障。追求永续发展的目标，并把它建立在客户满意的基础上。', '1', '100', 'cn', '0', '1527664551', '1528450421');
INSERT INTO `ey_archives` VALUES ('70', '46', '1', '0', '点击在线求助，应答的却都是机器人，这样真的好吗？', '/public/upload/news/2018/06/02/688fc79a769e9ae4191305a32aa3e6aa.jpg', '0', '0', '0', '0', '0', '', '110', '0', '', '0', '', '', '编者按：人工智能技术的发展正在不断地改变着人们的生活与工作方式，它在一定程度上推动了社会的发展与进步，这一点是毋庸置疑的。但人工智能并不是万能的，因为机器并不具备人类的思维与情绪。当你打开网站上的在线求助窗口，却发现回答你的只是冷冰冰的机器人的时候，恐怕应该会很失望吧。2016年4月，马克·扎克伯格在Facebook的F8会议上为Messenger上的开发者们描述了一个光明的未来，并宣布将进入“像和朋友一样与机器人聊天”的新时代。世界各地的开发人员，这些开发人员都拥有Facebook、Google和Microsoft等大公司的认证，都声称独立移动应用程序的时代结束了，并一起庆祝新的方式的到来——对话商务（ConversationalCommerce）和聊天机器人（Chatbots）。11个月前，Facebook宣布其官方开发的聊天机器人“M”的beta测试中AI失败率为70％，随后便更新了其平台，并建议开发人员在Messenger中开发更轻量级的应用程序，同时禁用会话输入。关于Wordhop.io，一直以来我们都知道两件事。第一件事就是，AI真的很难，要实现让机器人100％像朋友一样与', '1', '100', 'cn', '0', '1527899912', '1527899912');
INSERT INTO `ey_archives` VALUES ('69', '46', '1', '0', '传滴滴即将接入ofo，共享单车大战格局或生变', '/public/upload/news/2018/06/02/3e882c093a3390596ce67d81cbefea19.jpg', '0', '0', '0', '0', '0', '', '123', '0', '', '0', '', '', '36氪从ofo内部获得消息，可能在今年4月份，ofo将会接入到滴滴出行的App上，届时用户可以直接在滴滴上面使用ofo的服务。“这件事最近被频繁地提上日程，内部消息是下个月就有可能接入。”一名ofo内部员工说。36氪向滴滴官方、ofo官方求证了此消息，但截止发稿时，两家公司均未对此确认或否认。ofo创始人戴威曾在去年12月表示，何时接入滴滴APP，没有明确的时间表。“ofo的模式是没有GPS的，用户看到车就用，整个逻辑跟滴滴平台打车的逻辑不太一样，但近期我们会跟滴滴联合推出一些东西。”不过类似的接入并非没有先例。今年2月，微信联合摩拜单车宣布，用户通过微信“扫一扫”扫描摩拜单车车身上的二维码，就可直接进入摩拜单车微信小程序，点击开锁即可用车。这并不是第一次传出ofo会接入滴滴的消息，也不是两个平台的第一次深度绑定。此前，滴滴参与了ofo最近三轮的融资。根据腾讯科技的报道，一位共享单车投资人透露，ofo经过多轮融资以后，滴滴已经成为ofo最大股东，占股超过30%。“这意味着，滴滴在ofo的话语权更强了，同时，ofo的成与败，滴滴将是最大利息相关方。”这也不难理解，滴滴将ofo接入之后，将', '1', '100', 'cn', '0', '1527899881', '1527899881');
INSERT INTO `ey_archives` VALUES ('68', '46', '1', '0', '借网生大势赚了两年快钱后，考拉娱乐开始切入女性人群做点“慢”内容', '/public/upload/news/2018/06/02/04ea45d74b745b6fc68d9bdd5ded84aa.jpg', '0', '0', '0', '0', '0', '', '209', '0', '', '0', '', '', '从2014年起，网络大电影这个词逐渐进入人们的眼球，当时满地都是几十万制作成本博得百万票房的故事，考拉娱乐便是在那个网生内容的蛮荒时代入的局。在接受36氪采访时，考拉娱乐创始人钱伟坦言借过去的势他们赚到了不少钱，“我们有个片子8万成本，最后回收了一百多万的票房。”在过去的两年间，他们平均一年能做20多部大电影，在各大视频网站上收益排名Top10中，你很容易就能发现考拉出品的好几部片子，也给他们积累了很多渠道资源。但当时间跨入今年后，网络大电影市场开始洗牌，去年整个市场上600多部片子突然激增到2000部以上，四两拨千斤的时代已经过去了，你会发现排名靠前的网大制作成本基本都在百万以上，已经达到了二三线院线水平。近期推出的黄金赌城系列市场红利期过去后，考拉娱乐在今年就开始了他们新的布局：瞄准女性市场，做精品网生内容。“这个其实是之前就规划好的，洗牌是肯定的。”钱伟说今年他们上半年基本没有怎么发片子，都在为今后的“慢”内容做准备。考拉娱乐首先改变的是IP孵化方式，他们组建了一支漫画团队，定位是连载时间在三年以上的长篇大世界观作品，当这些作品经过市场验证后，逐步推出相应的网络剧、大电影等衍生内', '1', '100', 'cn', '0', '1527899852', '1527899852');
INSERT INTO `ey_archives` VALUES ('66', '46', '1', '0', '腾讯游戏营收比重连续两个季度下降，支付、云计算等业务营收涨348%', '/public/upload/news/2018/06/02/2b8a5f7fcb4deb5d0bebdf309c85c2fb.jpg', '0', '0', '0', '0', '0', '', '233', '0', '', '0', '', '', '腾讯不仅在阿里怂恿大家花钱的双十一之际高调派钱，如今财报的高速增长业务也刚好跟支付宝和阿里云对标。今日晚间，腾讯发布今天公布未经审核的第三季度财报。报告显示，腾讯三季度总收入同比增长52%，增速与上季度持平；净利润增速有所下滑。值得注意的是，腾讯游戏营收比重已经连续两个季度下降，三季度网络游戏收入仅占总营收的45%；而支付和云计算等新兴业务的比重则继续上升，首次超过10%，达到12%。净利润增速下滑总体财务状况方面，腾讯三季度总收入为人民币403.88亿元（60.48亿美元），同比增长52%，增速与上季度持平。但是盈利增速却有所下滑，期内盈利为人民币107.76亿元（16.14亿美元），比去年同期增长42%；净利润率由去年同期的29%降至27%。游戏营收占比连续两个季度下滑分部业务方面，包括网络游戏和社交网络在内的增值业务依然是腾讯收入的大头，占比约八成。然而，一向被视为腾讯摇钱树的游戏业务，其收入占比却连续两季下降，如今占总营收比重仅有45%左右，该项业务在2015年一度占腾讯营收六成。而社交网络收入增速则在逐步增长，占比一直稳定在23-24%。再往细看，手游已经成了游戏业务的主力，', '1', '100', 'cn', '0', '1527899765', '1527899765');
INSERT INTO `ey_archives` VALUES ('67', '46', '1', '0', '获 3800 万元 A+ 轮投资，乐摇摇科技利用抓娃娃机做线下版的广点通', '/public/upload/news/2018/06/02/dc88baf2f54c513a9a46e1be8910a65e.jpg', '0', '0', '0', '0', '0', '', '176', '0', '', '0', '', '', '36氪获悉，线下公众号推广公司乐摇摇科技已完成3800万元A+轮融资，投资方为广发信德。众所周知，如今线上流量昂贵，大家的目光开始聚焦线下。除了传统的地铁、电梯广告，线下也已经有一些新的广告模式，比如通过商业Wi-Fi获客，代表公司有迈外迪；比如现在餐饮店外常见的照片打印机，是专门服务公众号的效果广告。乐摇摇科技则选择利用抓娃娃机做流量分发。之所以从抓娃娃机切入，创始人陈耿豪认为主要原因有两点：首先，抓娃娃机国内存量有200万台，包括其在内的所有投币类设备存量约2000万台，这些机器无法进行移动支付，消费者和商家的痛点需要被解决；第二，抓娃娃机多在商场、KTV等地，用户群体是16到35岁女性，广告投放更精准。从广告受众的角度可以看出，乐摇摇比WI-FI获客更精准；而从乐摇摇的业务模式看，他们不像市面上的照片打印机那样自己生产机器，而是和机器生产厂家合作，只提供硬件盒子，因此业务模式更轻。具体看乐摇摇的业务模式，他们免费给机器提供硬件盒子和SaaS系统，由厂家安装好盒子后发货给商家，据统计，实现移动支付后的抓娃娃机能增加28%的收入。用户想抓娃娃时，先用微信扫码，这时有两种模式供选择，第', '1', '100', 'cn', '0', '1527899807', '1527899807');
INSERT INTO `ey_archives` VALUES ('65', '39', '1', '0', '产品名称六', '/public/upload/news/2018/06/08/c26a2ebf47057d5ac4c9a33ca26be346.jpg', '0', '0', '0', '0', '0', '', '151', '0', '', '0', '', '', '为客户降低采购成本和风险，为客户投资提供切实保障。追求永续发展的目标，并把它建立在客户满意的基础上。', '1', '100', 'cn', '0', '1527852009', '1528450460');
INSERT INTO `ey_archives` VALUES ('75', '39', '1', '0', '产品名称七', '/public/upload/news/2018/06/08/e64acd591aa36c69adab5ccd6a2a0af0.jpg', '0', '0', '0', '0', '0', '', '247', '0', '', '0', '', '', '为客户降低采购成本和风险，为客户投资提供切实保障。追求永续发展的目标，并把它建立在客户满意的基础上。', '1', '100', 'cn', '0', '1528187966', '1528450484');
INSERT INTO `ey_archives` VALUES ('64', '39', '1', '0', '产品名称五', '/public/upload/news/2018/06/08/c3c64ad6a6ed914688867769d2f5cb61.jpg', '0', '0', '0', '0', '0', '', '153', '0', '', '0', '', '', '为客户降低采购成本和风险，为客户投资提供切实保障。追求永续发展的目标，并把它建立在客户满意的基础上。', '1', '100', 'cn', '0', '1527851982', '1528450438');
INSERT INTO `ey_archives` VALUES ('76', '39', '1', '0', '产品名称八', '/public/upload/news/2018/06/08/a3bb270878a9541829ce4b9d4e54c5ad.jpg', '0', '0', '0', '0', '0', '', '223', '0', '', '0', '', '', '为客户降低采购成本和风险，为客户投资提供切实保障。追求永续发展的目标，并把它建立在客户满意的基础上。', '1', '100', 'cn', '0', '1528187994', '1528450513');
INSERT INTO `ey_archives` VALUES ('74', '46', '1', '0', '旅游市场将迎来内容红利？河马旅居想做旅游界的“小红书”', '/public/upload/remote/2018/06/02/5b11e78b80cef.png', '0', '0', '0', '0', '0', '', '200', '0', '', '0', '', '', '“内容为王”这句话在哪个时代都不会过时。随着消费升级，日益庞大的中国高端群体对高品质的生活方式与旅行体验的需求为高端出境旅游市场带来巨大市场机遇。现今的旅游产品也更向个性化、定制化、品质化靠拢，对内容创新提出更高的要求。内地的旅游内容市场仍有5-10倍的增长空间。最近36氪接触了一家做移动端旅游社区电商的团队——河马旅居指南。河马旅居定位中等收入人群18-34岁的年轻群体，想通过碎片化的PGC或UGC内容培养用户粘性，由内容社区模式切入出境游市场。传统的旅游内容多是以长图文的游记形式呈现，河马旅居并不刻意强调旅游路线或整个游历过程的感受，在内容呈现上更加碎片化、个性化、移动化以及品质化，以小众或特色地点作为维度输出内容，建立内容社区，类似于旅游界的“小红书”或“什么值得买”。河马旅居在部分海外旅游城市有一个4到5人的自媒体小团队定期生产PGC内容，每月更新一次内容，以优质的内容导流。目前河马的获客成本低至2-3元/人。优质的内容利于培养高粘性度的用户，当累计到一定数量的优质内容生产者，达到一定的用户规模时，将由PGC内容带动UGC内容的自发产出，进而开始搭建旅游内容社区，最后完成向旅游', '1', '100', 'cn', '0', '1527900027', '1528339662');
INSERT INTO `ey_archives` VALUES ('73', '46', '1', '0', '无人便利店风口正当时，“便利家”获联创永宣冯涛数百万元天使投资', '/public/upload/remote/2018/06/02/5b11e763b8800.png', '0', '0', '0', '0', '0', '', '268', '0', '', '0', '', '', '36氪获悉，无人便利店“便利家”已获得数百万人民币天使轮投资，资方为联创永宣冯涛。无人便利店风口正当时，缤果盒子、F5未来商店、深兰科技、EasyGo等一众玩家云集，亚马逊、罗森、阿里巴巴、沃尔玛等巨头亦纷纷试水。 “便利家”创立于2017年3月，位于上海。便利家有微型无人便利店和中型无人便利店两款产品，和一众玩家相比，便利家的差异化在于：灵活。 便利家的“微型无人便利店”，最小单位占地面积不到1平方米（0.68平方米），投放地点更加灵活，包括地铁站、写字楼、高校等，一个最小单位便利店的成本约为1.3万元（批量化生产后可能更低）。最小单位的无人便利店，可以根据人流量的分布，“拼”起来更大单位面积的便利店。低于100人，可放置一个；100人左右，可以拼两个；大于500人，可以拼四个。便利家的“中型无人便利店”，是由6个微型便利店拼起来的，同时在空间里增设桌椅，为消费者提供休憩区间，可放置在地理位置相对开阔的小区、公园等。技术上，便利家在每一层货架中设置了RFID，并在各个角落缝隙做了密封屏蔽，让识别率更高。流程很简单，用支付宝扫码开门，拿完即走，支付宝自动扣款（微信正', '1', '100', 'cn', '0', '1527899992', '1528339680');
INSERT INTO `ey_archives` VALUES ('72', '46', '1', '0', '腾讯500万美元领投AI创企ObEN，进一步布局社交AI', '/public/upload/remote/2018/06/02/5b11e74a4065b.png', '0', '0', '0', '0', '0', '', '259', '0', '', '0', '', '', '除了做基础技术的研究外，腾讯曾表示要通过业务驱动来推动各种应用场景的人工智能化。结合腾讯的主营业务，也不难猜到未来公司要在游戏、社交、内容和平台工具型四大应用方向发力。尤其是在社交领域，去年扎克伯格曾表示要推出VR版的Facebook，并展示了虚拟人物形象工具OculusAvatars；今年7月，Facebook表示FacebookAR工作室将与美图合作，向其提供三款AR相机特效。如今，腾讯也要有所行动了。7月18日晚间，人工智能初创公司ObEN宣布获得500万美元战略投资。该轮融资由腾讯领投，CMC董事长黎瑞刚及峰尚资本跟投。投融资信息平台crunchbase的数据显示，目前ObEN共完成四轮融资，总金额达到1370万美元。此前的投资人还包括S如山资本、软银韩国风险投资公司和HTCVIVEX等。公开资料介绍，ObEN创办于2014年，可以通过构建个性化的虚拟声音、形象和个性来创造用户的人工智能虚拟形象，并帮助用户在新兴的数字世界中存储、管理、运营他们的虚拟形象。也就是说，ObEN可以利用人工智能工具，根据用户的照片和声音创建虚拟形象，从而让用户有不同的AR、VR社交体验。以前ObEN', '1', '100', 'cn', '0', '1527899964', '1528339704');
INSERT INTO `ey_archives` VALUES ('78', '52', '6', '0', '技术支持', '', '0', '0', '0', '0', '0', '', '0', '0', '', '0', '', '', '', '1', '100', 'cn', '0', '1528254071', '1528333827');
INSERT INTO `ey_archives` VALUES ('90', '36', '1', '0', '案例展示七', '/public/upload/news/2018/06/06/fe6c4dc927aaaabe54e3cfb053b818fa.jpg', '0', '0', '0', '0', '0', '', '293', '0', '', '0', '', '', '核心价值观：诚信、创新、服务企业核心：诚信企业精神：团结拼搏、开拓求实、满足用户、科技进步。客户：为客户提供高质量和最大价值的专业化产品和服务，以真诚和实力赢...', '1', '100', 'cn', '0', '1528296618', '1528450777');
INSERT INTO `ey_archives` VALUES ('91', '36', '1', '0', '案例展示八', '/public/upload/news/2018/06/06/0380a50709b534db3ee3383322fa8945.jpg', '0', '0', '0', '0', '0', '', '137', '0', '', '0', '', '', '核心价值观：诚信、创新、服务企业核心：诚信企业精神：团结拼搏、开拓求实、满足用户、科技进步。客户：为客户提供高质量和最大价值的专业化产品和服务，以真诚和实力赢...', '1', '100', 'cn', '0', '1528296656', '1528450790');

-- -----------------------------
-- Table structure for `ey_arcrank`
-- -----------------------------
DROP TABLE IF EXISTS `ey_arcrank`;
CREATE TABLE `ey_arcrank` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT COMMENT '权限ID',
  `rank` smallint(6) DEFAULT '0' COMMENT '权限值',
  `name` char(20) DEFAULT '' COMMENT '会员名称',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='文档阅读权限表';

-- -----------------------------
-- Records of `ey_arcrank`
-- -----------------------------
INSERT INTO `ey_arcrank` VALUES ('1', '0', '开放浏览', 'cn', '0', '0');
INSERT INTO `ey_arcrank` VALUES ('2', '-1', '待审核稿件', 'cn', '0', '0');

-- -----------------------------
-- Table structure for `ey_arctype`
-- -----------------------------
DROP TABLE IF EXISTS `ey_arctype`;
CREATE TABLE `ey_arctype` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `channeltype` int(10) DEFAULT '0' COMMENT '栏目顶级模型ID',
  `current_channel` int(10) DEFAULT '0' COMMENT '栏目当前模型ID',
  `parent_id` int(10) DEFAULT '0' COMMENT '栏目上级ID',
  `typename` varchar(200) DEFAULT '' COMMENT '栏目名称',
  `dirname` varchar(200) DEFAULT '' COMMENT '目录英文名',
  `dirpath` varchar(200) DEFAULT '' COMMENT '目录存放HTML路径',
  `englist_name` varchar(200) DEFAULT '' COMMENT '栏目英文名',
  `grade` tinyint(1) DEFAULT '0' COMMENT '栏目等级',
  `typelink` varchar(200) DEFAULT '' COMMENT '栏目链接',
  `litpic` varchar(250) DEFAULT '' COMMENT '栏目图片',
  `templist` varchar(200) DEFAULT '' COMMENT '列表模板文件名',
  `tempview` varchar(200) DEFAULT '' COMMENT '文档模板文件名',
  `seo_title` varchar(200) DEFAULT '' COMMENT 'SEO标题',
  `seo_keywords` varchar(200) DEFAULT '' COMMENT 'seo关键字',
  `seo_description` text COMMENT 'seo描述',
  `sort_order` int(10) DEFAULT '0' COMMENT '排序号',
  `is_hidden` tinyint(1) DEFAULT '0' COMMENT '是否隐藏栏目：0=显示，1=隐藏',
  `is_part` tinyint(1) DEFAULT '0' COMMENT '栏目属性：0=内容栏目，1=外部链接',
  `admin_id` int(10) DEFAULT '0' COMMENT '管理员ID',
  `is_del` tinyint(1) DEFAULT '0' COMMENT '伪删除，1=是，0=否',
  `status` tinyint(1) DEFAULT '1' COMMENT '启用 (1=正常，0=屏蔽)',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  UNIQUE KEY `dirname` (`dirname`,`lang`) USING BTREE,
  KEY `parent_id` (`channeltype`,`parent_id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=56 DEFAULT CHARSET=utf8;

-- -----------------------------
-- Records of `ey_arctype`
-- -----------------------------
INSERT INTO `ey_arctype` VALUES ('1', '6', '6', '0', '关于我们', 'guanyuwomen', '/html/guanyuwomen', 'ABOUT US', '0', '', '/public/upload/arctype/2018/06/08/63f80bb272cb22ba0454b2eb5b3dba9e.jpg', 'lists_single.htm', '', '', '', '', '1', '0', '0', '0', '0', '1', 'cn', '1526539465', '1528443998');
INSERT INTO `ey_arctype` VALUES ('2', '1', '1', '0', '新闻动态', 'xinwendongtai', '/html/xinwendongtai', 'NEWS', '0', '', '/public/upload/arctype/2018/06/05/9f1a1ddd0052b10246b14d1279240198.jpg', 'lists_article.htm', 'view_article.htm', '', '', '', '3', '0', '0', '0', '0', '1', 'cn', '1526539487', '1528247205');
INSERT INTO `ey_arctype` VALUES ('35', '1', '1', '0', '产品中心', 'chanpinzhongxin', '/html/chanpinzhongxin', 'PRDUCTS', '0', '', '/public/upload/arctype/2018/06/06/c4f5689431a6c711a440d47ed08e3ef7.jpg', 'lists_article_img.htm', 'view_article.htm', '', '', '', '2', '0', '0', '0', '0', '1', 'cn', '1527645900', '1528338247');
INSERT INTO `ey_arctype` VALUES ('36', '1', '1', '0', '成功案例', 'chenggonganli', '/html/chenggonganli', 'CASE', '0', '', '', 'lists_article_img.htm', 'view_article.htm', '', '', '', '4', '0', '0', '0', '0', '1', 'cn', '1527645925', '1527852122');
INSERT INTO `ey_arctype` VALUES ('15', '6', '6', '0', '联系我们', 'lianxiwomen', '/html/danye', 'CONTACT', '0', '', '', 'lists_single.htm', '', '', '', '', '9', '0', '0', '0', '0', '1', 'cn', '1526551000', '1528249149');
INSERT INTO `ey_arctype` VALUES ('43', '1', '1', '35', '第五系列', 'diwuxilie', '/html/chanpinzhongxin/diwuxilie', '', '1', '', '', 'lists_article_img.htm', 'view_article.htm', '', '', '', '100', '0', '0', '0', '0', '1', 'cn', '1527647587', '1528338247');
INSERT INTO `ey_arctype` VALUES ('38', '1', '1', '0', '荣誉资质', 'rongyuzizhi', '/html/rongyuzizhi', 'HONOR', '0', '', '', 'lists_article_img.htm', 'view_article.htm', '', '', '', '6', '0', '0', '0', '0', '1', 'cn', '1527646068', '1527677065');
INSERT INTO `ey_arctype` VALUES ('39', '1', '1', '35', '第一系列', 'diyixilie', '/html/chanpinzhongxin/diyixilie', '', '1', '', '', 'lists_article_img.htm', 'view_article.htm', '', '', '', '100', '0', '0', '0', '0', '1', 'cn', '1527647518', '1528338247');
INSERT INTO `ey_arctype` VALUES ('40', '1', '1', '35', '第二系列', 'dierxilie', '/html/chanpinzhongxin/dierxilie', '', '1', '', '', 'lists_article_img.htm', 'view_article.htm', '', '', '', '100', '0', '0', '0', '0', '1', 'cn', '1527647537', '1528338247');
INSERT INTO `ey_arctype` VALUES ('41', '1', '1', '35', '第三系列', 'disanxilie', '/html/chanpinzhongxin/disanxilie', '', '1', '', '', 'lists_article_img.htm', 'view_article.htm', '', '', '', '100', '0', '0', '0', '0', '1', 'cn', '1527647554', '1528338247');
INSERT INTO `ey_arctype` VALUES ('42', '1', '1', '35', '第四系列', 'disixilie', '/html/chanpinzhongxin/disixilie', '', '1', '', '', 'lists_article_img.htm', 'view_article.htm', '', '', '', '100', '0', '0', '0', '0', '1', 'cn', '1527647571', '1528338247');
INSERT INTO `ey_arctype` VALUES ('46', '1', '1', '2', '公司动态', 'gongsidongtai', '/html/xinwendongtai/gongsidongtai', '', '1', '', '/public/upload/arctype/2018/06/01/317a3a657677312966c60ccb95914c02.jpg', 'lists_article.htm', 'view_article.htm', '', '', '', '100', '0', '0', '0', '0', '1', 'cn', '1527839899', '1528247205');
INSERT INTO `ey_arctype` VALUES ('47', '1', '1', '2', '行业资讯', 'xingyezixun', '/html/xinwendongtai/xingyezixun', '', '1', '', '/public/upload/arctype/2018/06/01/55162609e53f65c52fc2434808cb4201.jpg', 'lists_article.htm', 'view_article.htm', '', '', '', '100', '0', '0', '0', '0', '1', 'cn', '1527839913', '1528247205');
INSERT INTO `ey_arctype` VALUES ('53', '8', '8', '0', '在线留言', 'zaixianliuyan', '/html/zaixianliuyan', '', '0', '', '', 'lists_guestbook.htm', '', '', '', '', '100', '0', '0', '0', '0', '1', 'cn', '1528272137', '1528272137');
INSERT INTO `ey_arctype` VALUES ('52', '6', '6', '0', '技术支持', 'jishuzhichi', '/html/rencaizhaopin', 'RECRUITMENT', '0', '', '', 'lists_single.htm', '', '', '', '', '8', '0', '0', '0', '0', '1', 'cn', '1528254071', '1528333827');
INSERT INTO `ey_arctype` VALUES ('55', '1', '1', '0', '测试栏目', 'ceshilanmu', '/html/ceshilanmu', '', '0', '', '', 'lists_article.htm', 'view_article.htm', '', '', '', '100', '0', '0', '0', '0', '1', 'cn', '1528543199', '1528543199');

-- -----------------------------
-- Table structure for `ey_article_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_article_content`;
CREATE TABLE `ey_article_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `content` longtext COMMENT '内容详情',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `news_id` (`aid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=65 DEFAULT CHARSET=utf8 COMMENT='资讯内容表_存储正常内容';

-- -----------------------------
-- Records of `ey_article_content`
-- -----------------------------
INSERT INTO `ey_article_content` VALUES ('27', '51', '&lt;p style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;/public/upload/article/2018/06/06/c78ce3eb5a1911fe0a56c4d9b086b280.jpg&quot; title=&quot;c78ce3eb5a1911fe0a56c4d9b086b280.jpg&quot; alt=&quot;c78ce3eb5a1911fe0a56c4d9b086b280.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;核心价值观：诚信、创新、服务 企业核心： 诚信 企业精神： 团结拼搏、开拓求实、满足用户、科技进步。 客户：为客户提供高质量和最大价值的专业化产品和服务，以真诚和实力赢...&lt;/p&gt;', '1527665029', '1528450692');
INSERT INTO `ey_article_content` VALUES ('28', '52', '&lt;p style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;/public/upload/article/2018/06/06/9eff244e2b0a0e0fe02cac5744f1e9c3.jpg&quot; title=&quot;9eff244e2b0a0e0fe02cac5744f1e9c3.jpg&quot; alt=&quot;9eff244e2b0a0e0fe02cac5744f1e9c3.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;核心价值观：诚信、创新、服务 企业核心： 诚信 企业精神： 团结拼搏、开拓求实、满足用户、科技进步。 客户：为客户提供高质量和最大价值的专业化产品和服务，以真诚和实力赢...&lt;/p&gt;', '1527665066', '1528450710');
INSERT INTO `ey_article_content` VALUES ('29', '53', '&lt;p style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;/public/upload/article/2018/06/06/1b0e20f4cf1d6b45a196a024fc67b320.jpg&quot; title=&quot;1b0e20f4cf1d6b45a196a024fc67b320.jpg&quot; alt=&quot;1b0e20f4cf1d6b45a196a024fc67b320.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;核心价值观：诚信、创新、服务 企业核心： 诚信 企业精神： 团结拼搏、开拓求实、满足用户、科技进步。 客户：为客户提供高质量和最大价值的专业化产品和服务，以真诚和实力赢...&lt;/p&gt;', '1527665090', '1528450722');
INSERT INTO `ey_article_content` VALUES ('30', '54', '&lt;p style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;/public/upload/article/2018/06/06/c6cefc344ae61ead82148ccf1b341fe4.jpg&quot; title=&quot;c6cefc344ae61ead82148ccf1b341fe4.jpg&quot; alt=&quot;c6cefc344ae61ead82148ccf1b341fe4.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;核心价值观：诚信、创新、服务 企业核心： 诚信 企业精神： 团结拼搏、开拓求实、满足用户、科技进步。 客户：为客户提供高质量和最大价值的专业化产品和服务，以真诚和实力赢...&lt;/p&gt;', '1527665111', '1528450735');
INSERT INTO `ey_article_content` VALUES ('31', '55', '&lt;p style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;/public/upload/article/2018/06/06/7bfab33e94955d4da0729315236320d8.jpg&quot; title=&quot;7bfab33e94955d4da0729315236320d8.jpg&quot; alt=&quot;7bfab33e94955d4da0729315236320d8.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;核心价值观：诚信、创新、服务 企业核心： 诚信 企业精神： 团结拼搏、开拓求实、满足用户、科技进步。 客户：为客户提供高质量和最大价值的专业化产品和服务，以真诚和实力赢...&lt;/p&gt;', '1527665145', '1528450748');
INSERT INTO `ey_article_content` VALUES ('32', '56', '&lt;p style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;/public/upload/article/2018/06/06/5adfdad99741a7a33585c45cbf9a3406.jpg&quot; title=&quot;5adfdad99741a7a33585c45cbf9a3406.jpg&quot; alt=&quot;5adfdad99741a7a33585c45cbf9a3406.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;核心价值观：诚信、创新、服务 企业核心： 诚信 企业精神： 团结拼搏、开拓求实、满足用户、科技进步。 客户：为客户提供高质量和最大价值的专业化产品和服务，以真诚和实力赢...&lt;/p&gt;', '1527665172', '1528450761');
INSERT INTO `ey_article_content` VALUES ('14', '38', '&lt;p style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;/public/upload/article/2018/05/30/e5c97df07e404b216c699fa481eb8419.jpg&quot; title=&quot;e5c97df07e404b216c699fa481eb8419.jpg&quot; alt=&quot;e5c97df07e404b216c699fa481eb8419.jpg&quot;/&gt;&lt;/p&gt;', '1527664149', '1527664149');
INSERT INTO `ey_article_content` VALUES ('15', '39', '&lt;p style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;/public/upload/article/2018/05/30/a253987e39844055ceca712844361e28.jpg&quot; title=&quot;a253987e39844055ceca712844361e28.jpg&quot; alt=&quot;a253987e39844055ceca712844361e28.jpg&quot;/&gt;&lt;/p&gt;', '1527664280', '1527664280');
INSERT INTO `ey_article_content` VALUES ('16', '40', '&lt;p style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;/public/upload/article/2018/05/30/7cdd126e2c293715df52a16ca503e161.jpg&quot; title=&quot;7cdd126e2c293715df52a16ca503e161.jpg&quot; alt=&quot;7cdd126e2c293715df52a16ca503e161.jpg&quot;/&gt;&lt;/p&gt;', '1527664307', '1527664307');
INSERT INTO `ey_article_content` VALUES ('17', '41', '&lt;p style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;/public/upload/article/2018/05/30/738ab10c825c2c9863c53e0243769dee.jpg&quot; title=&quot;738ab10c825c2c9863c53e0243769dee.jpg&quot; alt=&quot;738ab10c825c2c9863c53e0243769dee.jpg&quot;/&gt;&lt;/p&gt;', '1527664331', '1527664331');
INSERT INTO `ey_article_content` VALUES ('18', '42', '&lt;p&gt;&lt;br/&gt;&lt;/p&gt;&lt;p style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;/public/upload/article/2018/06/08/19474d01504dce77d6f5c2fd6a225cf3.jpg&quot; title=&quot;19474d01504dce77d6f5c2fd6a225cf3.jpg&quot; alt=&quot;19474d01504dce77d6f5c2fd6a225cf3.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;为客户降低采购成本和风险，为客户投资提供切实保障。 追求永续发展的目标，并把它建立在客户满意的基础上。&lt;/p&gt;', '1527664373', '1528450284');
INSERT INTO `ey_article_content` VALUES ('19', '43', '&lt;p style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;/public/upload/article/2018/06/08/1ee6eea6bee30289768dbe97d6e0774a.jpg&quot; title=&quot;1ee6eea6bee30289768dbe97d6e0774a.jpg&quot; alt=&quot;1ee6eea6bee30289768dbe97d6e0774a.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;为客户降低采购成本和风险，为客户投资提供切实保障。 追求永续发展的目标，并把它建立在客户满意的基础上。&lt;br/&gt;&lt;/p&gt;', '1527664459', '1528450323');
INSERT INTO `ey_article_content` VALUES ('20', '44', '&lt;p style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;/public/upload/article/2018/06/08/c9abd12a91c1a09834736fd0dd223a25.jpg&quot; title=&quot;c9abd12a91c1a09834736fd0dd223a25.jpg&quot; alt=&quot;c9abd12a91c1a09834736fd0dd223a25.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;为客户降低采购成本和风险，为客户投资提供切实保障。 追求永续发展的目标，并把它建立在客户满意的基础上。&lt;/p&gt;', '1527664498', '1528450387');
INSERT INTO `ey_article_content` VALUES ('50', '76', '&lt;p style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;/public/upload/article/2018/06/08/1255e65bd982631199573ec5a5c8007b.jpg&quot; title=&quot;1255e65bd982631199573ec5a5c8007b.jpg&quot; alt=&quot;1255e65bd982631199573ec5a5c8007b.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;为客户降低采购成本和风险，为客户投资提供切实保障。 追求永续发展的目标，并把它建立在客户满意的基础上。&lt;/p&gt;', '1528187994', '1528450513');
INSERT INTO `ey_article_content` VALUES ('21', '45', '&lt;p style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;/public/upload/article/2018/06/08/dcad26fbf80ff11df95921181057307a.jpg&quot; title=&quot;dcad26fbf80ff11df95921181057307a.jpg&quot; alt=&quot;dcad26fbf80ff11df95921181057307a.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;为客户降低采购成本和风险，为客户投资提供切实保障。 追求永续发展的目标，并把它建立在客户满意的基础上。&lt;/p&gt;', '1527664551', '1528450421');
INSERT INTO `ey_article_content` VALUES ('38', '64', '&lt;p style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;/public/upload/article/2018/06/08/68ecc69eaffff74ccd9610f7045aaf37.jpg&quot; title=&quot;68ecc69eaffff74ccd9610f7045aaf37.jpg&quot; alt=&quot;68ecc69eaffff74ccd9610f7045aaf37.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;为客户降低采购成本和风险，为客户投资提供切实保障。 追求永续发展的目标，并把它建立在客户满意的基础上。&lt;/p&gt;', '1527851982', '1528450438');
INSERT INTO `ey_article_content` VALUES ('39', '65', '&lt;p style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;/public/upload/article/2018/06/08/8fb388f5c2b5f4dbe88fc942e14e76de.jpg&quot; title=&quot;8fb388f5c2b5f4dbe88fc942e14e76de.jpg&quot; alt=&quot;8fb388f5c2b5f4dbe88fc942e14e76de.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;为客户降低采购成本和风险，为客户投资提供切实保障。 追求永续发展的目标，并把它建立在客户满意的基础上。&lt;/p&gt;', '1527852009', '1528450460');
INSERT INTO `ey_article_content` VALUES ('49', '75', '&lt;p style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;/public/upload/article/2018/06/08/0456f330551eb83ba65c90ce4a06f892.jpg&quot; title=&quot;0456f330551eb83ba65c90ce4a06f892.jpg&quot; alt=&quot;0456f330551eb83ba65c90ce4a06f892.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;为客户降低采购成本和风险，为客户投资提供切实保障。 追求永续发展的目标，并把它建立在客户满意的基础上。&lt;/p&gt;', '1528187966', '1528450484');
INSERT INTO `ey_article_content` VALUES ('40', '66', '&lt;p&gt;腾讯不仅在阿里怂恿大家花钱的双十一之际高调派钱，如今财报的高速增长业务也刚好跟支付宝和阿里云对标。&lt;/p&gt;&lt;p&gt;今日晚间，腾讯发布今天公布未经审核的第三季度财报。报告显示，腾讯三季度总收入同比增长52%，增速与上季度持平；净利润增速有所下滑。&lt;/p&gt;&lt;p&gt;值得注意的是，腾讯游戏营收比重已经连续两个季度下降，三季度网络游戏收入仅占总营收的45%；而支付和云计算等新兴业务的比重则继续上升，首次超过10%，达到12%。&lt;/p&gt;&lt;h3&gt;净利润增速下滑&lt;/h3&gt;&lt;p&gt;总体财务状况方面，腾讯三季度总收入为人民币403.88亿元（60.48亿美元），同比增长52%，增速与上季度持平。但是盈利增速却有所下滑，期内盈利为人民币107.76亿元（16.14亿美元），比去年同期增长42%；净利润率由去年同期的29%降至27%。&lt;/p&gt;&lt;p&gt;&lt;img alt=&quot;&quot; src=&quot;/public/upload/remote/2018/06/02/5b11e6836ac91.png&quot;/&gt;&lt;/p&gt;&lt;h3&gt;游戏营收占比连续两个季度下滑&lt;/h3&gt;&lt;p&gt;分部业务方面，包括网络游戏和社交网络在内的增值业务依然是腾讯收入的大头，占比约八成。然而，一向被视为腾讯摇钱树的游戏业务，其收入占比却连续两季下降，如今占总营收比重仅有45%左右，该项业务在2015年一度占腾讯营收六成。而社交网络收入增速则在逐步增长，占比一直稳定在23-24%。&lt;/p&gt;&lt;p&gt;&lt;img alt=&quot;&quot; src=&quot;/public/upload/remote/2018/06/02/5b11e6836d308.png&quot;/&gt;&lt;/p&gt;&lt;p&gt;再往细看，手游已经成了游戏业务的主力，在181亿元的游戏业务收入中，手游为99亿元，同比增长87%；端游收入同比增长仅有10%，而且据财报显示，端游的平均同时在线用户还有下降，因此，腾讯正将工作重点从增加用户在游戏内的时长转至扩展用户互动方式。&lt;/p&gt;&lt;p&gt;网络广告收入的占比同样较稳定，约占集团收入17%。其中，效果广告收入增长明显，增速达83%，主要由于来自微信朋友圈、移动端新闻应用及微信公众账号广告收入的贡献。微信也不断在探索朋友圈变现的方式，包括其最近上线的朋友圈的LBS本地推广广告和原生推广页广告。&lt;/p&gt;&lt;p&gt;此外，在QQ月活跃用户（8.77亿，比去年同期增长2%）见顶的背景下，微信和WeChat的合并月活跃账户数依然在继续增长，达到8.46亿，比去年同期增长30%。然而，与QQ的月活用户数相比，如果微信未能进一步国际化，其用户见顶之日显然已经不远了，因此，微信目前的工作重心已经不再是增加微信的用户，而是想办法如何让用户们留在微信上，将所有时间都花在这个应用里。因此，微信正在测试“小程序”，让用户无需离开微信界面便可进行低频次互动。&lt;/p&gt;&lt;h3&gt;其他业务收入增长348%&lt;/h3&gt;&lt;p&gt;增长最亮眼的是包括支付及云服务在内的其他业务，同比增长348%，至人民币49.64亿元。至此，其他业务占集团收入的比重已经达到12%，首次超过10%。&lt;/p&gt;&lt;p&gt;阿里和腾讯本来在国内已是两大支付巨头，前者依靠电商，后者依靠社交，展开了多次支付减免大战。支付宝最近更是出海动作频频，腾讯也已经继支付宝之后，开始布局东南亚的支付市场。&lt;/p&gt;&lt;p&gt;同时，虽然其中云服务的具体收入没有披露，但即便是在国内公有云市场一家独大的阿里云，其占阿里总营收也不过只有4%，加上这个市场才刚刚开始，坐拥强大资本的腾讯在游戏这个垂直领域上有着自身的优势，又有布局人工智能领域的意思，要奋起直追也并非难事。&lt;/p&gt;&lt;p&gt;如此看来，尽管腾讯曾在电商领域受挫，影业方面也未有阿里的大动作，但在支付和云计算两个阿里的明星业务上，与腾讯可能还得迎来几场血战。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '1527899765', '1527899765');
INSERT INTO `ey_article_content` VALUES ('41', '67', '&lt;p&gt;36氪获悉，线下公众号推广公司乐摇摇科技已完成 3800 万元 A+ 轮融资，投资方为广发信德。&lt;/p&gt;&lt;p&gt;众所周知，如今线上流量昂贵，大家的目光开始聚焦线下。除了传统的地铁、电梯广告，线下也已经有一些新的广告模式，比如通过商业 Wi-Fi 获客，代表公司有迈外迪；比如现在餐饮店外常见的照片打印机，是专门服务公众号的效果广告。乐摇摇科技则选择利用抓娃娃机做流量分发。&lt;/p&gt;&lt;p&gt;之所以从抓娃娃机切入，创始人陈耿豪认为主要原因有两点：首先，抓娃娃机国内存量有 200 万台，包括其在内的所有投币类设备存量约 2000 万台，这些机器无法进行移动支付，消费者和商家的痛点需要被解决；第二，抓娃娃机多在商场、KTV 等地，用户群体是 16 到 35 岁女性，广告投放更精准。&lt;/p&gt;&lt;p&gt;从广告受众的角度可以看出，乐摇摇比 WI-FI 获客更精准；而从乐摇摇的业务模式看，他们不像市面上的照片打印机那样自己生产机器，而是和机器生产厂家合作，只提供硬件盒子，因此业务模式更轻。&lt;/p&gt;&lt;p&gt;具体看乐摇摇的业务模式，他们免费给机器提供硬件盒子和 SaaS 系统，由厂家安装好盒子后发货给商家，据统计，实现移动支付后的抓娃娃机能增加 28% 的收入。用户想抓娃娃时，先用微信扫码，这时有两种模式供选择，第一种是充值使用，用户充值后即可花 1 元抓娃娃；第二种是免费使用，用户选择此模式后，关注一个广告主的微信公众号，即可免费抓一次娃娃，通常用户会看到三、四个广告主的公众号。&lt;/p&gt;&lt;p&gt;&lt;img alt=&quot;&quot; src=&quot;/public/upload/remote/2018/06/02/5b11e6bd1a376.png&quot;/&gt;&lt;/p&gt;&lt;p&gt;通过这种方式，乐摇摇（目前安装了 30000 台机器）每台机器平均每天分发广告 10 次，整个平台每天能为公众号涨粉约 30 万个，平均每个号 7、8 万个，一周的平均留存率为 65%。通常使用广点通的获客成本是接近 3 元一个，使用乐摇摇则是 1 元多一个。除了价格便宜，陈耿豪认为线下互动产生的流量会比线上更真实，更具有场景化，不过他也介绍说，乐摇摇和广点通并非替代关系，公众号一般会结合不同的方式获取用户。&lt;/p&gt;&lt;p&gt;据陈耿豪介绍，全国大部分抓娃娃机的厂家都在广州番禺，他们已合作了 300 多家，基本覆盖所有厂家，前面提到他们已安装 3 万台机器，覆盖中国 291 个城市，他们计划在 2017 年达到 10 万台。在此之后，他们会扩展到其他游戏类投币机。&lt;/p&gt;&lt;p&gt;目前乐摇摇已经合作的公众号超过 100 个，客户包括广州潮生活、同道大叔、新榜等内容创业者，以及碧桂园、蜜芽等品牌公众号。广告订单为几千万元，乐摇摇按一定比例抽取利润。陈耿豪认为，目前公众号需求量最大，今后小程序也可以成为他们的客户。&lt;/p&gt;&lt;p&gt;除了广告分发变现之外，乐摇摇还希望在未来尝试更多变现方式。在沉淀用户数足够多时，计划通过用户运营变现，可能会尝试游戏、电商等方式；目前月流水为 4000 万元，未来计划开展支付金融和产业链整合业务。&lt;/p&gt;&lt;p&gt;团队方面，创始人陈耿豪曾在联合利华和惠普有 3 年营销工作经验，2011 年曾创立营销互动公司微电互动，2015 年被某上公司并购。CMO徐德强曾是搜狐焦点威海站南通站总经理；CTO杨凯然曾任职于甲骨文；业务VP张杰波是平安保险高管。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '1527899807', '1527899807');
INSERT INTO `ey_article_content` VALUES ('42', '68', '&lt;p&gt;从2014年起，网络大电影这个词逐渐进入人们的眼球，当时满地都是几十万制作成本博得百万票房的故事，考拉娱乐便是在那个网生内容的蛮荒时代入的局。&lt;/p&gt;&lt;p&gt;在接受36氪采访时，考拉娱乐创始人钱伟坦言借过去的势他们赚到了不少钱，“我们有个片子8万成本，最后回收了一百多万的票房。”在过去的两年间，他们平均一年能做20多部大电影，在各大视频网站上收益排名Top10中，你很容易就能发现考拉出品的好几部片子，也给他们积累了很多渠道资源。&lt;/p&gt;&lt;p&gt;但当时间跨入今年后，网络大电影市场开始洗牌，去年整个市场上600多部片子突然激增到2000部以上，四两拨千斤的时代已经过去了，你会发现排名靠前的网大制作成本基本都在百万以上，已经达到了二三线院线水平。&lt;/p&gt;&lt;p&gt;&lt;img alt=&quot;&quot; src=&quot;/public/upload/remote/2018/06/02/5b11e6db26ef2.png&quot;/&gt;&lt;/p&gt;&lt;p&gt;近期推出的黄金赌城系列&lt;/p&gt;&lt;p&gt;市场红利期过去后，考拉娱乐在今年就开始了他们新的布局：瞄准女性市场，做精品网生内容。“这个其实是之前就规划好的，洗牌是肯定的。”钱伟说今年他们上半年基本没有怎么发片子，都在为今后的“慢”内容做准备。&lt;/p&gt;&lt;p&gt;考拉娱乐首先改变的是IP孵化方式，他们组建了一支漫画团队，定位是连载时间在三年以上的长篇大世界观作品，当这些作品经过市场验证后，逐步推出相应的网络剧、大电影等衍生内容。&lt;/p&gt;&lt;p&gt;其上半年验证这个模式的作品《极品修真少年》目前连载52话就超过3.5亿人气，同名大电影也已经开拍，“根粉丝对于这种做法反馈非常良好。”钱伟说未来自家头部的女性向作品都会以这种模式推出，做IP放大，然后去做游戏等方面的衍生，他们也已经跟一些游戏、影视公司达成了合作。&lt;/p&gt;&lt;p&gt;&lt;img alt=&quot;&quot; src=&quot;/public/upload/remote/2018/06/02/5b11e6db2973d.png&quot;/&gt;&lt;/p&gt;&lt;p&gt;在开始规划长线IP的同时，考拉娱乐还在构建自己的渠道，“跟当年手游潮一样，开始洗牌后渠道会越来越强势，CP的话语权会下降。”钱伟说这也是在为未来做打算，不让自己完全受制于平台，现在考拉的做法是做女性向的PGC直播内容。&lt;/p&gt;&lt;p&gt;目前他们已经接入微信小程序，自主开发了一个PGC直播频道，跟一些女性向大号联合推出定制的直播内容，满足这些大号图文内容向视频内容升级需求同时积攒垂直领域的流量，为今后自家女性向的漫画、网生内容做准备。现在这个频道仍在测试中，只在每晚8点进行直播，平均在线人数在几千左右。&lt;/p&gt;&lt;p&gt;“合作过的公众号反馈都还OK，未来希望把它变成一个全天直播的女性频道。”钱伟表示这个平台并不需要很大，目的是形成IP孵化、渠道推广、变现的内部循环。当然，构建自家渠道并不意味着考拉要放弃平台渠道，接下来他们出品的几部作品都跟平台有深度的合作。&lt;/p&gt;&lt;p&gt;在确定新的内容孵化和渠道推广模式后，钱伟表示他们在核心的网生内容生产上也完成了升级，现在考拉在制作上也采用了编剧和制片人核心制，过去推出的大量作品其实是在做人才筛选，“比如不能适应这种模式的导演被我们淘汰掉了。”钱伟说在合作的几十位导演中，他们只留下了两位。&lt;/p&gt;&lt;p&gt;未来考拉娱乐会以每年10部左右网络大电影的节奏推进，一部分是以漫画为源头的女性向慢内容，做长线的IP变现，另一部分则为保证考拉品牌活跃度以及创造流水的市场向内容。&lt;/p&gt;&lt;p&gt;团队方面，钱伟是投资人出身，曾担任创东方投资总监，环宇互动传媒创始人。负责公司整体布局和影视原创内容的规划，在漫画和直播方面则有另外两位合伙人负责，漫画合伙人付韬曾担任西山居游戏制作人。&lt;/p&gt;&lt;p&gt;此前他们已经获得由合一资本和创东方投资的数千万A轮融资，目前正在准备A+轮。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '1527899852', '1527899852');
INSERT INTO `ey_article_content` VALUES ('43', '69', '&lt;p&gt;36氪从ofo内部获得消息，可能在今年4月份，ofo将会接入到滴滴出行的App上，届时用户可以直接在滴滴上面使用ofo的服务。&lt;/p&gt;&lt;p&gt;“这件事最近被频繁地提上日程，内部消息是下个月就有可能接入。”一名ofo内部员工说。36氪向滴滴官方、ofo官方求证了此消息，但截止发稿时，两家公司均未对此确认或否认。&lt;/p&gt;&lt;p&gt;ofo创始人戴威曾在去年12月表示，何时接入滴滴APP，没有明确的时间表。“ofo的模式是没有GPS的，用户看到车就用，整个逻辑跟滴滴平台打车的逻辑不太一样，但近期我们会跟滴滴联合推出一些东西。”&lt;/p&gt;&lt;p&gt;不过类似的接入并非没有先例。今年2月，微信联合摩拜单车宣布，用户通过微信“扫一扫”扫描摩拜单车车身上的二维码，就可直接进入摩拜单车微信小程序，点击开锁即可用车。&lt;/p&gt;&lt;p&gt;这并不是第一次传出ofo会接入滴滴的消息，也不是两个平台的第一次深度绑定。此前，滴滴参与了ofo最近三轮的融资。根据腾讯科技的报道，一位共享单车投资人透露，ofo经过多轮融资以后，滴滴已经成为ofo最大股东，占股超过30%。“这意味着，滴滴在ofo的话语权更强了，同时，ofo的成与败，滴滴将是最大利息相关方。”&lt;/p&gt;&lt;p&gt;这也不难理解，滴滴将ofo接入之后，将作为巨大的用户流量入口为其导流，而ofo则进一步巩固生意体量，在滴滴的加持下提高行业地位和想象空间。&lt;/p&gt;&lt;p&gt;而且，如果真的将ofo接入进来，也意味着滴滴及其背后的资本在进一步弥补自己在出行领域的缺口。&lt;/p&gt;&lt;p&gt;有知情人向36氪透露，曾经滴滴也想做共享单车，但是出于某些原因没能实现，最终只能作为ofo的投资方。不过这并不意味着滴滴不会更进一步涉足这个市场。&lt;/p&gt;&lt;p&gt;滴滴投资ofo，无非是瞄准了“最后三公里”的机会。&lt;/p&gt;&lt;p&gt;当前国内在“最后三公里”领域仍是一个非常初级的阶段，也没有系统性服务商。而在北上广的一线城市，交通的繁复令各大出行平台对“最后三公里”争夺日趋激烈。&lt;/p&gt;&lt;p&gt;“从出发地到目的地3公里，到底是打车还是骑车，这对于用户来说是可以选择的，选哪一个都说得过去。”一名ofo内部员工说，而滴滴的做法就是自己要把不同的选项全部覆盖。&lt;/p&gt;&lt;p&gt;在滴滴和ofo及其投资人看来，共享单车领域已经迎来了一个快速增长期。Ofo的一名公关曾对媒体表示，以专车和快车为例，2012 年之后的这几年，发展速度是非常快的。ofo 则是在 1 年的时间里，把日订单量从 200 单做到了50万单，“过去的专车快车，现在的 ofo 都是经历着高速的增长，这个势头是类似的”。上述公关人员说。&lt;/p&gt;&lt;p&gt;去年12月末，ofo联合滴滴推出红包活动，这是ofo被滴滴战略投资后双方首次进行大规模合作。而活动采取的红包策略，也被认为是滴滴历来进行市场推广的利器之一。&lt;/p&gt;&lt;p&gt;按照滴滴方的说法，2017年仍旧会将主要精力放在出行领域，希望能够打通每个人的出行。这意味着所有的出行方式都将会被覆盖到，共享单车也会是滴滴发力的方向之一。&lt;/p&gt;&lt;p&gt;36氪认为，滴滴进一步接入共享单车还有一个重要的原因在于，与“苛刻”的互联网专车规定相比，共享单车发展初期便受到了政策鼓励，约束条件也颇为合理。而去年至今一直受网约车新政影响的滴滴出行无论是从政策角度，还是从新的业务增长角度来看，都有可能会更进一步从共享单车的风口上分得一杯羹。&lt;/p&gt;&lt;p&gt;不过，36氪还有疑问，没有导航的ofo要怎么接入滴滴，以及接入之后到底会给用户带来哪些影响？&lt;/p&gt;&lt;p&gt;“据我了解到的情况是，滴滴可能会把技术和导航这快的事情承包给第三方公司。”上述ofo内部员工说，接入滴滴之后的ofo可能依旧没有导航，用户在页面上主要行使扫码开锁和支付功能。&lt;/p&gt;&lt;p&gt;至于用户体验方面，上述内部员工表示，“本来ofo的主体功能就比较单一，操作起来非常的简单，相信可以无缝对接到滴滴平台上，”他强调，“毕竟未来的趋势是，人们手机上装载的app数量将会越来越少”。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '1527899881', '1527899881');
INSERT INTO `ey_article_content` VALUES ('44', '70', '&lt;p&gt;编者按：人工智能技术的发展正在不断地改变着人们的生活与工作方式，它在一定程度上推动了社会的发展与进步，这一点是毋庸置疑的。但人工智能并不是万能的，因为机器并不具备人类的思维与情绪。当你打开网站上的在线求助窗口，却发现回答你的只是冷冰冰的机器人的时候，恐怕应该会很失望吧。&lt;/p&gt;&lt;p&gt;2016年4月，马克·扎克伯格在Facebook的F8会议上为Messenger上的开发者们描述了一个光明的未来，并宣布将进入“像和朋友一样与机器人聊天”的新时代。世界各地的开发人员，这些开发人员都拥有Facebook、Google和Microsoft等大公司的认证，都声称独立移动应用程序的时代结束了，并一起庆祝新的方式的到来——对话商务（Conversational Commerce）和聊天机器人（Chatbots）。11个月前，Facebook宣布其官方开发的聊天机器人“M”的beta测试中AI失败率为70％，随后便更新了其平台，并建议开发人员在Messenger中开发更轻量级的应用程序，同时禁用会话输入。&lt;/p&gt;&lt;p&gt;关于Wordhop.io，一直以来我们都知道两件事。第一件事就是，AI真的很难，要实现让机器人100％像朋友一样与人类交流还需要很多年。毕竟，机器人不能像人一样产生共鸣。第二，Facebook消费者不会因为他们想购物或对天气感兴趣而给一个企业发送消息。这些体验是以具备聊天机器人为前提条件的，并且还需要已从信息传递领域拓展到社交网络领域的行业数据的支撑。&lt;/p&gt;&lt;p&gt;Facebook用户真正想要的就是，在有问题的时候可以迅速得到商家的回复。&lt;/p&gt;&lt;p&gt;消费者在Facebook上给商家发送消息的主要原因是想要获得服务。其他的一切都是浮云。这样的交互式预售可能从客户的发问开始，及时的答复可以推进交易的进行。如果客户联系销售客服，通常是因为他们真的有问题需要请教客服。一些答案可以由机器人回答，而更复杂的问题可以交给人来解决，在有得力工具的情况下，人类的回复速度可以媲美机器人。&lt;/p&gt;&lt;p&gt;然而许多机器人开发者没有将注意力集中在最有需求的那部分上，而是寻求创造新的用户体验，或重新开发升级旧的关于chatbot的概念。如果机器人开发者觉得参与率低，这可能不是因为AI失败了，而是因为他们把消费者往一条最开始就不想走的路上引。没有利用已存在的消费者行为模式，也没有训练机器人回应客户的需求，AI的作用只是，实现机器人开发商想象中的创造性体验并指导消费者通过该体验来进行交互。&lt;/p&gt;&lt;p&gt;Facebook现在建议机器人开发人员完全禁用会话输入。&lt;/p&gt;&lt;p&gt;我个人并不认为，像Facebook建议的那样禁用聊天输入是针对AI和NLP的技术限制的正确解决方案。无对话能力的通信机器人对于新闻机器人是可以接受的，这其中的体验由通知和内容消费驱动。但是，如果是以服务为基础的业务的话，则需要为用户提供一个可以与你友好互动的平台。如果文字输入是Messenger的主要方式，那么就会限制客户的沟通意愿和能动性，并迫使他们寻求你能想象到的其他方式的客户服务，又或者只是延迟回复都会让客户更加失望。想一想IVR吧，每次听完菜单选项后，你要按几下“0”。&lt;/p&gt;&lt;p&gt;商界应该采用自动和人工相结合的方式，这样才能满足Facebook用户的需求。&lt;/p&gt;&lt;p&gt;中国的微信的小程序是整合于消息互动的，这满足了开发者对聊天机器人的期待，但是这是东方的文化现象，而西方企业则应该首先利用已有的消费者行为，并且要更好地利用这样的行为数据。如果你不是“聊天机器人会取代人工服务”这一概念的拥趸，只是坚守开业之初对顾客的承诺，那么引入这样的科技就可以帮助你加强与客户间的交流。如果你能够实现现在Facebook消费者们的期望，那么随着时间的推移，你也可以增加新的功能，并将消费者往你所期待的方向引领。最终你很可能会满足他们的需求。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '1527899912', '1527899912');
INSERT INTO `ey_article_content` VALUES ('45', '71', '&lt;p&gt;数据显示，2015年，我国服务业同比增长8.3%，分别高于国内生产总值和第二产业增加值增速1.4和2.3个百分点，占国内生产总值的比重达到50.5%，首次过半，而与发达国家相比，我国服务业仍有20%-30%的发展空间。美业属于实体服务业，整个市场有上千亿的规模，但是信息化程度和零售餐饮业相比着实比较低。其中的原因就是餐饮和零售客流量大，触达人群广，而美业客流量相对小，加上从业人员素质导致信息化程度低、管理效率低。&lt;/p&gt;&lt;p&gt;美业现在的主要管理方式是纸质账本和简单的收银、结算软件，纸质管理约占行业客户的90%，功能简单只能用于管理会员卡的单机版管理软件约占9%。美业的客户与店面的粘性比较高，虽然是低频次消费，但是一旦用户选择一家店，在接收到较好服务之后很难再转向其它店，因此美业在预约管理、客户管理等需求上要高于餐饮和零售，应用的软件形态并不一定以结算收银为主，重点是CRM系统、收银、绩效考核、预约为一体的管理软件。&lt;/p&gt;&lt;p&gt;36氪近日了解的门庭管店是一款美业 SaaS 产品，主要功能有&amp;nbsp;SCRM 会员管理、智能预约、绩效工资、 营销卡券、全能收银等。门庭管店产品在客户方是微信公众号和小程序；美容师端是用于客户关系维系、工资查询和预约的移动端；前台端是 Upad，主要是收银和预约；还有一个店长用的总后台，主要是 PC 或者一体化智能机，做整体的数据管理。&lt;/p&gt;&lt;p&gt;其实管理的过程也是沉淀数据的过程，也是开发闭环和生态的过程，CEO 孟凡刚告知记者，门庭管店现在先用营销工具+SaaS 系统，切入线下美业门店，建立强关系，然后通过收银系统嵌入微信、支付宝支付，将门店的线上流水导入平台沉垫大量资金，最后在基于 SaaS 交易数据、消费行为数据进行大数据分析延伸美业产品、项目供应链。比如门庭管店最近正在做韩国的皮肤检测仪，检测完之后放在客户档案里，综合到智能管理平台，这样顾客再来的时候就可以针对个人特点进行服务。&lt;/p&gt;&lt;p&gt;美业的变革形成了两个阵营，一个阵营是大型会所，积累了很多老顾客，老顾客随着年龄的增长对养生的需求越来越强烈，一旦切入了养生，就和80、90这些互联网主力军有些脱离；还有一类是近两年新开的店，新开的店没有老会员的资源，那么如何针对80、90人群做服务就变成了主要任务 ，年轻人属于互联网使用场景人群，因此新店更容易植入 SaaS 软件。门庭管店更偏向于年轻化的店，在积累了一段时间的经验和资金之后再做老店。&lt;/p&gt;&lt;p&gt;对于没有信息化的店，前期的数据录入是最麻烦的，门庭管店会派客服帮助整理数据，时间大概是2-3天。其次就是软件使用的普及，关于这一点，门庭管店有专门的培训，包括音视频的远程培训。收费模式上分为私有云部署和公有云，公有云不过万元，之后每年有1000元维护费用。整个软件的安装大概能为门店省下一个人的成本。&lt;/p&gt;&lt;p&gt;门庭管店的客户包括克丽缇娜、丝域养发、庆熙美学、千禧鸟、自然美等。&lt;/p&gt;&lt;p&gt;行业竞品方面，美业 SaaS 提供商还包括博卡、喔噻、美约汇、美丽加、点美、美业邦等。&lt;/p&gt;&lt;p&gt;孟凡刚认为做美业 SaaS 的一个门槛就是软件研发能力，只有有比较强的研发能力才能开发出页面简洁、功能齐全、适用于管理的产品，客户与公司粘性才会提高，所以门庭管店来的想法是以做出更智能化的产品；其次一点就是销售能力，门庭管店现在采用合伙人方式，代理渠道可以发展自己的客户，目前门庭合伙人有100多个。&lt;/p&gt;&lt;p&gt;团队现在30人，一半以上为技术人员，CEO 孟凡刚曾任会友科技 CEO、随车记 CEO，有8年的互联网及移动互联网运营管理经验。公司已经完成了天使轮融资，计划进行下一轮融资。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '1527899934', '1528339694');
INSERT INTO `ey_article_content` VALUES ('46', '72', '&lt;p&gt;除了做基础技术的研究外，腾讯曾表示要通过业务驱动来推动各种应用场景的人工智能化。&lt;/p&gt;&lt;p&gt;结合腾讯的主营业务，也不难猜到未来公司要在游戏、社交、内容和平台工具型四大应用方向发力。&lt;/p&gt;&lt;p&gt;尤其是在社交领域，去年扎克伯格曾表示要推出VR版的Facebook，并展示了虚拟人物形象工具Oculus Avatars；今年7月，Facebook表示Facebook AR工作室将与美图合作，向其提供三款AR相机特效。如今，腾讯也要有所行动了。&lt;/p&gt;&lt;p&gt;7月18日晚间，人工智能初创公司ObEN宣布获得500万美元战略投资。该轮融资由腾讯领投，CMC董事长黎瑞刚及峰尚资本跟投。投融资信息平台crunchbase的数据显示，目前ObEN共完成四轮融资，总金额达到1370万美元。此前的投资人还包括S如山资本、软银韩国风险投资公司和HTC VIVE X等。&lt;/p&gt;&lt;p&gt;公开资料介绍，ObEN创办于2014年，可以通过构建个性化的虚拟声音、形象和个性来创造用户的人工智能虚拟形象，并帮助用户在新兴的数字世界中存储、管理、运营他们的虚拟形象。也就是说，ObEN可以利用人工智能工具，根据用户的照片和声音创建虚拟形象，从而让用户有不同的AR、VR社交体验。&lt;/p&gt;&lt;p&gt;以前ObEN主要帮助游戏玩家创建虚拟形象，如今公司将重点转向于帮助明星打造虚拟形象。通过该虚拟形象，明星可以与粉丝进行实时互动。未来某一天，也许粉丝还可以向明星寻求建议并得到相应的反馈。另外，这一虚拟形象不仅与明星长的非常像，而且说话的方式也是一样的。总的来说，这样一个虚拟形象总好过于一个聊天机器人。&lt;/p&gt;&lt;p&gt;据介绍，ObEN还首次融合了语音、计算视觉以及自然语言处理技术，研发了全栈式虚拟明星所需要的虚拟声音、三维形象及个性化技术。如今ObEN正在打造一个全新的商业平台。在这里，明星和粉丝可以通过个性化的人工智能在移动端、增强现实、虚拟现实以及智能设备、物联网等平台上直接互动。ObEN的个性化的人工智能产品预计将在今年晚些时候发布。&lt;/p&gt;&lt;p&gt;而最新一轮融资，将被用于加速ObEN的产品开发，并帮助推动其明星人工智能版权平台广泛应用到各类数字平台上。对于这次合作，腾讯投资的执行董事姚磊文说道，ObEN将带来由明星人工智能驱动的全新娱乐方式和内容。&lt;/p&gt;&lt;p&gt;早前，ObEN就曾表示要做“每个人的人工智能社交平台”。在这方面，公司已经先后进行过多次布局。&lt;/p&gt;&lt;p&gt;在今年3月的HTC Vive生态圈大会上，ObEN宣布与HTC Vive合作，开发了一个让用户一起VR游玩、VR“K歌”的微信小程序。在这一程序中，VR用户可以向好友发送邀请；接到邀请的好友可以上传自拍和音频，最终使用建成的形象与邀请者一起漫步海滩，或者参观景点。&lt;/p&gt;&lt;p&gt;随后的4月底，ObEN推出了一个整合有VR社交体验的微信聊天服务短片，当然用户需要戴上HTC Vive头显。在短片中，用户需要先拍一张自拍，上传到微信制作虚拟形象，然后带上HTC Vive，就可以接收微信好友发来的信息，并可以用语音直接进行回复。未来，拥有VR、AR功能的微信或许又可以收割大量亚洲用户。&lt;/p&gt;&lt;p&gt;&lt;img alt=&quot;&quot; src=&quot;/public/upload/remote/2018/06/02/5b11e74a4065b.png&quot;/&gt;&lt;/p&gt;&lt;p&gt;6月底，ObEN又宣布与韩国SM娱乐成立合资公司幻星有限公司（AI Stars）。据悉，ObEN要利用人工智能技术为SM娱乐旗下的知名艺人制作AI虚拟形象，而幻星有限公司正是管理这些”AI明星“的经纪公司。&lt;/p&gt;&lt;p&gt;这次腾讯领投ObEN，是否可以进一步推动公司社交业务的人工智能化。如今，各大公司不仅在忙于建立人工智能实验室，而且像Facebook这样的公司已经成立了更具象的Facebook AR实验室。另外，据说苹果很快就会推出ARKit平台。未来，腾讯是否还会成立单独的AR实验室，进一步布局社交AI业务？&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '1527899964', '1528339704');
INSERT INTO `ey_article_content` VALUES ('47', '73', '&lt;p&gt;36氪获悉，无人便利店“便利家”已获得数百万人民币天使轮投资，资方为联创永宣冯涛。&lt;/p&gt;&lt;p&gt;无人便利店风口正当时，缤果盒子、F5未来商店、深兰科技、Easy Go等一众玩家云集，亚马逊、罗森、阿里巴巴、沃尔玛等巨头亦纷纷试水。&amp;nbsp;&lt;/p&gt;&lt;p&gt;“便利家”创立于2017年3月，位于上海。便利家有微型无人便利店和中型无人便利店两款产品，和一众玩家相比，便利家的差异化在于：灵活。&amp;nbsp;&lt;/p&gt;&lt;p&gt;便利家的“微型无人便利店”，最小单位占地面积不到1平方米（0.68平方米），投放地点更加灵活，包括地铁站、写字楼、高校等，一个最小单位便利店的成本约为1.3万元（批量化生产后可能更低）。最小单位的无人便利店，可以根据人流量的分布，“拼”起来更大单位面积的便利店。低于100人，可放置一个；100人左右，可以拼两个；大于500人，可以拼四个。便利家的“中型无人便利店”，是由6个微型便利店拼起来的，同时在空间里增设桌椅，为消费者提供休憩区间，可放置在地理位置相对开阔的小区、公园等。&lt;/p&gt;&lt;p&gt;&lt;img alt=&quot;&quot; src=&quot;/public/upload/remote/2018/06/02/5b11e763b8800.png&quot;/&gt;&lt;/p&gt;&lt;p&gt;技术上，便利家在每一层货架中设置了RFID，并在各个角落缝隙做了密封屏蔽，让识别率更高。流程很简单，用支付宝扫码开门，拿完即走，支付宝自动扣款（微信正在洽谈中）。未来，便利家希望在门把手上做掌纹识别，当消费者进行“拉开门”这个动作的时候，就能够进行识别。&lt;/p&gt;&lt;p&gt;概念上，便利家其实更接近于售货机，创始人范韶伟认为，便利家是对传统售货机的一个改进。一方面，传统售货机的经营品类大多以饮料和固定包装零食为主，而便利家将以符合健康趋势的“鲜食类”为主；另一方面，传统售货机的出货流程是先付款、再出货，管道的陈列方式使得空间利用率低，如果是鲜食类商品，还有可能在掉下来的过程中发生变形。而便利家为先拿货、再扣款，可以叠放、密集排列，使得空间利用率更高。“同等面积下，我们的放货率比传统售货机多一倍。”&lt;/p&gt;&lt;p&gt;&lt;img alt=&quot;&quot; src=&quot;/public/upload/remote/2018/06/02/5b11e763bb491.png&quot;/&gt;&lt;/p&gt;&lt;p&gt;便利家的选品逻辑是，根据不同的场地，选择不同的商品，比如在写字楼满足白领的早午餐需求，提供便当、三明治、沙拉等等；在高校提供零食、卤味、面包等等。比照全家的平均客单价（14元），便利家将平均客单价设定在10元左右。此外，通过小程序，消费者可以反馈自己想吃的食物，根据数据反向指导品类的选择。&lt;/p&gt;&lt;p&gt;微型、中型便利店之外，便利家还有第三个方面的业务——对于传统夫妻店的改造。线下夫妻店的特点在于大小不一、面积不一，便利家提供的无人便利店改造方案，一是夫妻店共享场地资源，进行销售分成；二是加盟方式，收益比例更高。一方面，小店店主不需要一天十几个小时守着门店，另一方面，在无人售卖之外，还可以延展其它的生意获得更多利润，比如奶茶、咖啡等。&lt;/p&gt;&lt;p&gt;“不管是无人零售还是有人零售，本质上还是零售的生意。”范韶伟说。既然是零售的生意，在网点的布局上，需要站在全局的角度，“最怕东一榔头、西一棒子。”&lt;/p&gt;&lt;p&gt;点、线、面的合理布局，才能最大程度的降低运营成本和物流成本。这其中需要考虑两个重要因素：人流量以及铺设点位的协同。便利家的思路是，在人流量密集的地方布一个中型无人便利店，再在周围100米的范围内，去布局10个微型无人便利店，形成“最小补货单元”， 1个人可以负责20台设备的补货。&lt;/p&gt;&lt;p&gt;至于RFID贴标签的成本问题，范韶伟持有乐观的态度，目前标签成本在0.5-0.6元，但随着RFID在零售市场的普及，RFID标签的价格一定会降低。&lt;/p&gt;&lt;p&gt;本轮融资后，便利家将在上海建立试运营点，中型+微型无人便利店，预期铺设20个网点。目前，便利家正在寻求Pre-A轮融资，用于扩大量产和投放运营。&lt;/p&gt;&lt;p&gt;团队方面，CEO范韶伟毕业于哈尔滨工业大学，曾任商派软件渠道部北部大区经理，是一位连续创业者。COO吴威为上海交通大学硕士，在快消品领域连续创业；CTO彭庚庚毕业于上海大学计算机工程专业，曾任腾讯OMG事业群广告平台部高级工程师。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '1527899992', '1528339680');
INSERT INTO `ey_article_content` VALUES ('48', '74', '&lt;p&gt;&lt;img alt=&quot;旅游市场将迎来内容红利？河马旅居想做旅游界的“小红书”&quot; src=&quot;/public/upload/remote/2018/06/02/5b11e78b80cef.png&quot;/&gt;&lt;/p&gt;&lt;p&gt;“内容为王”这句话在哪个时代都不会过时。随着消费升级，日益庞大的中国高端群体对高品质的生活方式与旅行体验的需求为高端出境旅游市场带来巨大市场机遇。现今的旅游产品也更向个性化、定制化、品质化靠拢，对内容创新提出更高的要求。内地的旅游内容市场仍有5-10倍的增长空间。最近36氪接触了一家做移动端旅游社区电商的团队——河马旅居指南。&lt;/p&gt;&lt;p&gt;河马旅居定位中等收入人群18-34岁的年轻群体，想通过碎片化的PGC或UGC内容培养用户粘性，由内容社区模式切入出境游市场。传统的旅游内容多是以长图文的游记形式呈现，河马旅居并不刻意强调旅游路线或整个游历过程的感受，在内容呈现上更加碎片化、个性化、移动化以及品质化，以小众或特色地点作为维度输出内容，建立内容社区，类似于旅游界的“小红书”或“什么值得买”。&lt;/p&gt;&lt;p&gt;河马旅居在部分海外旅游城市有一个4到5人的自媒体小团队定期生产PGC内容，每月更新一次内容，以优质的内容导流。目前河马的获客成本低至2-3元/人。&lt;/p&gt;&lt;p&gt;优质的内容利于培养高粘性度的用户，当累计到一定数量的优质内容生产者，达到一定的用户规模时，将由PGC内容带动UGC内容的自发产出，进而开始搭建旅游内容社区，最后完成向旅游社区电商的转型，形成交易闭环。&lt;/p&gt;&lt;p&gt;目前河马旅居的流量较为分散，微信公众号累计粉丝3万，MONO 5万，豆瓣 1万，C端获客主要来自微博、豆瓣，上周刚上线微信小程序。后期需考虑转化用户集中流量，现阶段团队正尝试跟移动WiFi租赁和签证业务团队资源置换，互相增加入口。&lt;/p&gt;&lt;p&gt;商业模式上，河马旅居打算分两步走，第一阶段，先帮助用户解决去哪里玩的问题。河马打算与当地的旅游局或航空公司合作，帮助他们做中国市场的整体营销，宣传当地旅游资源。第二阶段，解决用户怎么玩的问题。平台可通过用户的行为数据分析社区调性从而推荐相应的特色化旅游产品，例如在京都的寺院坐禅、学习茶道、参观日本酒的蒸馏厂等等。&lt;/p&gt;&lt;p&gt;此外，河马旅居也在尝试开拓知识付费的营收渠道。从体验、艺术、咖啡、酒吧、餐厅、酒店等六个维度切入，做成各旅游城市的PDF版官方性质PGC攻略。3月份售出800多本，每本单价15元。&lt;/p&gt;&lt;p&gt;河马旅居创始人余晓盼表示，河马旅居的核心竞争力还是个性化的内容表达。“传统旅游社区把内容做的太死气沉沉了。人美、景美但流水账似的内容很无趣。好的内容本身就是门槛。原创的有趣的才有生命力。”&lt;/p&gt;&lt;p&gt;内容+电商并不是一个新概念，如今传统OTA、头部电商平台以及媒体型电商都在加码内容，但要持续产出有价值的内容并非易事，需要足够规模的内容生产团队长时间的内容积累，而具有极强传播力的爆款内容更是可遇而不可求，营造内容社区所花费的精力也许正是其门槛所在。&lt;/p&gt;&lt;p&gt;河马旅居目前的管理团队为4人，内容产出团队20人。创始人余晓盼任河马主编兼运营，曾任职于私募、资管、律师事务所，为《美食侦探系列》旅行畅销书作者。团队目前正在寻求天使轮融资。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '1527900027', '1528339662');
INSERT INTO `ey_article_content` VALUES ('62', '90', '&lt;p style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;/public/upload/article/2018/06/06/0427cc4753c9cd874251345debe9f93f.jpg&quot; title=&quot;0427cc4753c9cd874251345debe9f93f.jpg&quot; alt=&quot;0427cc4753c9cd874251345debe9f93f.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;核心价值观：诚信、创新、服务 企业核心： 诚信 企业精神： 团结拼搏、开拓求实、满足用户、科技进步。 客户：为客户提供高质量和最大价值的专业化产品和服务，以真诚和实力赢...&lt;/p&gt;', '1528296618', '1528450777');
INSERT INTO `ey_article_content` VALUES ('63', '91', '&lt;p style=&quot;text-align: center;&quot;&gt;&lt;img src=&quot;/public/upload/article/2018/06/06/264309f9749ce0e71f31415ca4f591d8.jpg&quot; title=&quot;264309f9749ce0e71f31415ca4f591d8.jpg&quot; alt=&quot;264309f9749ce0e71f31415ca4f591d8.jpg&quot;/&gt;&lt;/p&gt;&lt;p&gt;核心价值观：诚信、创新、服务 企业核心： 诚信 企业精神： 团结拼搏、开拓求实、满足用户、科技进步。 客户：为客户提供高质量和最大价值的专业化产品和服务，以真诚和实力赢...&lt;/p&gt;', '1528296656', '1528450790');

-- -----------------------------
-- Table structure for `ey_auth_role`
-- -----------------------------
DROP TABLE IF EXISTS `ey_auth_role`;
CREATE TABLE `ey_auth_role` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT '' COMMENT '角色名',
  `pid` int(10) DEFAULT '0' COMMENT '父角色ID',
  `remark` text COMMENT '备注信息',
  `grade` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT '级别',
  `language` text COMMENT '多语言权限',
  `online_update` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '在线升级',
  `only_oneself` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '只看自己发布',
  `cud` varchar(255) DEFAULT '' COMMENT '增改删',
  `permission` text COMMENT '已允许的权限',
  `built_in` tinyint(1) DEFAULT '0' COMMENT '内置用户组，1表示内置',
  `sort_order` int(10) DEFAULT '0' COMMENT '排序号',
  `status` tinyint(1) DEFAULT '1' COMMENT '状态(1=正常，0=屏蔽)',
  `admin_id` int(10) DEFAULT '0' COMMENT '操作管理员ID',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COMMENT='管理员角色表';

-- -----------------------------
-- Records of `ey_auth_role`
-- -----------------------------
INSERT INTO `ey_auth_role` VALUES ('1', '优化推广员', '0', '', '0', 'a:1:{i:0;s:2:\"cn\";}', '0', '1', 'a:3:{i:0;s:3:\"add\";i:1;s:4:\"edit\";i:2;s:3:\"del\";}', 'a:2:{s:5:\"rules\";a:8:{i:0;s:1:\"1\";i:1;s:1:\"3\";i:2;s:1:\"4\";i:3;s:1:\"8\";i:4;s:1:\"9\";i:5;s:2:\"10\";i:6;s:2:\"14\";i:7;i:2;}s:7:\"arctype\";a:40:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";i:4;s:1:\"5\";i:5;s:1:\"6\";i:6;s:2:\"33\";i:7;s:2:\"34\";i:8;s:2:\"35\";i:9;s:2:\"36\";i:10;s:2:\"37\";i:11;s:2:\"38\";i:12;s:2:\"39\";i:13;s:2:\"40\";i:14;s:2:\"41\";i:15;s:2:\"42\";i:16;s:2:\"43\";i:17;s:2:\"44\";i:18;s:2:\"45\";i:19;s:2:\"46\";i:20;s:2:\"47\";i:21;s:2:\"48\";i:22;s:1:\"8\";i:23;s:2:\"32\";i:24;s:1:\"9\";i:25;s:2:\"30\";i:26;s:2:\"31\";i:27;s:2:\"11\";i:28;s:2:\"12\";i:29;s:2:\"13\";i:30;s:2:\"23\";i:31;s:2:\"20\";i:32;s:2:\"24\";i:33;s:2:\"25\";i:34;s:2:\"21\";i:35;s:2:\"26\";i:36;s:2:\"22\";i:37;s:2:\"27\";i:38;s:2:\"28\";i:39;s:2:\"29\";}}', '1', '100', '1', '0', '1541207843', '0');
INSERT INTO `ey_auth_role` VALUES ('2', '内容管理员', '0', '', '0', 'a:1:{i:0;s:2:\"cn\";}', '0', '1', 'a:3:{i:0;s:3:\"add\";i:1;s:4:\"edit\";i:2;s:3:\"del\";}', 'a:2:{s:5:\"rules\";a:4:{i:0;s:1:\"1\";i:1;s:2:\"10\";i:2;s:2:\"14\";i:3;i:2;}s:7:\"arctype\";a:40:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";i:4;s:1:\"5\";i:5;s:1:\"6\";i:6;s:2:\"33\";i:7;s:2:\"34\";i:8;s:2:\"35\";i:9;s:2:\"36\";i:10;s:2:\"37\";i:11;s:2:\"38\";i:12;s:2:\"39\";i:13;s:2:\"40\";i:14;s:2:\"41\";i:15;s:2:\"42\";i:16;s:2:\"43\";i:17;s:2:\"44\";i:18;s:2:\"45\";i:19;s:2:\"46\";i:20;s:2:\"47\";i:21;s:2:\"48\";i:22;s:1:\"8\";i:23;s:2:\"32\";i:24;s:1:\"9\";i:25;s:2:\"30\";i:26;s:2:\"31\";i:27;s:2:\"11\";i:28;s:2:\"12\";i:29;s:2:\"13\";i:30;s:2:\"23\";i:31;s:2:\"20\";i:32;s:2:\"24\";i:33;s:2:\"25\";i:34;s:2:\"21\";i:35;s:2:\"26\";i:36;s:2:\"22\";i:37;s:2:\"27\";i:38;s:2:\"28\";i:39;s:2:\"29\";}}', '1', '100', '1', '0', '1541207846', '0');

-- -----------------------------
-- Table structure for `ey_channelfield`
-- -----------------------------
DROP TABLE IF EXISTS `ey_channelfield`;
CREATE TABLE `ey_channelfield` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `name` varchar(32) NOT NULL DEFAULT '' COMMENT '字段名称',
  `channel_id` int(10) NOT NULL DEFAULT '0' COMMENT '所属文档模型id',
  `title` varchar(32) NOT NULL DEFAULT '' COMMENT '字段标题',
  `dtype` varchar(32) NOT NULL DEFAULT '' COMMENT '字段类型',
  `define` varchar(128) NOT NULL DEFAULT '' COMMENT '字段定义',
  `maxlength` int(10) NOT NULL DEFAULT '0' COMMENT '最大长度，文本数据必须填写，大于255为text类型',
  `dfvalue` varchar(1000) NOT NULL DEFAULT '' COMMENT '默认值',
  `dfvalue_unit` varchar(50) NOT NULL DEFAULT '' COMMENT '数值单位',
  `remark` varchar(256) NOT NULL DEFAULT '' COMMENT '提示说明',
  `ifeditable` tinyint(1) NOT NULL DEFAULT '1' COMMENT '是否在编辑页显示',
  `ifrequire` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否必填',
  `ifsystem` tinyint(1) NOT NULL DEFAULT '0' COMMENT '字段分类，1=系统(不可修改)，0=自定义',
  `ifmain` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否主表字段',
  `sort_order` int(5) NOT NULL DEFAULT '100' COMMENT '排序',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '状态',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`,`channel_id`)
) ENGINE=MyISAM AUTO_INCREMENT=52 DEFAULT CHARSET=utf8 COMMENT='自定义字段表';

-- -----------------------------
-- Records of `ey_channelfield`
-- -----------------------------
INSERT INTO `ey_channelfield` VALUES ('1', 'add_time', '0', '新增时间', 'datetime', 'int(11)', '250', '', '', '', '1', '0', '1', '1', '100', '1', '1533091575', '1533091575');
INSERT INTO `ey_channelfield` VALUES ('2', 'update_time', '0', '更新时间', 'datetime', 'int(11)', '250', '', '', '', '1', '0', '1', '1', '100', '1', '1533091601', '1533091601');
INSERT INTO `ey_channelfield` VALUES ('3', 'aid', '0', '文档ID', 'int', 'int(11)', '250', '', '', '', '1', '0', '1', '1', '100', '1', '1533091624', '1533091624');
INSERT INTO `ey_channelfield` VALUES ('4', 'typeid', '0', '当前栏目ID', 'int', 'int(11)', '250', '', '', '', '1', '0', '1', '1', '100', '1', '1533091930', '1533091930');
INSERT INTO `ey_channelfield` VALUES ('5', 'channel', '0', '模型ID', 'int', 'int(11)', '250', '', '', '', '1', '0', '1', '1', '100', '1', '1533092214', '1533092214');
INSERT INTO `ey_channelfield` VALUES ('6', 'is_b', '0', '是否加粗', 'switch', 'tinyint(1)', '250', '', '', '', '1', '0', '1', '1', '100', '1', '1533092246', '1533092246');
INSERT INTO `ey_channelfield` VALUES ('7', 'title', '0', '文档标题', 'text', 'varchar(250)', '250', '', '', '', '1', '0', '1', '1', '100', '1', '1533092381', '1533092381');
INSERT INTO `ey_channelfield` VALUES ('8', 'litpic', '0', '封面图', 'img', 'varchar(250)', '250', '', '', '', '1', '0', '1', '1', '100', '1', '1533092398', '1533092398');
INSERT INTO `ey_channelfield` VALUES ('9', 'is_head', '0', '是否头条', 'switch', 'tinyint(1)', '250', '', '', '', '1', '0', '1', '1', '100', '1', '1533092420', '1533092420');
INSERT INTO `ey_channelfield` VALUES ('10', 'is_special', '0', '是否特荐', 'switch', 'tinyint(1)', '250', '', '', '', '1', '0', '1', '1', '100', '1', '1533092439', '1533092439');
INSERT INTO `ey_channelfield` VALUES ('11', 'is_top', '0', '是否置顶', 'switch', 'tinyint(1)', '250', '', '', '', '1', '0', '1', '1', '100', '1', '1533092454', '1533092454');
INSERT INTO `ey_channelfield` VALUES ('12', 'is_recom', '0', '是否推荐', 'switch', 'tinyint(1)', '250', '', '', '', '1', '0', '1', '1', '100', '1', '1533092468', '1533092468');
INSERT INTO `ey_channelfield` VALUES ('13', 'is_jump', '0', '是否跳转', 'switch', 'tinyint(1)', '250', '', '', '', '1', '0', '1', '1', '100', '1', '1533092484', '1533092484');
INSERT INTO `ey_channelfield` VALUES ('14', 'author', '0', '编辑者', 'text', 'varchar(250)', '250', '', '', '', '1', '0', '1', '1', '100', '1', '1533092498', '1533092498');
INSERT INTO `ey_channelfield` VALUES ('15', 'click', '0', '浏览量', 'int', 'int(11)', '250', '', '', '', '1', '0', '1', '1', '100', '1', '1533092512', '1533092512');
INSERT INTO `ey_channelfield` VALUES ('16', 'arcrank', '0', '阅读权限', 'select', 'tinyint(1)', '250', '', '', '', '1', '0', '1', '1', '100', '1', '1533092534', '1533092534');
INSERT INTO `ey_channelfield` VALUES ('17', 'jumplinks', '0', '跳转链接', 'text', 'varchar(250)', '250', '', '', '', '1', '0', '1', '1', '100', '1', '1533092553', '1533092553');
INSERT INTO `ey_channelfield` VALUES ('18', 'ismake', '0', '是否静态页面', 'switch', 'tinyint(1)', '250', '', '', '', '1', '0', '1', '1', '100', '1', '1533092698', '1533092698');
INSERT INTO `ey_channelfield` VALUES ('19', 'seo_title', '0', 'SEO标题', 'text', 'varchar(250)', '250', '', '', '', '1', '0', '1', '1', '100', '1', '1533092713', '1533092713');
INSERT INTO `ey_channelfield` VALUES ('20', 'seo_keywords', '0', 'SEO关键词', 'text', 'varchar(250)', '250', '', '', '', '1', '0', '1', '1', '100', '1', '1533092725', '1533092725');
INSERT INTO `ey_channelfield` VALUES ('21', 'seo_description', '0', 'SEO描述', 'text', 'varchar(250)', '250', '', '', '', '1', '0', '1', '1', '100', '1', '1533092739', '1533092739');
INSERT INTO `ey_channelfield` VALUES ('22', 'status', '0', '状态', 'switch', 'tinyint(1)', '250', '', '', '', '1', '0', '1', '1', '100', '1', '1533092753', '1533092753');
INSERT INTO `ey_channelfield` VALUES ('23', 'sort_order', '0', '排序号', 'int', 'int(11)', '250', '', '', '', '1', '0', '1', '1', '100', '1', '1533092766', '1533092766');
INSERT INTO `ey_channelfield` VALUES ('24', 'content', '2', '内容', 'htmltext', 'longtext', '250', '', '', '', '1', '0', '1', '0', '100', '1', '1533359739', '1533359739');
INSERT INTO `ey_channelfield` VALUES ('25', 'content', '3', '内容详情', 'htmltext', 'longtext', '250', '', '', '', '1', '0', '1', '0', '100', '1', '1533359588', '1533359588');
INSERT INTO `ey_channelfield` VALUES ('26', 'content', '4', '内容详情', 'htmltext', 'longtext', '250', '', '', '', '1', '0', '1', '0', '100', '1', '1533359752', '1533359752');
INSERT INTO `ey_channelfield` VALUES ('27', 'content', '6', '内容详情', 'htmltext', 'longtext', '250', '', '', '', '1', '0', '1', '0', '100', '1', '1533464715', '1533464715');
INSERT INTO `ey_channelfield` VALUES ('29', 'content', '1', '内容详情', 'htmltext', 'longtext', '250', '', '', '', '1', '0', '1', '0', '100', '1', '1533464713', '1533464713');
INSERT INTO `ey_channelfield` VALUES ('30', 'update_time', '-99', '更新时间', 'datetime', 'int(11)', '11', '0', '', '', '1', '0', '1', '1', '100', '1', '1533524780', '1533524780');
INSERT INTO `ey_channelfield` VALUES ('31', 'add_time', '-99', '新增时间', 'datetime', 'int(11)', '11', '0', '', '', '1', '0', '1', '1', '100', '1', '1533524780', '1533524780');
INSERT INTO `ey_channelfield` VALUES ('32', 'status', '-99', '启用 (1=正常，0=屏蔽)', 'switch', 'tinyint(1)', '1', '1', '', '', '1', '0', '1', '1', '100', '1', '1533524780', '1533524780');
INSERT INTO `ey_channelfield` VALUES ('33', 'is_part', '-99', '栏目属性：0=内容栏目，1=外部链接', 'switch', 'tinyint(1)', '1', '0', '', '', '1', '0', '1', '1', '100', '1', '1533524780', '1533524780');
INSERT INTO `ey_channelfield` VALUES ('34', 'is_hidden', '-99', '是否隐藏栏目：0=显示，1=隐藏', 'switch', 'tinyint(1)', '1', '0', '', '', '1', '0', '1', '1', '100', '1', '1533524780', '1533524780');
INSERT INTO `ey_channelfield` VALUES ('35', 'sort_order', '-99', '排序号', 'int', 'int(10)', '10', '0', '', '', '1', '0', '1', '1', '100', '1', '1533524780', '1533524780');
INSERT INTO `ey_channelfield` VALUES ('36', 'seo_description', '-99', 'seo描述', 'multitext', 'text', '0', '', '', '', '1', '0', '1', '1', '100', '1', '1533524780', '1533524780');
INSERT INTO `ey_channelfield` VALUES ('37', 'seo_keywords', '-99', 'seo关键字', 'text', 'varchar(200)', '200', '', '', '', '1', '0', '1', '1', '100', '1', '1533524780', '1533524780');
INSERT INTO `ey_channelfield` VALUES ('38', 'seo_title', '-99', 'SEO标题', 'text', 'varchar(200)', '200', '', '', '', '1', '0', '1', '1', '100', '1', '1533524780', '1533524780');
INSERT INTO `ey_channelfield` VALUES ('39', 'tempview', '-99', '文档模板文件名', 'text', 'varchar(200)', '200', '', '', '', '1', '0', '1', '1', '100', '1', '1533524780', '1533524780');
INSERT INTO `ey_channelfield` VALUES ('40', 'templist', '-99', '列表模板文件名', 'text', 'varchar(200)', '200', '', '', '', '1', '0', '1', '1', '100', '1', '1533524780', '1533524780');
INSERT INTO `ey_channelfield` VALUES ('41', 'litpic', '-99', '栏目图片', 'img', 'varchar(250)', '250', '', '', '', '1', '0', '1', '1', '100', '1', '1533524780', '1533524780');
INSERT INTO `ey_channelfield` VALUES ('42', 'typelink', '-99', '栏目链接', 'text', 'varchar(200)', '200', '', '', '', '1', '0', '1', '1', '100', '1', '1533524780', '1533524780');
INSERT INTO `ey_channelfield` VALUES ('43', 'grade', '-99', '栏目等级', 'switch', 'tinyint(1)', '1', '0', '', '', '1', '0', '1', '1', '100', '1', '1533524780', '1533524780');
INSERT INTO `ey_channelfield` VALUES ('44', 'englist_name', '-99', '栏目英文名', 'text', 'varchar(200)', '200', '', '', '', '1', '0', '1', '1', '100', '1', '1533524780', '1533524780');
INSERT INTO `ey_channelfield` VALUES ('45', 'dirpath', '-99', '目录存放HTML路径', 'text', 'varchar(200)', '200', '', '', '', '1', '0', '1', '1', '100', '1', '1533524780', '1533524780');
INSERT INTO `ey_channelfield` VALUES ('46', 'dirname', '-99', '目录英文名', 'text', 'varchar(200)', '200', '', '', '', '1', '0', '1', '1', '100', '1', '1533524780', '1533524780');
INSERT INTO `ey_channelfield` VALUES ('47', 'typename', '-99', '栏目名称', 'text', 'varchar(200)', '200', '', '', '', '1', '0', '1', '1', '100', '1', '1533524780', '1533524780');
INSERT INTO `ey_channelfield` VALUES ('48', 'parent_id', '-99', '栏目上级ID', 'int', 'int(10)', '10', '0', '', '', '1', '0', '1', '1', '100', '1', '1533524780', '1533524780');
INSERT INTO `ey_channelfield` VALUES ('49', 'current_channel', '-99', '栏目当前模型ID', 'int', 'int(10)', '10', '0', '', '', '1', '0', '1', '1', '100', '1', '1533524780', '1533524780');
INSERT INTO `ey_channelfield` VALUES ('50', 'channeltype', '-99', '栏目顶级模型ID', 'int', 'int(10)', '10', '0', '', '', '1', '0', '1', '1', '100', '1', '1533524780', '1533524780');
INSERT INTO `ey_channelfield` VALUES ('51', 'id', '-99', '栏目ID', 'int', 'int(10)', '10', '', '', '', '1', '0', '1', '1', '100', '1', '1533524780', '1533524780');

-- -----------------------------
-- Table structure for `ey_channeltype`
-- -----------------------------
DROP TABLE IF EXISTS `ey_channeltype`;
CREATE TABLE `ey_channeltype` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nid` varchar(50) NOT NULL DEFAULT '' COMMENT '识别id',
  `title` varchar(30) DEFAULT '' COMMENT '名称',
  `ntitle` varchar(30) DEFAULT '' COMMENT '左侧菜单名称',
  `table` varchar(50) DEFAULT '' COMMENT '表名',
  `ctl_name` varchar(50) DEFAULT '' COMMENT '控制器名称（区分大小写）',
  `status` tinyint(1) DEFAULT '1' COMMENT '状态(1=启用，0=屏蔽)',
  `sort_order` smallint(6) DEFAULT '50' COMMENT '排序',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idention` (`nid`) USING BTREE,
  UNIQUE KEY `ctl_name` (`ctl_name`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;

-- -----------------------------
-- Records of `ey_channeltype`
-- -----------------------------
INSERT INTO `ey_channeltype` VALUES ('1', 'article', '文章模型', '文章', 'article', 'Article', '1', '1', '0', '1547626351');
INSERT INTO `ey_channeltype` VALUES ('4', 'download', '下载模型', '下载', 'download', 'Download', '0', '4', '0', '1547626351');
INSERT INTO `ey_channeltype` VALUES ('2', 'product', '产品模型', '产品', 'product', 'Product', '0', '2', '0', '1547626351');
INSERT INTO `ey_channeltype` VALUES ('8', 'guestbook', '留言模型', '留言', 'guestbook', 'Guestbook', '1', '8', '1509197711', '1547626351');
INSERT INTO `ey_channeltype` VALUES ('6', 'single', '单页模型', '单页', 'single', 'Single', '1', '6', '1523091961', '1547626351');
INSERT INTO `ey_channeltype` VALUES ('3', 'images', '图集模型', '图集', 'images', 'Images', '0', '3', '1523929121', '1547626351');

-- -----------------------------
-- Table structure for `ey_config`
-- -----------------------------
DROP TABLE IF EXISTS `ey_config`;
CREATE TABLE `ey_config` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `name` varchar(50) DEFAULT '' COMMENT '配置的key键名',
  `value` text,
  `inc_type` varchar(64) DEFAULT '' COMMENT '配置分组',
  `desc` varchar(50) DEFAULT '' COMMENT '描述',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `is_del` tinyint(1) DEFAULT '0' COMMENT '是否已删除，0=否，1=是',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=483 DEFAULT CHARSET=utf8;

-- -----------------------------
-- Records of `ey_config`
-- -----------------------------
INSERT INTO `ey_config` VALUES ('16', 'is_mark', '0', 'water', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('17', 'mark_txt', '易优Cms', 'water', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('18', 'mark_img', '/public/upload/water/2018/05/08/93806077e5a4c4e12ceed30df5cde761.png', 'water', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('19', 'mark_width', '200', 'water', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('20', 'mark_height', '50', 'water', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('21', 'mark_degree', '54', 'water', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('22', 'mark_quality', '56', 'water', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('23', 'mark_sel', '9', 'water', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('28', 'sms_time_out', '120', 'sms', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('183', 'theme_style', '1', 'basic', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('184', 'file_size', '500', 'basic', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('185', 'image_type', 'jpg|gif|png|bmp|jpeg|ico', 'basic', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('186', 'file_type', 'zip|gz|rar|iso|doc|xsl|ppt|wps', 'basic', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('187', 'media_type', 'swf|mpg|mp3|rm|rmvb|wmv|wma|wav|mid|mov|mp4', 'basic', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('188', 'web_keywords', '', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('451', 'web_status_pc', '0', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('346', 'sms_platform', '1', 'sms', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('351', 'seo_viewtitle_format', '2', 'seo', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('60', 'smtp_server', 'smtp.qq.com', 'smtp', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('61', 'smtp_port', '465', 'smtp', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('62', 'smtp_user', 'xxxxxxxxx@qq.com', 'smtp', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('63', 'smtp_pwd', 'xxxxxxxxxxx', 'smtp', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('92', 'inc_type', 'smtp', 'smtp', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('101', 'mark_type', 'img', 'water', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('102', 'mark_txt_size', '30', 'water', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('103', 'mark_txt_color', '#000000', 'water', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('340', 'oss_switch', '0', 'oss', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('167', 'web_basehost', 'http://127.0.0.22', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('169', 'web_description', '', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('473', 'web_recordnum', '粤IP**********', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('171', 'web_thirdcode_pc', '', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('172', 'web_thirdcode_wap', '', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('178', 'web_address', '海南省海口市', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('319', 'seo_arcdir', '/html', 'seo', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('320', 'seo_pseudo', '1', 'seo', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('321', 'list_symbol', '&gt;', 'basic', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('332', 'sitemap_auto', '1', 'sitemap', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('333', 'sitemap_not1', '0', 'sitemap', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('334', 'sitemap_not2', '1', 'sitemap', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('335', 'sitemap_xml', '1', 'sitemap', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('336', 'sitemap_txt', '0', 'sitemap', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('337', 'sitemap_zzbaidutoken', '', 'sitemap', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('338', 'seo_expires_in', '7200', 'seo', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('292', 'web_logo', '/public/upload/system/2018/06/09/dcc561678a0e7b65fc90f2cd5803db5a.png', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('293', 'web_ico', '/favicon.ico', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('297', 'web_copyright', 'Copyright © 2002-2017 某某公司 版权所有', 'web', '', 'cn', '0', '1545639075');
INSERT INTO `ey_config` VALUES ('244', 'web_name', '医疗器械企业网站模板', 'web', '', 'cn', '0', '1547626373');
INSERT INTO `ey_config` VALUES ('307', 'web_title', '医疗器械企业网站模板', 'web', '', 'cn', '0', '1545639075');
INSERT INTO `ey_config` VALUES ('314', 'smtp_test_eamil', 'xxxxxxxx@qq.com', 'smtp', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('374', 'web_authortoken', '6e27af8a47788c33317c98fd9b0d8e03', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('368', 'web_attr_3', '1234567890', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('367', 'web_attr_2', '400-123-4657', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('371', 'web_attr_4', '/public/upload/system/2018/06/09/1ce51aecf8cfd812605153ca3f0493fa.jpg', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('375', 'seo_inlet', '1', 'seo', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('380', 'web_cmspath', '', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('381', 'web_sqldatapath', '/data/sqldata', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('445', 'web_cmsurl', '', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('446', 'web_templets_dir', '/template', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('447', 'web_templeturl', '/template', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('448', 'web_templets_pc', '/template/pc', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('449', 'web_templets_m', '/template/mobile', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('450', 'web_eyoucms', 'http://www.eyoucms.com', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('452', 'web_status_m', '0', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('453', 'web_attr_48', '', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('454', 'web_attr_49', '', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('455', 'web_attr_50', '', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('456', 'web_attr_53', '', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('458', 'web_attr_55', 'admin@youweb.com', 'web', '', 'cn', '0', '1545639075');
INSERT INTO `ey_config` VALUES ('459', 'web_attr_56', '广东省广州市天河区88号', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('460', 'web_attr_57', '+86-123-4567', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('462', 'web_attr_59', '/public/upload/system/2018/06/09/d379507e3a763d2de0c34eaa21150cd2.png', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('463', 'web_attr_60', '13800000000', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('464', 'web_status', '0', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('465', 'web_attr_61', '张生', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('468', 'web_attr_64', '诚信为本，市场在变，诚信永远不变...', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('472', '_cmscopyright', 'jCmThjj2zbQJddE5nQL42eNp', 'php', '', 'cn', '0', '1545639080');
INSERT INTO `ey_config` VALUES ('474', 'web_is_authortoken', '-1', 'web', '', 'cn', '0', '1547626344');
INSERT INTO `ey_config` VALUES ('475', 'seo_rewrite_format', '2', 'seo', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('476', 'seo_dynamic_format', '1', 'seo', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('477', 'system_sql_mode', 'NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION', 'system', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('478', 'web_adminbasefile', '/login.php', 'web', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('479', 'seo_liststitle_format', '2', 'seo', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('480', 'system_home_default_lang', 'cn', 'system', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('481', 'system_langnum', '1', 'system', '', 'cn', '0', '0');
INSERT INTO `ey_config` VALUES ('482', 'system_version', 'v1.2.6', 'system', '', 'cn', '0', '1547626357');

-- -----------------------------
-- Table structure for `ey_config_attribute`
-- -----------------------------
DROP TABLE IF EXISTS `ey_config_attribute`;
CREATE TABLE `ey_config_attribute` (
  `attr_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '表单id',
  `inc_type` varchar(20) DEFAULT '' COMMENT '变量分组',
  `attr_name` varchar(60) DEFAULT '' COMMENT '变量标题',
  `attr_var_name` varchar(50) DEFAULT '' COMMENT '变量名',
  `attr_input_type` tinyint(1) unsigned DEFAULT '0' COMMENT ' 0=文本框，1=下拉框，2=多行文本框，3=上传图片',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`attr_id`)
) ENGINE=MyISAM AUTO_INCREMENT=68 DEFAULT CHARSET=utf8 COMMENT='留言表单属性';

-- -----------------------------
-- Records of `ey_config_attribute`
-- -----------------------------
INSERT INTO `ey_config_attribute` VALUES ('2', 'web', '固话', 'web_attr_2', '0', 'cn', '1525962600', '1527897967');
INSERT INTO `ey_config_attribute` VALUES ('3', 'web', 'QQ号码', 'web_attr_3', '0', 'cn', '1525962624', '1525962624');
INSERT INTO `ey_config_attribute` VALUES ('4', 'web', '微信二维码', 'web_attr_4', '3', 'cn', '1525999090', '1526008783');
INSERT INTO `ey_config_attribute` VALUES ('55', 'web', '电子邮箱', 'web_attr_55', '0', 'cn', '1527648863', '1527648863');
INSERT INTO `ey_config_attribute` VALUES ('56', 'web', '地址', 'web_attr_56', '0', 'cn', '1527648895', '1527648895');
INSERT INTO `ey_config_attribute` VALUES ('57', 'web', '传真', 'web_attr_57', '0', 'cn', '1527649404', '1527649404');
INSERT INTO `ey_config_attribute` VALUES ('59', 'web', '网站手机端Logo', 'web_attr_59', '3', 'cn', '1527667768', '1528509241');
INSERT INTO `ey_config_attribute` VALUES ('60', 'web', '手机', 'web_attr_60', '0', 'cn', '1527670161', '1527670161');
INSERT INTO `ey_config_attribute` VALUES ('61', 'web', '联系人', 'web_attr_61', '0', 'cn', '1527838414', '1527838414');
INSERT INTO `ey_config_attribute` VALUES ('64', 'web', '网站公告', 'web_attr_64', '0', 'cn', '1527890183', '1528182391');

-- -----------------------------
-- Table structure for `ey_download_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_download_content`;
CREATE TABLE `ey_download_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `content` longtext COMMENT '内容详情',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `news_id` (`aid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COMMENT='资讯内容表_存储正常内容';


-- -----------------------------
-- Table structure for `ey_download_file`
-- -----------------------------
DROP TABLE IF EXISTS `ey_download_file`;
CREATE TABLE `ey_download_file` (
  `file_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `aid` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '产品ID',
  `title` varchar(200) DEFAULT '' COMMENT '产品标题',
  `file_url` varchar(255) DEFAULT '' COMMENT '文件存储路径',
  `file_size` varchar(255) DEFAULT '' COMMENT '文件大小',
  `file_ext` varchar(50) DEFAULT '' COMMENT '文件后缀名',
  `file_name` varchar(200) DEFAULT '' COMMENT '文件名',
  `file_mime` varchar(200) DEFAULT '' COMMENT '文件类型',
  `uhash` varchar(200) DEFAULT '' COMMENT '自定义的一种加密方式，用于文件下载权限验证',
  `md5file` varchar(200) DEFAULT '' COMMENT 'md5_file加密，可以检测上传/下载的文件包是否损坏',
  `sort_order` smallint(5) DEFAULT '0' COMMENT '排序',
  `add_time` int(10) unsigned DEFAULT '0' COMMENT '上传时间',
  PRIMARY KEY (`file_id`),
  KEY `arcid` (`aid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;


-- -----------------------------
-- Table structure for `ey_field_type`
-- -----------------------------
DROP TABLE IF EXISTS `ey_field_type`;
CREATE TABLE `ey_field_type` (
  `name` varchar(32) NOT NULL DEFAULT '' COMMENT '字段类型',
  `title` varchar(64) NOT NULL DEFAULT '' COMMENT '中文类型名',
  `ifoption` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否需要设置选项',
  `sort_order` int(10) NOT NULL DEFAULT '0' COMMENT '排序',
  `add_time` int(11) NOT NULL DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`name`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='字段类型表';

-- -----------------------------
-- Records of `ey_field_type`
-- -----------------------------
INSERT INTO `ey_field_type` VALUES ('text', '单行文本', '0', '1', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('checkbox', '多选项', '1', '5', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('multitext', '多行文本', '0', '2', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('radio', '单选项', '1', '4', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('switch', '开关', '0', '13', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('select', '下拉框', '1', '6', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('img', '单张图', '0', '10', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('int', '整数类型', '0', '7', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('datetime', '日期和时间', '0', '12', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('htmltext', 'HTML文本', '0', '3', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('imgs', '多张图', '0', '11', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('decimal', '金额类型', '0', '9', '1532485708', '1532485708');
INSERT INTO `ey_field_type` VALUES ('float', '小数类型', '0', '8', '1532485708', '1532485708');

-- -----------------------------
-- Table structure for `ey_guestbook`
-- -----------------------------
DROP TABLE IF EXISTS `ey_guestbook`;
CREATE TABLE `ey_guestbook` (
  `aid` int(11) NOT NULL AUTO_INCREMENT,
  `typeid` int(11) DEFAULT '0' COMMENT '栏目ID',
  `channel` smallint(5) DEFAULT '0' COMMENT '模型ID',
  `ip` varchar(255) DEFAULT '' COMMENT 'ip地址',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`aid`)
) ENGINE=MyISAM AUTO_INCREMENT=46 DEFAULT CHARSET=utf8;

-- -----------------------------
-- Records of `ey_guestbook`
-- -----------------------------
INSERT INTO `ey_guestbook` VALUES ('44', '53', '8', '127.0.0.1', 'cn', '1528339902', '1528339902');
INSERT INTO `ey_guestbook` VALUES ('45', '53', '8', '127.0.0.1', 'cn', '1528356689', '1528356689');

-- -----------------------------
-- Table structure for `ey_guestbook_attr`
-- -----------------------------
DROP TABLE IF EXISTS `ey_guestbook_attr`;
CREATE TABLE `ey_guestbook_attr` (
  `guest_attr_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '留言表单id自增',
  `aid` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '留言id',
  `attr_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '表单id',
  `attr_value` text COMMENT '表单值',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`guest_attr_id`),
  KEY `attr_id` (`attr_id`) USING BTREE,
  KEY `guest_id` (`aid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=99 DEFAULT CHARSET=utf8 COMMENT='留言表单属性值';

-- -----------------------------
-- Records of `ey_guestbook_attr`
-- -----------------------------
INSERT INTO `ey_guestbook_attr` VALUES ('95', '44', '17', '测试测试', 'cn', '1528339902', '1528339902');
INSERT INTO `ey_guestbook_attr` VALUES ('94', '44', '16', 'admin@eyoucms.com', 'cn', '1528339902', '1528339902');
INSERT INTO `ey_guestbook_attr` VALUES ('93', '44', '15', '13800000000', 'cn', '1528339902', '1528339902');
INSERT INTO `ey_guestbook_attr` VALUES ('92', '44', '14', '张生', 'cn', '1528339902', '1528339902');
INSERT INTO `ey_guestbook_attr` VALUES ('98', '45', '17', '手机端测试', 'cn', '1528356689', '1528356689');
INSERT INTO `ey_guestbook_attr` VALUES ('97', '45', '15', '13800000000', 'cn', '1528356689', '1528356689');
INSERT INTO `ey_guestbook_attr` VALUES ('96', '45', '14', '张生', 'cn', '1528356689', '1528356689');

-- -----------------------------
-- Table structure for `ey_guestbook_attribute`
-- -----------------------------
DROP TABLE IF EXISTS `ey_guestbook_attribute`;
CREATE TABLE `ey_guestbook_attribute` (
  `attr_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '表单id',
  `attr_name` varchar(60) DEFAULT '' COMMENT '表单名称',
  `typeid` int(11) unsigned DEFAULT '0' COMMENT '栏目ID',
  `attr_input_type` tinyint(1) unsigned DEFAULT '0' COMMENT ' 0=文本框，1=下拉框，2=多行文本框',
  `attr_values` text COMMENT '可选值列表',
  `sort_order` int(11) unsigned DEFAULT '0' COMMENT '表单排序',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `is_del` tinyint(1) DEFAULT '0' COMMENT '是否已删除，0=否，1=是',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`attr_id`),
  KEY `guest_id` (`typeid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=18 DEFAULT CHARSET=utf8 COMMENT='留言表单属性';

-- -----------------------------
-- Records of `ey_guestbook_attribute`
-- -----------------------------
INSERT INTO `ey_guestbook_attribute` VALUES ('1', '姓名', '30', '0', '', '100', 'cn', '0', '1526616441', '1526616441');
INSERT INTO `ey_guestbook_attribute` VALUES ('2', '手机号码', '30', '0', '', '100', 'cn', '0', '1526616453', '1526616453');
INSERT INTO `ey_guestbook_attribute` VALUES ('3', '约谈对象', '30', '1', '隔壁老王\r\n前台美女\r\n扫地阿姨', '100', 'cn', '0', '1526616497', '1526616812');
INSERT INTO `ey_guestbook_attribute` VALUES ('4', '姓名', '6', '0', '', '100', 'cn', '0', '1526634369', '1526874914');
INSERT INTO `ey_guestbook_attribute` VALUES ('5', '联系方式', '6', '0', '', '100', 'cn', '0', '1526634383', '1526634383');
INSERT INTO `ey_guestbook_attribute` VALUES ('6', '备注信息', '6', '2', '', '100', 'cn', '0', '1526634393', '1526875056');
INSERT INTO `ey_guestbook_attribute` VALUES ('9', '邮箱', '6', '0', '', '100', 'cn', '0', '1527663557', '1527663557');
INSERT INTO `ey_guestbook_attribute` VALUES ('14', '您的姓名', '53', '0', '', '100', 'cn', '0', '1528276242', '1528276242');
INSERT INTO `ey_guestbook_attribute` VALUES ('15', '您的电话', '53', '0', '', '100', 'cn', '0', '1528276256', '1528276256');
INSERT INTO `ey_guestbook_attribute` VALUES ('16', '邮箱地址', '53', '0', '', '100', 'cn', '0', '1528276273', '1528276273');
INSERT INTO `ey_guestbook_attribute` VALUES ('17', '留言内容', '53', '2', '', '100', 'cn', '0', '1528276286', '1528276286');

-- -----------------------------
-- Table structure for `ey_hooks`
-- -----------------------------
DROP TABLE IF EXISTS `ey_hooks`;
CREATE TABLE `ey_hooks` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `name` varchar(50) NOT NULL DEFAULT '' COMMENT '钩子名称',
  `description` text COMMENT '描述',
  `module` varchar(50) DEFAULT '' COMMENT '钩子挂载的插件',
  `status` tinyint(1) unsigned DEFAULT '1' COMMENT '状态：0=无效，1=有效',
  `add_time` int(10) DEFAULT NULL,
  `update_time` int(10) unsigned DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `name` (`name`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='插件钩子表';


-- -----------------------------
-- Table structure for `ey_images_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_images_content`;
CREATE TABLE `ey_images_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `content` longtext COMMENT '内容详情',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `news_id` (`aid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=utf8 COMMENT='资讯内容表_存储正常内容';


-- -----------------------------
-- Table structure for `ey_images_upload`
-- -----------------------------
DROP TABLE IF EXISTS `ey_images_upload`;
CREATE TABLE `ey_images_upload` (
  `img_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `aid` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '图集ID',
  `title` varchar(200) DEFAULT '' COMMENT '产品标题',
  `image_url` varchar(255) DEFAULT '' COMMENT '文件存储路径',
  `width` int(11) DEFAULT '0' COMMENT '图片宽度',
  `height` int(11) DEFAULT '0' COMMENT '图片高度',
  `filesize` mediumint(8) unsigned DEFAULT '0' COMMENT '文件大小',
  `mime` varchar(50) DEFAULT '' COMMENT '图片类型',
  `sort_order` smallint(5) DEFAULT '0' COMMENT '排序',
  `add_time` int(10) unsigned DEFAULT '0' COMMENT '上传时间',
  PRIMARY KEY (`img_id`),
  KEY `arcid` (`aid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=20 DEFAULT CHARSET=utf8;


-- -----------------------------
-- Table structure for `ey_language`
-- -----------------------------
DROP TABLE IF EXISTS `ey_language`;
CREATE TABLE `ey_language` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT '信息ID，自增',
  `title` varchar(100) NOT NULL DEFAULT '' COMMENT '语言名称',
  `mark` varchar(50) NOT NULL DEFAULT '' COMMENT '语言标识（唯一）',
  `url` varchar(200) NOT NULL DEFAULT '' COMMENT '单独域名(外部链接)',
  `target` tinyint(1) NOT NULL DEFAULT '0' COMMENT '新窗口打开，0=否，1=是',
  `is_home_default` tinyint(1) DEFAULT '0' COMMENT '默认前台语言，1=是，0=否',
  `is_admin_default` tinyint(1) DEFAULT '0' COMMENT '默认后台语言，1=是，0=否',
  `syn_pack_id` int(10) DEFAULT '0' COMMENT '最后一次同步官方语言包ID',
  `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '语言状态，0=关闭，1=开启',
  `sort_order` int(10) DEFAULT '0' COMMENT '排序号',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='多语言主表';

-- -----------------------------
-- Records of `ey_language`
-- -----------------------------
INSERT INTO `ey_language` VALUES ('1', '简体中文', 'cn', '', '0', '1', '1', '24', '1', '100', '1541583096', '1543890743');

-- -----------------------------
-- Table structure for `ey_language_attr`
-- -----------------------------
DROP TABLE IF EXISTS `ey_language_attr`;
CREATE TABLE `ey_language_attr` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT '信息ID，自增',
  `attr_name` varchar(200) NOT NULL DEFAULT '' COMMENT '来自ey_weapp_language_attr表的attr_name',
  `attr_value` text NOT NULL COMMENT '变量值',
  `attr_group` varchar(50) DEFAULT '' COMMENT '分组，以表名划分（不含表前缀）',
  `lang` varchar(50) NOT NULL DEFAULT '' COMMENT '所属语言',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `attr_value` (`attr_name`,`lang`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='多语言模板变量关联绑定表';


-- -----------------------------
-- Table structure for `ey_language_attribute`
-- -----------------------------
DROP TABLE IF EXISTS `ey_language_attribute`;
CREATE TABLE `ey_language_attribute` (
  `attr_id` int(10) NOT NULL AUTO_INCREMENT COMMENT '信息ID，自增',
  `attr_title` varchar(200) NOT NULL DEFAULT '' COMMENT '变量标题',
  `attr_name` varchar(200) NOT NULL DEFAULT '' COMMENT '变量名称',
  `attr_group` varchar(50) DEFAULT '' COMMENT '分组，以表名划分（不含表前缀）',
  `is_del` tinyint(1) DEFAULT '0' COMMENT '伪删除，0=否，1=是',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`attr_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='多语言模板变量表';


-- -----------------------------
-- Table structure for `ey_language_mark`
-- -----------------------------
DROP TABLE IF EXISTS `ey_language_mark`;
CREATE TABLE `ey_language_mark` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `title` varchar(50) NOT NULL DEFAULT '' COMMENT '国家语言名称',
  `cn_title` varchar(50) NOT NULL DEFAULT '' COMMENT '中文名称',
  `mark` varchar(50) DEFAULT '' COMMENT '多语言标识',
  `pinyin` varchar(100) DEFAULT '' COMMENT '拼音',
  `sort_order` int(10) NOT NULL DEFAULT '0' COMMENT '排序号',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=57 DEFAULT CHARSET=utf8 COMMENT='国家语言表';

-- -----------------------------
-- Records of `ey_language_mark`
-- -----------------------------
INSERT INTO `ey_language_mark` VALUES ('1', '简体中文', '简体中文', 'cn', 'zhongwenjianti', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('2', 'Vietnamese', '越南语', 'vi', 'yuenanyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('3', '繁体中文', '繁体中文', 'zh', 'zhongwenfanti', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('4', 'English', '英语', 'en', 'yingyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('5', 'Indonesian', '印尼语', 'id', 'yinniyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('6', 'Urdu', '乌尔都语', 'ur', 'wuerduyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('7', 'Yiddish', '意第绪语', 'yi', 'yidixuyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('8', 'Italian', '意大利语', 'it', 'yidaliyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('9', 'Greek', '希腊语', 'el', 'xilayu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('10', 'Spanish Basque', '西班牙的巴斯克语', 'eu', 'xibanyadebasikeyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('11', 'Spanish', '西班牙语', 'es', 'xibanyayu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('12', 'Hungarian', '匈牙利语', 'hu', 'xiongyaliyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('13', 'Hebrew', '希伯来语', 'iw', 'xibolaiyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('14', 'Ukrainian', '乌克兰语', 'uk', 'wukelanyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('15', 'Welsh', '威尔士语', 'cy', 'weiershiyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('16', 'Thai', '泰语', 'th', 'taiyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('17', 'Turkish', '土耳其语', 'tr', 'tuerqiyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('18', 'Swahili', '斯瓦希里语', 'sw', 'siwaxiliyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('19', 'Japanese', '日语', 'ja', 'riyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('20', 'Swedish', '瑞典语', 'sv', 'ruidianyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('21', 'Serbian', '塞尔维亚语', 'sr', 'saierweiyayu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('22', 'Slovak', '斯洛伐克语', 'sk', 'siluofakeyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('23', 'Slovenian', '斯洛文尼亚语', 'sl', 'siluowenniyayu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('24', 'Portuguese', '葡萄牙语', 'pt', 'putaoyayu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('25', 'Norwegian', '挪威语', 'no', 'nuoweiyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('26', 'Macedonian', '马其顿语', 'mk', 'maqidunyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('27', 'Malay', '马来语', 'ms', 'malaiyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('28', 'Maltese', '马耳他语', 'mt', 'maertayu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('29', 'Romanian', '罗马尼亚语', 'ro', 'luomaniyayu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('30', 'Lithuanian', '立陶宛语', 'lt', 'litaowanyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('31', 'Latvian', '拉脱维亚语', 'lv', 'latuoweiyayu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('32', 'Latin', '拉丁语', 'la', 'ladingyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('33', 'Croatian', '克罗地亚语', 'hr', 'keluodiyayu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('34', 'Czech', '捷克语', 'cs', 'jiekeyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('35', 'Catalan', '加泰罗尼亚语', 'ca', 'jiatailuoniyayu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('36', 'Galician', '加利西亚语', 'gl', 'jialixiyayu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('37', 'Dutch', '荷兰语', 'nl', 'helanyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('38', 'Korean', '韩语', 'ko', 'hanyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('39', 'Haitian Creole', '海地克里奥尔语', 'ht', 'haidikeliaoeryu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('40', 'Finnish', '芬兰语', 'fi', 'fenlanyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('41', 'Filipino', '菲律宾语', 'tl', 'feilvbinyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('42', 'Russian', '俄语', 'ru', 'eyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('43', 'Boolean (Afrikaans)', '布尔语(南非荷兰语)', 'af', 'bueryunanfeihelanyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('44', 'French', '法语', 'fr', 'fayu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('45', 'Danish', '丹麦语', 'da', 'danmaiyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('46', 'German', '德语', 'de', 'deyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('47', 'Azerbaijani', '阿塞拜疆语', 'az', 'asaibaijiangyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('48', 'Irish', '爱尔兰语', 'ga', 'aierlanyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('49', 'Estonian', '爱沙尼亚语', 'et', 'aishaniyayu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('50', 'Belarusian', '白俄罗斯语', 'be', 'baieluosiyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('51', 'Bulgarian', '保加利亚语', 'bg', 'baojialiyayu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('52', 'Icelandic', '冰岛语', 'is', 'bingdaoyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('53', 'Polish', '波兰语', 'pl', 'bolanyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('54', 'Persian', '波斯语', 'fa', 'bosiyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('55', 'Arabic', '阿拉伯语', 'ar', 'alaboyu', '100', '0', '1541583096');
INSERT INTO `ey_language_mark` VALUES ('56', 'Albanian', '阿尔巴尼亚语', 'sq', 'aerbaniyayu', '100', '0', '1541583096');

-- -----------------------------
-- Table structure for `ey_language_pack`
-- -----------------------------
DROP TABLE IF EXISTS `ey_language_pack`;
CREATE TABLE `ey_language_pack` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `name` varchar(50) NOT NULL DEFAULT '' COMMENT '变量名',
  `value` text NOT NULL COMMENT '变量值',
  `is_syn` tinyint(1) DEFAULT '0' COMMENT '同步官方语言包：0=否，1=是',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `sort_order` int(10) DEFAULT '0' COMMENT '排序号',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=13 DEFAULT CHARSET=utf8 COMMENT='模板语言包变量';

-- -----------------------------
-- Records of `ey_language_pack`
-- -----------------------------
INSERT INTO `ey_language_pack` VALUES ('1', 'sys1', '首页', '1', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_language_pack` VALUES ('2', 'sys2', '上一页', '1', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_language_pack` VALUES ('3', 'sys3', '下一页', '1', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_language_pack` VALUES ('4', 'sys4', '末页', '1', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_language_pack` VALUES ('5', 'sys5', '共<strong>%s</strong>页 <strong>%s</strong>条', '1', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_language_pack` VALUES ('6', 'sys6', '全部', '1', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_language_pack` VALUES ('7', 'sys7', '搜索', '1', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_language_pack` VALUES ('8', 'sys8', '查看详情', '1', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_language_pack` VALUES ('9', 'sys9', '网站首页', '1', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_language_pack` VALUES ('10', 'sys10', '暂无', '1', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_language_pack` VALUES ('11', 'sys11', '上一篇', '1', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_language_pack` VALUES ('12', 'sys12', '下一篇', '1', 'cn', '100', '1543890216', '1543890216');

-- -----------------------------
-- Table structure for `ey_links`
-- -----------------------------
DROP TABLE IF EXISTS `ey_links`;
CREATE TABLE `ey_links` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `typeid` tinyint(1) DEFAULT '1' COMMENT '类型：1=文字链接，2=图片链接',
  `title` varchar(50) DEFAULT '' COMMENT '网站标题',
  `url` varchar(100) DEFAULT '' COMMENT '网站地址',
  `logo` varchar(255) DEFAULT '' COMMENT '网站LOGO',
  `sort_order` int(11) DEFAULT '0' COMMENT '排序号',
  `target` tinyint(1) DEFAULT '0' COMMENT '是否开启浏览器新窗口',
  `email` varchar(50) DEFAULT NULL,
  `intro` text COMMENT '网站简况',
  `status` tinyint(1) DEFAULT '1' COMMENT '状态(1=显示，0=屏蔽)',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `delete_time` int(11) DEFAULT '0' COMMENT '软删除时间',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8;

-- -----------------------------
-- Records of `ey_links`
-- -----------------------------
INSERT INTO `ey_links` VALUES ('2', '1', '易优CMS', 'http://www.eyoucms.com', '', '100', '1', '', '', '1', 'cn', '0', '1524975826', '1528185050');
INSERT INTO `ey_links` VALUES ('3', '1', '素材58', 'http://www.sucai58.com', 'http://www.eyoucms.dev/public/upload/system/2018/04/29/814ece093a0ba636209255dc20bd6e62.png', '100', '1', '', '', '1', 'cn', '0', '1524976095', '1528184984');
INSERT INTO `ey_links` VALUES ('4', '1', '区块链是什么', 'http://www.yiyocms.com/', '', '100', '1', '', '', '1', 'cn', '0', '1525266497', '1528185027');
INSERT INTO `ey_links` VALUES ('5', '1', '微信小程序开发教程', 'http://www.yiyongtong.com', '', '100', '1', '', '', '1', 'cn', '0', '1525748425', '1528185056');

-- -----------------------------
-- Table structure for `ey_product_attr`
-- -----------------------------
DROP TABLE IF EXISTS `ey_product_attr`;
CREATE TABLE `ey_product_attr` (
  `product_attr_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '产品属性id自增',
  `aid` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '产品id',
  `attr_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '属性id',
  `attr_value` text COMMENT '属性值',
  `attr_price` varchar(255) DEFAULT '' COMMENT '属性价格',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`product_attr_id`),
  KEY `aid` (`aid`) USING BTREE,
  KEY `attr_id` (`attr_id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=21 DEFAULT CHARSET=utf8;


-- -----------------------------
-- Table structure for `ey_product_attribute`
-- -----------------------------
DROP TABLE IF EXISTS `ey_product_attribute`;
CREATE TABLE `ey_product_attribute` (
  `attr_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '属性id',
  `attr_name` varchar(60) DEFAULT '' COMMENT '属性名称',
  `typeid` int(11) unsigned DEFAULT '0' COMMENT '栏目id',
  `attr_index` tinyint(1) unsigned DEFAULT '0' COMMENT '0不需要检索 1关键字检索 2范围检索',
  `attr_input_type` tinyint(1) unsigned DEFAULT '0' COMMENT ' 0=文本框，1=下拉框，2=多行文本框',
  `attr_values` text COMMENT '可选值列表',
  `sort_order` int(11) unsigned DEFAULT '0' COMMENT '属性排序',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `is_del` tinyint(1) DEFAULT '0' COMMENT '是否已删除，0=否，1=是',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`attr_id`),
  KEY `cat_id` (`typeid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=utf8;

-- -----------------------------
-- Records of `ey_product_attribute`
-- -----------------------------
INSERT INTO `ey_product_attribute` VALUES ('1', '用户界面', '24', '0', '0', '', '100', 'cn', '0', '1526612774', '1526612774');
INSERT INTO `ey_product_attribute` VALUES ('2', '操作系统', '24', '0', '0', '', '10', 'cn', '0', '1526612785', '1526612785');
INSERT INTO `ey_product_attribute` VALUES ('3', '键盘类型', '24', '0', '0', '', '100', 'cn', '0', '1526613004', '1526613004');
INSERT INTO `ey_product_attribute` VALUES ('4', ' 型号', '24', '0', '0', '', '100', 'cn', '0', '1526613011', '1526613011');
INSERT INTO `ey_product_attribute` VALUES ('5', '屏幕大小', '26', '0', '0', '', '100', 'cn', '0', '1526613252', '1526613252');
INSERT INTO `ey_product_attribute` VALUES ('6', '重量', '26', '0', '0', '', '100', 'cn', '0', '1526613259', '1526613259');
INSERT INTO `ey_product_attribute` VALUES ('7', '型号', '27', '0', '0', '', '100', 'cn', '0', '1526613668', '1526613668');
INSERT INTO `ey_product_attribute` VALUES ('8', '支持蓝牙', '27', '0', '0', '', '100', 'cn', '0', '1526613732', '1526613732');

-- -----------------------------
-- Table structure for `ey_product_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_product_content`;
CREATE TABLE `ey_product_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) DEFAULT '0' COMMENT '文档ID',
  `content` longtext COMMENT '内容详情',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `news_id` (`aid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COMMENT='资讯内容表_存储正常内容';


-- -----------------------------
-- Table structure for `ey_product_img`
-- -----------------------------
DROP TABLE IF EXISTS `ey_product_img`;
CREATE TABLE `ey_product_img` (
  `img_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `aid` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '产品ID',
  `title` varchar(200) DEFAULT '' COMMENT '产品标题',
  `image_url` varchar(255) DEFAULT '' COMMENT '文件存储路径',
  `width` int(11) DEFAULT '0' COMMENT '图片宽度',
  `height` int(11) DEFAULT '0' COMMENT '图片高度',
  `filesize` varchar(255) DEFAULT '' COMMENT '文件大小',
  `mime` varchar(50) DEFAULT '' COMMENT '图片类型',
  `sort_order` smallint(5) DEFAULT '0' COMMENT '排序',
  `add_time` int(10) unsigned DEFAULT '0' COMMENT '上传时间',
  PRIMARY KEY (`img_id`),
  KEY `arcid` (`aid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=22 DEFAULT CHARSET=utf8;


-- -----------------------------
-- Table structure for `ey_single_content`
-- -----------------------------
DROP TABLE IF EXISTS `ey_single_content`;
CREATE TABLE `ey_single_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '文档ID',
  `typeid` int(10) DEFAULT '0' COMMENT '栏目ID',
  `content` longtext COMMENT '内容详情',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `aid` (`aid`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=12 DEFAULT CHARSET=utf8;

-- -----------------------------
-- Records of `ey_single_content`
-- -----------------------------
INSERT INTO `ey_single_content` VALUES ('1', '1', '1', '&lt;p&gt;核心价值观：诚信、创新、服务&lt;/p&gt;&lt;p&gt;企业核心： 诚信&amp;nbsp;&lt;/p&gt;&lt;p&gt;企业精神： 团结拼搏、开拓求实、满足用户、科技进步。&lt;/p&gt;&lt;p&gt;&amp;nbsp;&lt;/p&gt;&lt;p&gt;客户：为客户提供高质量和最大价值的专业化产品和服务，以真诚和实力赢得客户的理解、尊重和支持。&lt;/p&gt;&lt;p&gt;市场：为客户降低采购成本和风险，为客户投资提供切实保障。&amp;nbsp;&lt;/p&gt;&lt;p&gt;发展：追求永续发展的目标，并把它建立在客户满意的基础上。&lt;/p&gt;&lt;p&gt;&amp;nbsp;&lt;/p&gt;&lt;p&gt;关于“为合作伙伴创造价值”&lt;/p&gt;&lt;p&gt;公司认为客户、供应商、公司股东、公司员工等一切和自身有合作关系的单位和个人都是自己的合作伙伴，并只有通过努力为合作伙伴创造价值，才能体现自身的价值并获得发展和成功。&lt;/p&gt;&lt;p&gt;关于“诚实、宽容、创新、服务”&lt;/p&gt;&lt;p&gt;公司认为诚信是一切合作的基础，宽容是解决问题的前提，创新是发展事业的利器，服务是创造价值的根本。公司会坚持持续改进、满足顾客期望、 确保品质第一、开拓全球市场。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '0', '1528443998');
INSERT INTO `ey_single_content` VALUES ('11', '78', '52', '&lt;p&gt;技术支持分售前技术支持和售后技术支持，售前技术支持是指在销售遇到无法解答的产品问题时，售前技术支持给予帮助；售后技术支持是指产品公司为其产品用户提供的售后服务的一种形式，帮助用户诊断并解决其在使用产品过程中出现的有明显症状的，可能由产品导致的技术问题。&lt;/p&gt;&lt;p&gt;在21世纪的当代，技术支持已经成为服务的一部分，也成为公司企业形象的重要组成部分。&lt;/p&gt;&lt;p&gt;技术的支持不仅仅是以解决技术问题为目的，更重要的是在客户的心里建立起企业的形象，让人们记住的是企业的形象，进一步记住所用产品的品牌，最后达成服务与品牌的完美结合。&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '1528254071', '1528333827');
INSERT INTO `ey_single_content` VALUES ('4', '8', '15', '&lt;p style=&quot;text-align: center;&quot;&gt;地址：这里是您的公司地址&amp;nbsp;&lt;/p&gt;&lt;p style=&quot;text-align: center;&quot;&gt;电话：400-123-4567&lt;/p&gt;&lt;p style=&quot;text-align: center;&quot;&gt;传真：+86-123-4567&lt;/p&gt;&lt;p style=&quot;text-align: center;&quot;&gt;邮编：000000&lt;/p&gt;&lt;p style=&quot;text-align: center;&quot;&gt;邮箱：这里是您公司的邮箱地址&lt;/p&gt;&lt;p style=&quot;text-align: center;&quot;&gt;&amp;nbsp;&lt;iframe class=&quot;ueditor_baidumap&quot; src=&quot;http://127.0.0.32/public/plugins/Ueditor/dialogs/map/show.html#center=113.368509,23.130358&amp;zoom=13&amp;width=530&amp;height=340&amp;markers=113.368509,23.130358&amp;markerStyles=l,A&quot; frameborder=&quot;0&quot; width=&quot;534&quot; height=&quot;344&quot;&gt;&lt;/iframe&gt;&lt;/p&gt;&lt;p&gt;&lt;br/&gt;&lt;/p&gt;', '0', '1528249149');

-- -----------------------------
-- Table structure for `ey_tagindex`
-- -----------------------------
DROP TABLE IF EXISTS `ey_tagindex`;
CREATE TABLE `ey_tagindex` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tag` varchar(50) NOT NULL DEFAULT '' COMMENT 'tag内容',
  `typeid` smallint(5) unsigned NOT NULL DEFAULT '0',
  `count` int(10) unsigned DEFAULT '0',
  `total` int(10) unsigned DEFAULT '0',
  `weekcc` int(10) unsigned DEFAULT '0',
  `monthcc` int(10) unsigned DEFAULT '0',
  `weekup` int(10) unsigned DEFAULT '0',
  `monthup` int(10) unsigned DEFAULT '0',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(10) unsigned DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `typeid` (`typeid`) USING BTREE,
  KEY `count` (`count`,`total`,`weekcc`,`monthcc`,`weekup`,`monthup`,`add_time`) USING BTREE,
  KEY `tag` (`tag`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=38 DEFAULT CHARSET=utf8;

-- -----------------------------
-- Records of `ey_tagindex`
-- -----------------------------
INSERT INTO `ey_tagindex` VALUES ('24', 'TAG标签', '10', '0', '0', '0', '0', '0', '0', 'cn', '1526544706');
INSERT INTO `ey_tagindex` VALUES ('25', '对的', '10', '0', '0', '0', '0', '0', '0', 'cn', '1526544706');
INSERT INTO `ey_tagindex` VALUES ('26', '替换稿件', '10', '0', '0', '0', '0', '0', '0', 'cn', '1526544706');
INSERT INTO `ey_tagindex` VALUES ('27', '杨靖宇', '10', '0', '0', '0', '0', '0', '0', 'cn', '1526544706');
INSERT INTO `ey_tagindex` VALUES ('28', '网站', '12', '0', '0', '0', '0', '0', '0', 'cn', '1526608291');
INSERT INTO `ey_tagindex` VALUES ('29', '建设', '12', '0', '0', '0', '0', '0', '0', 'cn', '1526608291');
INSERT INTO `ey_tagindex` VALUES ('30', '五大核心', '12', '0', '0', '0', '0', '0', '0', 'cn', '1526608291');
INSERT INTO `ey_tagindex` VALUES ('31', '要素', '12', '0', '0', '0', '0', '0', '0', 'cn', '1526608291');
INSERT INTO `ey_tagindex` VALUES ('32', '华为', '24', '0', '0', '0', '0', '0', '0', 'cn', '1526613161');
INSERT INTO `ey_tagindex` VALUES ('33', 'HUAWEI', '24', '0', '0', '0', '0', '0', '0', 'cn', '1526613161');
INSERT INTO `ey_tagindex` VALUES ('34', 'NOTE 8', '24', '0', '0', '0', '0', '0', '0', 'cn', '1526613161');
INSERT INTO `ey_tagindex` VALUES ('35', '宅男', '5', '0', '0', '0', '0', '0', '0', 'cn', '1526614158');
INSERT INTO `ey_tagindex` VALUES ('36', '女神', '5', '0', '0', '0', '0', '0', '0', 'cn', '1526614158');
INSERT INTO `ey_tagindex` VALUES ('37', '一号', '5', '0', '0', '0', '0', '0', '0', 'cn', '1526614158');

-- -----------------------------
-- Table structure for `ey_taglist`
-- -----------------------------
DROP TABLE IF EXISTS `ey_taglist`;
CREATE TABLE `ey_taglist` (
  `tid` int(10) unsigned NOT NULL DEFAULT '0',
  `aid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '文章ID',
  `typeid` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT '栏目ID',
  `tag` varchar(50) DEFAULT '' COMMENT 'tag内容',
  `arcrank` tinyint(1) DEFAULT '0' COMMENT '阅读权限',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`tid`,`aid`),
  KEY `aid` (`aid`,`typeid`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='文章标签表';


-- -----------------------------
-- Table structure for `ey_ui_config`
-- -----------------------------
DROP TABLE IF EXISTS `ey_ui_config`;
CREATE TABLE `ey_ui_config` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '表id',
  `md5key` varchar(100) NOT NULL DEFAULT '' COMMENT '唯一键值（由 theme_style、page、name）组成',
  `theme_style` varchar(20) DEFAULT 'pc' COMMENT '模板风格',
  `page` varchar(64) DEFAULT '' COMMENT '页面分组',
  `type` varchar(50) DEFAULT '' COMMENT '编辑类型',
  `name` varchar(50) DEFAULT '' COMMENT '与页面的e-id对应',
  `value` text COMMENT '页面美化的val值',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  UNIQUE KEY `md5key` (`md5key`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=19 DEFAULT CHARSET=utf8 COMMENT='页面美化参数设置';


-- -----------------------------
-- Table structure for `ey_weapp`
-- -----------------------------
DROP TABLE IF EXISTS `ey_weapp`;
CREATE TABLE `ey_weapp` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(50) DEFAULT '' COMMENT '插件标识',
  `name` varchar(55) DEFAULT '' COMMENT '中文名字',
  `config` text COMMENT '配置信息',
  `data` text COMMENT '额外序列化存储数据，简单插件可以不创建表，存储这里即可',
  `status` tinyint(1) DEFAULT '0' COMMENT '状态：0=未安装，1=启用，-1=禁用',
  `tag_weapp` tinyint(1) DEFAULT '1' COMMENT '1=自动绑定，2=手工调用。关联模板标签weapp，自动调用内置的show钩子方法',
  `thorough` tinyint(1) DEFAULT '0' COMMENT '彻底卸载：0=是，1=否',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`),
  KEY `code` (`code`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='插件应用表';

