/*
# Copyright State Street Corp. All Rights Reserved.
#
# SPDX-License-Identifier: Apache-2.0
*/
package car

import (
	"archive/tar"
	"bytes"
)

//MetadataProvider provides Metadata
type MetadataProvider struct {
}

// GetMetadataAsTarEntries extracts metata data from ChaincodeDeploymentSpec
func (carMetadataProv *MetadataProvider) GetMetadataAsTarEntries() ([]byte, error) {
	//This will convert metadata generated by car
	//into tar entries identical to the tar entries generated by
	//other platforms.
	//
	//Not implemented currently, users cannot specify metadata through CAR

	buf := bytes.NewBuffer(nil)
	tw := tar.NewWriter(buf)

	if err := tw.Close(); err != nil {
		return nil, err
	}

	return buf.Bytes(), nil
}
