v1.4.10 Release Notes - January 27, 2021
========================================

Fixes
-----

**peer and orderer PKCS#11 - Always Finalize the PKCS#11 FindObject Operation**

In certain error paths, a PKCS#11 session was not finalized, leaving the session
in a locked state so that it could not be reused.
This fix finalizes session handles even in error paths, so that the session can be reused
by subsequent calls.

**orderer - Allow tick interval override via orderer.yaml**

If a raft network becomes unstable, sometimes, adjusting the tick
interval duration can be effective to restore it. However, the tick interval is
stored in the channel configuration, so if the network is not operational,
modifying it is very challenging. This fix adds Consensus.TickIntervalOverride
option to orderer.yaml configuration, allowing the channel configuration parameter
to be overridden from the local configuration.

**FAB-18244: orderer - Single node orderer will not start due to inconsistent state**

If using a single node orderer, it was possible to get into an inconsistent state where
a Raft WAL snapshot was taken but an in-flight block at the associated height is not yet written.
This fix resolves the inconsistent state by writing the last block, so that the
single node orderer can start.

**orderer - Remove duplicate orderer server TLS root CAs**

This fix reduces processing overhead when an ordering service node participates
in many channels.

**peer - incorrect handling of values set to empty byte array in node chaincode**

Peer should handle key values set to nil or empty byte arrays as a delete of the key.
While the behavior worked as expected when using Go chaincode and Java chaincode, if using
node chaincode it did not work correctly when setting key values to empty byte arrays.
This fix ensures that peer will interpret empty byte arrays as deletes even for node chaincodes.
If using node chaincode with private data, if you had set private data values to an empty byte array,
the private data hash would have been committed incorrectly to the state database.
To repair the state database, after applying the fix, with the peer stopped,
request that the state database be rebuilt by calling "peer node rebuild-dbs"
or by deleting the state database. Upon the next start, the peer will rebuild the state
database from the already processed block store.
If subsequent transactions had referenced the existence of such a private data hash by
calling GetPrivateDataHash, then the subsequent transactions may have been
processed incorrectly and the peer will need to additionally reprocess blocks,
which can be triggered by calling "peer node reset" instead of "peer node rebuild-dbs".
If using regular channel data only and not private data, the empty byte array will
not have been committed, and therefore no action is required on the peer beyond applying the fix.


Dependencies
------------
Fabric v1.4.10 has been tested with the following dependencies:
* Go 1.14.12
* Fabric baseimage 0.4.22
* CouchDB v2.3.1


Changes, Known Issues, and Workarounds
--------------------------------------

**FAB-12134: Same chaincode source receiving fingerprint mismatch error** -
Chaincode installed in different ways may result in "chaincode fingerprint
mismatch data mismatch" error upon instantiation. This may happen when
installing chaincode by using different SDKs. To workaround the problem,
package the chaincode prior to installation and instantiation, by using
the "peer chaincode package" command.


Known Vulnerabilities
---------------------

**FAB-8664: Peer should detect and react when its org has been removed**
This is a relatively low severity problem, because it requires a significant
conspiracy of network admins, but it will be addressed in a future release.


Resolved Vulnerabilities
------------------------
None.


Deprecations (existing)
-----------------------
The following functions are deprecated and are targeted for removal in a future release.

**Support for automatically vendoring the chaincode shim into user chaincodes**

The fabric-ccenv image which is used to build chaincode, currently includes
the github.com/hyperledger/fabric/core/chaincode/shim ("shim") package.
This is convenient, as it provides the ability to package chaincode
without the need to include the "shim". However, this may cause issues in future
releases (and/or when trying to use packages which are included by the "shim").
In order to avoid any issues, users are advised to manually vendor the "shim"
package with their chaincode prior to using the peer CLI for packaging and/or
for installing chaincode.
Support removed in v2.0. For more details see FAB-5177.

**Support for CAR chaincode package format**

Support for packaging chaincode using the CAR format will be removed in
a future release.
Support removed in v2.0. For more details see FAB-14720.

**Support for invoking system chaincodes from user chaincodes.**

System chaincodes, for example QSCC, are intended to be invoked by
a client rather than by a user chaincode. Invoking from a user chaincode
may cause deadlocks.
Support removed in v2.0. For more details see FAB-15285.

**Support for user chaincodes to utilize the chaincode shim's logger via NewLogger()**

Chaincodes that used the shim's NewLogger() will need to shift to their own preferred
logging mechanism.
Support removed in v2.0. For more details see FAB-15366.

**Support for peer's Admin service**

The peer's Admin service exposes APIs such as GetLogSpec() and SetLogSpec().
Instead of using these services, utilize the HTTP operations service that was
introduced in v1.4.0.
Support removed in v2.0. For more details see FAB-15390.

**Support for specifying orderer endpoints at the global level in channel configuration.**

Utilize the new 'OrdererEndpoints' stanza within the channel configuration of
an organization instead.
For more details see FAB-7559.

**The 'Solo' consensus type is deprecated.**

With the introduction of Raft-based ordering service in v1.4.1, it is possible
to deploy a single-node (non-production) or multi-node
Raft-based ordering service with no external dependencies.
For single-node (non-production) ordering services, utilize Raft-based ordering
service with a single node instead of Solo ordering service.
For more details see FAB-15754.

**The 'Kafka' consensus type is deprecated**

The 'Raft' consensus type was introduced in v1.4.1 and has become the preferred
production consensus type. There is a documented and tested migration path from
Kafka to Raft, and existing users should migrate to the newer Raft consensus type.
For compatibility with existing deployments, Kafka is still supported,
but may be removed entirely in a future release.
Additionally, the fabric-kafka and fabric-zookeeper docker images are no longer updated, maintained, or published.

**fabric-couchdb docker image no longer updated, maintained, or published**

The fabric-couchdb docker image will no longer be updated, maintained, or published.
Users can utilize the official CouchDB docker image maintained by the Apache CouchDB project instead.


Change log
----------
For the full list of changes, refer to the release change log:
https://github.com/hyperledger/fabric/blob/release-1.4/CHANGELOG.md#v1410
