v1.4.7 Release Notes - May 14, 2020
===================================

Fixes
-----

- **FAB-17517: Only Initialize specified BCCSP provider**

  This fix ensures that only specified provider is initialized
  based on ProviderName.
  This fixes "Failed initializing PKCS11.BCCSP %!s(<nil>)" error
  when the code compiled with PKCS11 or PLUGINS enabled expected
  configuration to not be nil even when Provider is set to SW.  

- **FAB-16951: Alternative mechanisms to find pkcs11 key**

  This modification adds a parameter called AltID to the PKCS11 BCCSP configuration.
  This change is required in situations where the HSM does not allow
  modification of the CKA_ID after creation, for example when using AWS CloudHSM.

- **FAB-17726: Properly handle malformed gossip envelopes**

  If a malformed envelope is read from the stream, an error is propagated
  synchronously up the stack.
  Under very rare circumstances a race condition caused a nil pointer peer panic.

- **FAB-16879: Add stack trace to couchdb http errors**

  If there was an http error calling couchdb, no context was provided in the error message.
  This change adds stack trace in addition to the http error message,
  so that administrators can identify where the error was hit.

- **FAB-17722: Validate HSM session and get new if invalid**

  Previously the pkcs11 code was set to have a session cache and reuse sessions
  if available in cache. If a session went bad (due to connection issues with HSM),
  the session was not evicted from cache and would be reused.
  If all sessions went bad, the client would never be able to recover and keep using bad sessions.

- **FAB-17752: Return errors when creating keystore**

  An error is now returned if BCCSP is not able to create keystore directory.

- **FAB-17778: Fix policy support of multiple signatures from single organization**

  Fix de-duplication logic to ensure sufficient number of signatures are received to satisfy
  policies that require multiple signatures from the same organization.
  This problem is rare since most users have policies that require signatures from different
  organizations, not policies that require multiple signatures from the same organization.

- **FAB-17728: Add delay to pkcs11 create session loop**

  Previously there was no backoff when attempting to create a new session if one was not
  available in the HSM session cache. This fix introduces a hardcoded backoff of 100ms
  after each attempt up to 10.


Dependency updates
------------------
- Bump Go to 1.13.9.
- Bump Fabric baseimage to 0.4.20.


Changes, Known Issues, and Workarounds
--------------------------------------

- **FAB-12134: Same chaincode source receiving fingerprint mismatch error** -
  Chaincode installed in different ways may result in "chaincode fingerprint
  mismatch data mismatch" error upon instantiation. This may happen when
  installing chaincode by using different SDKs. To workaround the problem,
  package the chaincode prior to installation and instantiation, by using
  the "peer chaincode package" command.


Known Vulnerabilities
---------------------

- **FAB-8664: Peer should detect and react when its org has been removed**
  This is a relatively low severity problem, because it requires a significant
  conspiracy of network admins, but it will be addressed in a future release.


Resolved Vulnerabilities
------------------------
None.


Deprecations
------------
The following functions are deprecated and are targeted for removal in a future release.

- **Support for automatically vendoring the chaincode shim into user chaincodes**

  The fabric-ccenv image which is used to build chaincode, currently includes
  the github.com/hyperledger/fabric/core/chaincode/shim ("shim") package.
  This is convenient, as it provides the ability to package chaincode
  without the need to include the "shim". However, this may cause issues in future
  releases (and/or when trying to use packages which are included by the "shim").
  In order to avoid any issues, users are advised to manually vendor the "shim"
  package with their chaincode prior to using the peer CLI for packaging and/or
  for installing chaincode.
  For more details see FAB-5177.

- **Support for CAR chaincode package format**

  Support for packaging chaincode using the CAR format will be removed in
  a future release.
  For more details see FAB-14720.

- **Support for specifying orderer endpoints at the global level in channel configuration.**

  Utilize the new 'OrdererEndpoints' stanza within the channel configuration of
  an organization instead.
  For more details see FAB-7559.

- **Support for invoking system chaincodes from user chaincodes.**

  System chaincodes, for example QSCC, are intended to be invoked by
  a client rather than by a user chaincode. Invoking from a user chaincode
  may cause deadlocks.
  For more details see FAB-15285.

- **Support for user chaincodes to utilize the chaincode shim's logger via NewLogger()**

  Chaincodes that used the shim's NewLogger() will need to shift to their own preferred
  logging mechanism.
  For more details see FAB-15366.

- **Support for peer's Admin service**

  The peer's Admin service exposes APIs such as GetLogSpec() and SetLogSpec().
  Instead of using these services, utilize the HTTP operations service that was
  introduced in v1.4.0.
  For more details see FAB-15390.

- **Support for Solo ordering service**

  With the introduction of Raft-based ordering service in v1.4.1, it is possible
  to deploy a single-node (non-production) or multi-node
  Raft-based ordering service with no external dependencies.
  For single-node (non-production) ordering services, utilize Raft-based ordering
  service with a single node instead of Solo ordering service.
  For more details see FAB-15754.


Change log
----------
For the full list of changes, refer to the release change log:
https://github.com/hyperledger/fabric/blob/release-1.4/CHANGELOG.md#v147
