<?php
class GoodList_Model{
    private $db;
    function __construct(){
	    $this->db=Mysql::getInstance();
	}

	function getData($page,$pagesize,$cons=''){
		$data=array();
	    $offset=($page-1)*$pagesize;
		$result=$this->db->query("SELECT * FROM ".DB_PREFIX."goodList $cons LIMIT $offset,$pagesize");
		if($this->db->num_rows($result)>0){
			$ob=new Goods_Model();
		    while($row=$this->db->fetch_array($result)){
				//是否设置价值比例
				$res=$this->db->query("SELECT count(*) FROM ".DB_PREFIX."rates WHERE goodid=".$row['id']."");
				$row2=$this->db->fetch_array($res);
				$row['is_config_rates']=$row2[0] ? $row[0] : 0;
				$row['sellGoods']=$ob->getDataNum("WHERE goodid=".$row['id']." AND is_state=1");
				$row['kucunGoods']=$ob->getDataNum("WHERE goodid=".$row['id']." AND is_state=0");
				$row['id']=intval($row['id']);
			    $row['goodname']=htmlspecialchars($row['goodname']);
				$row['price']=makeSafe($row['price'],'float');
				$row['cbprice']=makeSafe($row['cbprice'],'float');
				$row['is_state']=intval($row['is_state']);
				$row['sortid']=intval($row['sortid']);
				$row['remark']=htmlspecialchars($row['remark']);
				$data[]=$row;
			}
		}
		return $data;
	}

	function getDataNum($cons=''){
	    $result=$this->db->query("SELECT id FROM ".DB_PREFIX."goodList $cons");
		return $this->db->num_rows($result);
	}

	function addData($data){
	    $filed=array();
		$value=array();
		foreach($data as $key=>$val){
		    $filed[]=$key;
			$value[]="'$val'";
		}
		$fileds=implode(',',$filed);
		$values=implode(',',$value);
		$this->db->query("INSERT INTO ".DB_PREFIX."goodList(".$fileds.") VALUES(".$values.")");
		return $this->db->insert_id();
	}

	function updateData($id,$data){
	    $item=array();
		foreach($data as $key=>$val){
		    $item[]="$key='$val'";
		}
		$items=implode(',',$item);
		$this->db->query("UPDATE ".DB_PREFIX."goodList SET $items WHERE id=$id");
	}

	function deleteData($id){
	    $this->db->query("DELETE FROM ".DB_PREFIX."goodList WHERE id=$id");
	}

	function getOneData($id){
	    $result=$this->db->query("SELECT * FROM ".DB_PREFIX."goodList WHERE id=$id");
		if($this->db->num_rows($result)>0){
		    $row=$this->db->fetch_array($result);
		    $row['goodname']=htmlspecialchars($row['goodname']);
			$row['price']=makeSafe($row['price'],'float');
			$row['cbprice']=makeSafe($row['cbprice'],'float');
		    $row['is_state']=intval($row['is_state']);
		    $row['sortid']=intval($row['sortid']);
			$row['remark']=htmlspecialchars($row['remark']);
			$row['invent_report']=intval($row['invent_report']);
			$row['is_diplay']=intval($row['is_display']);
			$row['is_paytype']=intval($row['is_paytype']);
			$row['sitename']=htmlspecialchars($row['sitename']);
			$row['siteurl']=htmlspecialchars($row['siteurl']);
			$row['qq']=htmlspecialchars($row['qq']);
			return $row;
		}
		return false;
	}

	function getAllData($id,$t=''){
		switch($t){
		    case 'cateid': $cons="WHERE cateid='$id'"; break;
			case 'linkid': $cons="WHERE linkid='$id'"; break;
			case 'id': $cons="WHERE id='$id'"; break;
			default: $cons="WHERE userid='$id'";
		}

		$data=array();
	    $result=$this->db->query("SELECT * FROM ".DB_PREFIX."goodList $cons ORDER BY sortid ASC, id DESC");
		if($this->db->num_rows($result)>0){
		    while($row=$this->db->fetch_array($result)){
				$row['goodname']=htmlspecialchars($row['goodname']);
				$row['price']=makeSafe($row['price'],'float');
				$row['cbprice']=makeSafe($row['cbprice'],'float');
				$row['is_state']=intval($row['is_state']);
				$row['sortid']=intval($row['sortid']);
				$row['remark']=htmlspecialchars($row['remark']);
				$row['invent_report']=intval($row['invent_report']);
				$row['is_diplay']=intval($row['is_display']);
				$row['is_paytype']=intval($row['is_paytype']);
				$row['sitename']=htmlspecialchars($row['sitename']);
				$row['siteurl']=htmlspecialchars($row['siteurl']);
				$row['qq']=htmlspecialchars($row['qq']);
				$data[]=$row;
			}
		}
		return $data;
	}

	private function getUserID($goodid){
	    $result=$this->db->query("SELECT userid FROM ".DB_PREFIX."goodList WHERE id=$goodid");
		if($this->db->num_rows($result)>0){
		    $row=$this->db->fetch_array($result);
			return $row[0];
		}
		return false; 
	}

	static function getUserIDbyGoodID($goodid){
        $ob=new GoodList_Model();
		return $ob->getUserID($goodid);
	}

	static function getGoodnamebyGoodID($goodid){
        $ob=new GoodList_Model();
		return $ob->getGoodname($goodid);
	}

	private function getGoodname($goodid){
	    $result=$this->db->query("SELECT goodname FROM ".DB_PREFIX."goodList WHERE id=$goodid");
		if($this->db->num_rows($result)>0){
		    $row=$this->db->fetch_array($result);
			return $row[0];
		}
		return false;
	}
}
?>