<?php
/////////////////////////////////////////////////////////////////////////////
// 这个文件是 网城创想多用户商城 项目的一部分
//
// Copyright (c) 2007 - 2009 www.shopnc.net 
//
// 要查看完整的版权信息和许可信息，请查看源代码中附带的 COPYRIGHT 文件，
// 或者访问 http://www.shopnc.net/ 获得详细信息。
/////////////////////////////////////////////////////////////////////////////

/**
 * FILE_NAME : system.php
 * ....ntalker插件
 *
 * @copyright Copyright (c) 2007 - 2009 www.shopnc.net 
 * @author ShopNC Develop Team 
 * @package 
 * @subpackage 
 * @version Mon May 18 15:55:30 CST 2009
 */

require_once("../../global.inc.php");

class SysImClass extends SystemFrameWork{
	/**
	 * 应用内容
	 *
	 * @var obj
	 */
	var $default_app_array;
	/**
	 * 应用对象
	 *
	 * @var obj
	 */
	var $obj_app_class;
	/**
	 * 验证对象
	 *
	 * @var obj
	 */
	var $obj_validate;
	
	function SysImClass(){
		$this->__construct();
	}
	function __construct(){
		//初始化信息
		$this->default_app_array = $this->constructAppModule('ntalker','system','system');
		/**
		 * 模板输出
		 */
		$this->output('app_module',$this->default_app_array);
	}
	
	function main(){
		/**
		 * 创建应用对象
		 */
		if (!is_object($this->obj_app_class)){
			require_once("app_module.class.php");
			$this->obj_app_class = new AppModuleClass();
		}
		/**
		 * 创建验证对象
		 */
		if (!is_object($this->obj_validate)){
			require_once("commonvalidate.class.php");
			$this->obj_validate = new CommonValidate();
		}
		
		switch ($this->_input['action']){
			case 'setup':
				$this->_setup();
				break;
			case 'setup_save':
				$this->_setup_save();
				break;
			case 'unsetup':
				$this->_unsetup();
				break;
			case 'unsetup_save':
				$this->_unsetup_save();
				break;
			case 'manage_modi':
				$this->_manage_modi();
				break;
			case 'manage_update':
				$this->_manage_update();
				break;
			case 'ajax_list':
				$this->_ajax_list();
				break;
		}
		
	}
	
	
	/**
	 * 安装界面
	 */
	function _setup(){
		/**
		 * 页面输出
		 */
		$this->output('app_array',$this->default_app_array);
		$this->showpage('sys_ntalker.setup');
	}
	
	/**
	 * 完成安装
	 */
	function _setup_save(){
		//第一次安装
		if ($this->default_app_array['app_module_first_install'] == '0'){
			//第一次安装时候，与ntalker服务器端进行注册流程
			$this->_regist();
		}
		$value_array = array();
		$value_array['app_module_id'] = $this->default_app_array['app_module_id'];
		$value_array['app_module_state'] = $this->_input['app_module_state'];
		$value_array['app_module_sort'] = $this->_input['app_module_sort'];
		$value_array['app_module_install'] = '1';
		$value_array['app_module_first_install'] = '1';
		$result = $this->obj_app_class->updateAppModule($value_array);
		if ($result !== true){
			Common::outMessage("json",$this->_lang['errSysAppManageSetupIsFail'],0);
		}else {
			Common::outMessage("json",$this->_lang['langSysAppManageSetupIsSucc'],1);
		}
	}
	
	/**
	 * 卸载
	 */
	function _unsetup(){
		/**
		 * 页面输出
		 */
		$this->output('app_array',$this->default_app_array);
		$this->showpage('sys_ntalker.unsetup');
	}
	
	/**
	 * 卸载保存
	 */
	function _unsetup_save(){
		//更新
		$value_array = array();
		$value_array['app_module_id'] = $this->default_app_array['app_module_id'];
		$value_array['app_module_state'] = '1';
		$value_array['app_module_install'] = '0';
		$result = $this->obj_app_class->updateAppModule($value_array);
		if ($result !== true){
			Common::outMessage("json",$this->_lang['errSysAppManageUnsetupNotExistOne']. BasePath.'/app/'.$this->default_app_array['app_module_path'] .$this->_lang['errSysAppManageUnsetupNotExistTwo'],0);
		}else {
			Common::outMessage("json",$this->_lang['langSysAppManageUnsetupIsSucc'],1);
		}
	}
	
	/**
	 * 修改
	 */
	function _manage_modi(){
		/**
		 * 页面输出
		 */
		$this->output('app_array',$this->default_app_array);
		$this->showpage('sys_ntalker.manage_modi');
	}
	
	/**
	 * 保存修改
	 */
	function _manage_update(){
		/**
		 * 验证提交的数据
		 */
		$this->obj_validate->setValidate(array("input"=>$this->_input['app_module_sort'],"require"=>"true","validator"=>"Number","message"=>$this->_lang['errSysAppManageSortNotNumber']));
		$error = $this->obj_validate->validate();
		if ($error != ""){
			$error = $this->formatError($error);
			Common::outMessage("json",$error,0);
		}else{
			//更新
			$value_array = array();
			$value_array['app_module_id'] = $this->default_app_array['app_module_id'];
			$value_array['app_module_sort'] = $this->_input['app_module_sort'];
			$value_array['app_module_state'] = $this->_input['app_module_state'];
			$result = $this->obj_app_class->updateAppModule($value_array);
			if ($result !== true){
				Common::outMessage("json",$this->_lang['errSysAppManageUpdateIsFail'],0);
			}else {
				Common::outMessage("json",$this->_lang['langSysAppManageUpdateIsSucc'],1);
			}
		}
	}
	
	/**
	 * 管理
	 */
	function _ajax_list(){
		$config_url = BasePath.'/app/'.$this->default_app_array['app_module_path'].'/imconfig.inc.php';
		if(!is_writeable($config_url)) {
			Common::outMessage("json",$this->_lang['errSupplyConfigFileNotWriteOne']. BasePath.'/app/'.$this->default_app_array['app_module_path'].'/imconfig.inc.php' .$this->_lang['errSupplyConfigFileNotWriteTwo'],0);
		}else {
			require_once($config_url);
		}
		/**
		 * 模板输出
		 */
		$this->output('im_sys_id',$im_sys_id);
		$this->output('im_sys_pw',$im_sys_pw);
		$this->showpage('sys_ntalker.list');
	}
	
	/**
	 * 注册流程
	 */
	function _regist(){
		$config_url = BasePath.'/app/'.$this->default_app_array['app_module_path'].'/imconfig.inc.php';
		if(!is_writeable($config_url)) {
			Common::outMessage("json",$this->_lang['errSupplyConfigFileNotWriteOne']. BasePath.'/app/'.$this->default_app_array['app_module_path'].'/imconfig.inc.php' .$this->_lang['errSupplyConfigFileNotWriteTwo'],0);
		}
		$regist_url .= 'http://www.ntalker.com/admin/regsite.php';
		$regist_url .= '?domain='.str_replace('http://','',$this->_configinfo['websit']['site_url']);
		$regist_url .= '&interface='.urlencode($this->_configinfo['websit']['site_url'].'/app/'.$this->default_app_array['app_module_path'].'/imxml.php');
		$regist_url .= '&email='.$this->_configinfo['contact']['email'];
		$regist_url .= '&partner=shopnc';
		//向服务器端发出请求，获取注册后的信息，并且写入配置文件
		$regist_content = @file_get_contents($regist_url);
		require_once('json.class.php');
		$obj_json = new Services_JSON();
		$return_value= $obj_json->decode(str_replace('\\','',$regist_content));
		if ($return_value->result == '0' || $return_value->result == '-2'){//注册成功或者已经注册重新返回的帐号密码
			$siteid = $return_value->ntalkersiteid;
			$sitekey = $return_value->ntalkersitekey;
			$sys_id = $return_value->ntalkerid;//ntalker管理后台帐号
			$sys_pw = $return_value->ntalkerpassword;//ntalker管理后台密码
			//写入文件
			$configfile = @file_get_contents($config_url);
			$configfile = trim($configfile);
			$configfile = substr($configfile, -2) == '?>' ? substr($configfile, 0, -2) : $configfile;
			if (!empty($siteid)){
				$configfile = preg_replace("/[$]im_siteid\s*\=\s*[\"'].*?[\"'];/is", "\$im_siteid = '$siteid';", $configfile);
			}
			if (!empty($sitekey)){
				$configfile = preg_replace("/[$]im_sitekey\s*\=\s*[\"'].*?[\"'];/is", "\$im_sitekey = '$sitekey';", $configfile);
			}
			if (!empty($sys_id)){
				$configfile = preg_replace("/[$]im_sys_id\s*\=\s*[\"'].*?[\"'];/is", "\$im_sys_id = '$sys_id';", $configfile);
			}
			if (!empty($sys_pw)){
				$configfile = preg_replace("/[$]im_sys_pw\s*\=\s*[\"'].*?[\"'];/is", "\$im_sys_pw = '$sys_pw';", $configfile);
			}
			if (phpversion() > 5.0){
				@file_put_contents($config_url, $configfile);
			}else {
				$handle = @fopen($config_url, 'wb+');
				$configfile .= "\n?>";
				@fwrite($handle, $configfile);
				@fclose($handle);
			}
			return true;
		}else {
			if (strtolower($this->_configinfo['websit']['ncharset']) == 'gbk'){//转码
				$return_value->errorcontent = Common::nc_change_charset($return_value->errorcontent,'utf8_to_gbk');
			}
			if (empty($return_value->errorcontent)){
				$return_value->errorcontent = $this->_lang['langWebImSetupFail'];
			}
			Common::outMessage("json",$return_value->errorcontent,0);
		}
	}
}
$im = new SysImClass();
$im->main();
unset($im);
?>