<?php
/////////////////////////////////////////////////////////////////////////////
// 这个文件是 网城创想多用户商城 项目的一部分
//
// Copyright (c) 2007 - 2008 www.shopnc.net 
//
// 要查看完整的版权信息和许可信息，请查看源代码中附带的 COPYRIGHT 文件，
// 或者访问 http://www.shopnc.net/ 获得详细信息。
/////////////////////////////////////////////////////////////////////////////

/**
 * FILE_NAME : index.php
 * ....空间前台
 *
 * @copyright Copyright (c) 2007 - 2008 www.shopnc.net 
 * @author ShopNC Develop Team 
 * @package 
 * @subpackage 
 * @version Sun Jan 04 11:19:43 CST 2009
 */

require_once("../../global.inc.php");

class Space extends CommonFrameWork{
	/**
	 * 空间对象
	 *
	 * @var obj
	 */
	var $obj_space;
	/**
	 * 分页对象
	 *
	 * @var obj
	 */
	var $obj_page;
	/**
	 * 应用内容
	 *
	 * @var obj
	 */
	var $default_app_array;
	//构造函数
	function Space(){
		$this->__construct();
	}
	//初始化信息
	function __construct(){
		$this->default_app_array = $this->constructAppModule('space','home');
	}		
	function main () {
		/**
		 * 初始化空间类
		 */
		if (!is_object ( $this->obj_space )) {
			include_once("space.class.php");
			$this->obj_space = new spaceClass();
		}
		/**
		 * 创建分页对象
		 */
		if (!is_object($this->obj_page)){
			require_once("ajaxcommonpage.class.php");
			$this->obj_page = new CommonPage();
		}	
		//个人中心跳转过来的链接
		if ($this->_input['uid'] == '') {
	 		//验证是否登录
			$this->isMember(0); 			
			//检查空间是否开通
			if ( $this->_check_space ( $_SESSION['s_login']['id'] ) ) {
				$this->_input['uid'] = $_SESSION['s_login']['id'];
			} else {
				//提示开通页面
				$this->showpage( "space_open" );
				exit;
			}
		}
		//获取公共部分	
		if ( $this->_input['uid'] != '' ) {
			$this->_output_public ();
		} else {
	 	 	//该用户没有开通空间
	 	 	$this->redirectPath ( "error", "../index.html", $this->_lang['langSpaceNone'] );	
	 	 	exit;				
		}
		switch ( $this->_input['action'] ) {
			//查看精品推荐
			case 'blog_commend_view':
				$this->_blog_commend_view ();
				break;
			//查看日志
			case 'blog_view':
				$this->_blog_view ();
				break;
			//精品推荐
			case 'commend':
				$this->_blog_commend ();
				break;
			//日志
			case 'blog':
				$this->_show_blog_list ();
				break;
			//留言
			case 'message':
				$this->_show_message_list ();
				break;	
			//好友
			case 'friend':
				$this->_show_friend_list ();
				break;	
			default:
				$this->_show_space_index ();
		}
	}
	/**
	 * 检查是否开通空间
	 *
	 * @return bool
	 */
	function _check_space ( $uid ) {
 	 	//是否有空间
 	 	$space_array = $this->obj_space->getSpaceInfo ( $uid, 'uid' );	
 	 	if ( $space_array['uid'] == '' ) {
 	 		return false;
 	 	} else {
 	 		return true;
 	 	}
	}
	/**
	 * 好友列表
	 *
	 */
	function _show_friend_list () {
		$this->obj_page->pagebarnum ( 15 );	//每页显示?条				
		//好友列表			
		$friend_array = $this->obj_space->getSpaceFriendList ( $this->_input['uid'], $this->obj_page );	
		if ( is_array($friend_array) ) {
			foreach ( $friend_array as $k => $v ) {
				$friend_array[$k]['dateline'] = date ( 'Y-m-d', $friend_array[$k]['dateline'] );
				if ( $friend_array[$k]['picture'] != '' ) {
					$ex_picture = explode( ".",$friend_array[$k]['picture'] );
					$friend_array[$k]['picture'] = $ex_picture[0]."_big.".$ex_picture[1];			
					$friend_array[$k]['picture_small'] = $ex_picture[0]."_mid.".$ex_picture[1];			
				}				
			}
		}		
		$pagelist = $this->obj_page->show ( 1 ); //分页显示					
		//抛出页面
		$this->output( "friend_array", $friend_array );
		$this->output( "pagelist", $pagelist );
		$this->showpage( "friend" );		
	}
	/**
	 * 留言列表
	 *
	 */
	function _show_message_list () {
		$this->obj_page->pagebarnum ( 15 );	//每页显示?条				
		//日志列表			
		$message_array = $this->obj_space->getMessageList ( $this->_input['uid'], $this->obj_page );
		foreach ( $message_array as $k => $vm ) {
			$message_array[$k]['dateline'] = date ( 'Y-m-d H:i:s', $message_array[$k]['dateline'] );
			if ( $message_array[$k]['picture'] != '' ) {
				$ex_picture = explode( ".",$message_array[$k]['picture'] );
				$message_array[$k]['picture'] = $ex_picture[0]."_big.".$ex_picture[1];			
				$message_array[$k]['picture_small'] = $ex_picture[0]."_mid.".$ex_picture[1];			
			}				
		}				
		$pagelist = $this->obj_page->show ( 1 ); //分页显示					
		//抛出页面
		$this->output( "message_array", $message_array );
		$this->output( "pagelist", $pagelist );
		$this->showpage( "message" );		
	}
	/**
	 * 精品推荐列表
	 *
	 */
	function _blog_commend () {
		if ( $this->_input['uid'] != '' ) {
			$this->obj_page->pagebarnum ( 15 );	//每页显示?条				
			//日志列表			
			$blog_array = $this->obj_space->getSpaceBlogList ( $this->_input['uid'], $this->obj_page, 1 );	
			if ( is_array($blog_array) ) {
				foreach ( $blog_array as $k => $vb ) {
					$blog_array[$k]['dateline'] = date ( 'Y-m-d H:i:s', $blog_array[$k]['dateline'] );
					$blog_array[$k]['subject'] = preg_replace("/(\<[^\<]*\>|\r|\n|\s|\[.+?\])/is", ' ', $blog_array[$k]['subject']);										
					$blog_array[$k]['title_cut'] = Common::cutstr ( $blog_array[$k]['title'], 15);
					$blog_array[$k]['subject'] = Common::cutstr ( $blog_array[$k]['subject'], 400);
					$blog_array[$k]['subject']  = str_replace( array('&amp;', '&quot;', '&lt;', '&gt;'), array('&', '"', '<', '>'), $blog_array[$k]['subject'] );					
					switch ( $blog_array[$k]['classid'] ) {
						case '0':
							$blog_array[$k]['classid'] = $this->_lang['langSpaceBlogCommon']; //普通日志
							break;	
						case '1':
							$blog_array[$k]['classid'] = $this->_lang['langSpaceBlogCommend']; //经典推荐
							break;							
					}		
				}	
			}			
			$pagelist = $this->obj_page->show ( 1 ); //分页显示								
			//抛出页面
			$this->output( "blog_array", $blog_array ); //blog
			$this->output( "pagelist", $pagelist ); //分页			
			$this->showpage( "blog_commend" );
		}		
	}
	/**
	 * 日志列表
	 *
	 */
	function _show_blog_list () {
		if ( $this->_input['uid'] != '' ) {		
			$this->obj_page->pagebarnum ( 15 );	//每页显示?条			
			//日志列表	
			if ( $this->_input['classid'] != '' ) {
				$blog_array = $this->obj_space->getSpaceBlogList ( $this->_input['uid'], $this->obj_page, '', $this->_input['classid'] );	
			} else {
				$blog_array = $this->obj_space->getSpaceBlogList ( $this->_input['uid'], $this->obj_page );
			}
			if ( is_array($blog_array) ) {
				foreach ( $blog_array as $k => $vb ) {
					$blog_array[$k]['dateline'] = date ( 'Y-m-d H:i:s', $blog_array[$k]['dateline'] );	
					$blog_array[$k]['subject'] = preg_replace("/(\<[^\<]*\>|\r|\n|\s|\[.+?\])/is", ' ', $blog_array[$k]['subject']);										
					$blog_array[$k]['title_cut'] = Common::cutstr ( $blog_array[$k]['title'], 15);
					$blog_array[$k]['subject'] = Common::cutstr ( $blog_array[$k]['subject'], 400);				
					$blog_array[$k]['subject']  = str_replace( array('&amp;', '&quot;', '&lt;', '&gt;'), array('&', '"', '<', '>'), $blog_array[$k]['subject'] );		
				}	
			}							
			$pagelist = $this->obj_page->show ( 1 ); //分页显示
			//获取分类信息
			$category_array = $this->obj_space->getCategoryList ( $this->_input['uid'], $obj_page );							
			if ( is_array( $category_array )) {
				//统计分类的文章数量
				$blog_num = $this->obj_space->countBlogNum( $this->_input['uid'] );				
				foreach ( $category_array as $k1 => $v1 ) {
					foreach ( $blog_num as $k => $v ) {
						if ( $v['num'] != '' && $v['caid'] == $v1['caid'] ) {
							$category_array[$k1]['num'] = $v['num'];
						}
					}					
				}
			}			
			//抛出页面
			$this->output( "blog_array", $blog_array ); //blog
			$this->output( "category_array", $category_array ); //分类
			$this->output( "pagelist", $pagelist ); //分页			
			$this->showpage( "blog" );
		}
	}
	/**
	 * 查看日志
	 *
	 */
	function _blog_view () {
		if ( $this->_input['bid'] != '' ) {
			//获取日志
			$blog_array = $this->obj_space->getSpaceBlog ( $this->_input['bid'] );
			$blog_array['dateline'] = date ( 'Y-m-d H:i:s', $blog_array['dateline'] );
			$this->obj_page->pagebarnum ( 15 );	//每页显示?条						
			//获取评论
			$comment_array = $this->obj_space->getCommentList ( $this->_input['bid'], $this->obj_page );
			foreach ( $comment_array as $k => $v ) {
				$comment_array[$k]['dateline'] = date ( 'Y-m-d H:i:s', $comment_array[$k]['dateline'] );
				if ( $comment_array[$k]['picture'] != '' ) {
					$ex_picture = explode( ".",$comment_array[$k]['picture'] );
					$comment_array[$k]['picture'] = $ex_picture[0]."_big.".$ex_picture[1];			
					$comment_array[$k]['picture_small'] = $ex_picture[0]."_mid.".$ex_picture[1];			
				}				
			}			
			$pagelist = $this->obj_page->show ( 1 ); //分页显示				
			//记录阅读次数
			$this->obj_space->countBlogView ( $this->_input['bid'] );
			//统计评论总数
			$count_comment = $this->obj_space->countComment ( $this->_input['bid'] );				
			//抛出页面
			$this->output ( "blog_array", $blog_array ); //日志
			$this->output ( "comment_array", $comment_array ); //评论
			$this->output ( "pagelist", $pagelist ); //分页
			$this->output ( "commentnum", $count_comment ); //评论数
			$this->showpage ( "blog_view" );
		}
	}
	/**
	 * 查看精品推荐
	 *
	 */
	function _blog_commend_view () {
		if ( $this->_input['bid'] != '' ) {
			//获取日志
			$blog_array = $this->obj_space->getSpaceBlog ( $this->_input['bid'] );
			$blog_array['dateline'] = date ( 'Y-m-d H:i:s', $blog_array['dateline'] );
			//获取推荐商品
			if ( $blog_array['productid'] != '' ) {
				$producr_array = $this->obj_space->getCommnedProdut ( $blog_array['productid'], "*" ) ;
				if ( is_array( $producr_array ) ) {
					foreach ( $producr_array as $k => $vp ) {
						$producr_array[$k]['p_name_cut'] = Common::cutstr ( $producr_array[$k]['p_name'], 22 );
						if ( $producr_array[$k]['p_pic'] != '' ) {
							$ex_picture = explode( ".",$producr_array[$k]['p_pic'] );		
							$producr_array[$k]['p_pic'] = $ex_picture[0]."_small.".$ex_picture[1];			
						}
					}
				}				
			}
			$this->obj_page->pagebarnum ( 15 );	//每页显示?条						
			//获取评论
			$comment_array = $this->obj_space->getCommentList ( $this->_input['bid'], $this->obj_page );
			foreach ( $comment_array as $k => $v ) {
				$comment_array[$k]['dateline'] = date ( 'Y-m-d H:i:s', $comment_array[$k]['dateline'] );
				if ( $comment_array[$k]['picture'] != '' ) {
					$ex_picture = explode( ".",$comment_array[$k]['picture'] );
					$comment_array[$k]['picture'] = $ex_picture[0]."_big.".$ex_picture[1];			
					$comment_array[$k]['picture_small'] = $ex_picture[0]."_mid.".$ex_picture[1];			
				}				
			}			
			$pagelist = $this->obj_page->show ( 1 ); //分页显示				
			//记录阅读次数
			$this->obj_space->countBlogView ( $this->_input['bid'] );	
			//统计评论总数
			$count_comment = $this->obj_space->countComment ( $this->_input['bid'] );	
			//抛出页面
			$this->output ( "blog_array", $blog_array );
			$this->output ( "producr_array", $producr_array );
			$this->output ( "comment_array", $comment_array ); //评论
			$this->output ( "pagelist", $pagelist ); //分页			
			$this->showpage ( "blog_commend_view" );
		}		
	}
	/**
	 * 显示个人空间首页
	 *
	 */
	function _show_space_index () {
		if ( $this->_input['uid'] != '' ) {
			$uid =  $this->_input['uid'];
		} else {
			return false;
		}
		//日志列表			
		$blog_array = $this->obj_space->getIndexBlogList ( $uid );
		if ( is_array($blog_array) ) {
			foreach ( $blog_array as $k => $vb ) {
				$blog_array[$k]['dateline'] = date ( 'Y-m-d H:i:s', $blog_array[$k]['dateline'] );
				$blog_array[$k]['title_cut'] = Common::cutstr ( $blog_array[$k]['title'], 15 );		
			}	
		}
		//精品推荐			
		$blog_commend_array = $this->obj_space->getIndexBlogList ( $uid, 1 );
		if ( is_array($blog_commend_array) ) {
			foreach ( $blog_commend_array as $k => $vc ) {
				$blog_commend_array[$k]['dateline'] = date ( 'Y-m-d H:i:s', $blog_commend_array[$k]['dateline'] );
				$blog_commend_array[$k]['title_cut'] = Common::cutstr ( $blog_commend_array[$k]['title'], 15 );		
			}	
		}			
		//留言列表
		$message_array = $this->obj_space->getMessageList ( $uid );
		if ( is_array ( $message_array ) ) {
			foreach ( $message_array as $k => $vm ) {
				$message_array[$k]['dateline'] = date ( 'Y-m-d H:i:s', $message_array[$k]['dateline'] );
				if ( $message_array[$k]['picture'] != '' ) {
					$ex_picture = explode( ".",$message_array[$k]['picture'] );
					$message_array[$k]['picture'] = $ex_picture[0]."_big.".$ex_picture[1];			
					$message_array[$k]['picture_small'] = $ex_picture[0]."_mid.".$ex_picture[1];			
				}				
			}	
		}			
		//抛出页面
		$this->output ( "blog_array", $blog_array );	//日志
		$this->output ( "blog_commend_array", $blog_commend_array );	//精品推荐
		$this->output ( "message_array", $message_array );	//留言			
		$this->showpage ( "index" );
	}
	/**
	 * 抛出公共部分
	 *
	 */
	function _output_public () {
		//抛出公共左栏信息
		$space_array = $this->_get_space_info ( $this->_input['uid'] );	
		if ( $space_array['uid'] == '' ) {
	 	 	//该用户没有开通空间
	 	 	$this->redirectPath ( "error", "../index.html", $this->_lang['langSpaceNone'] );	
	 	 	exit;			
		}
		if ( $space_array['ifclose'] == '1' ) {
	 	 	//空间已经被关闭,请联系管理员
	 	 	$this->redirectPath ( "error", "../index.html", $this->_lang['langSysSpaceIfclose'] );	
	 	 	exit;				
		}		
		//统计访问人数
		$this->_count_view_num ( $this->_input['uid'] );
		//添加访问记录
		if ( $_SESSION ['s_login'] ['id'] != '' &&  $_SESSION ['s_login'] ['id'] != $this->_input['uid'] ) {
			$this->_space_visitor_add ( $this->_input['uid'] );
		}		
		$visitor_array = $this->_get_visitor ( $space_array['uid'] );
		if ( $_SESSION ['s_login'] ['id'] != '' ) {
			//是否为好友判断		
			$friend_array = $this->obj_space->getSpaceFriendList ( $this->_input['uid'], $obj_page );
			if ( is_array ( $friend_array ) ) {
				foreach ( $friend_array as $k => $v ) {
					if ( $friend_array[$k]['friendid'] == $_SESSION ['s_login'] ['id'] ) {
						$this->output ( "is_friend", 1 ); //为好友
						$this->output ( "friend_id", $friend_array[$k]['id'] ); //id
						break;	
					}
				}
			}
		}
		//抛出登录信息
		if ( $_SESSION ['s_login'] ['id'] != '' ) {
			//获取头像
			$photo_my = $this->obj_space->getSpaceInfo ( $_SESSION ['s_login']['id'], "picture" );
			if ( $photo_my['picture'] != '' ) {
				$ex_picture = explode( ".",$photo_my['picture'] );
				$photo_my['picture'] = $ex_picture[0]."_big.".$ex_picture[1];			
				$photo_my['picture_small'] = $ex_picture[0]."_mid.".$ex_picture[1];			
			}						
			$this->output ( "s_login_id", $_SESSION ['s_login']['id'] ); //登录id																				
			$this->output ( "s_login_name", $_SESSION ['s_login']['name'] ); //登录用户名						
			$this->output ( "photo_my", $photo_my ); //头像						
		}
		//抛出数据
		$this->output ( "type", "home" ); //前台
		$this->output ( "visitor_array", $visitor_array );	//近期访客
		$this->output ( "space_array", $space_array ); //空间信息				
	}
	/**
	 * 获取空间信息
	 *
	 * @param int $uid
	 */
	function _get_space_info ( $uid ) {	
		//获取用户空间信息
		$space_array = $this->obj_space->getSpaceInfo ( $uid, "*" );
		if ( $space_array['picture'] != '' ) {
			$ex_picture = explode( ".",$space_array['picture'] );
			$space_array['picture'] = $ex_picture[0]."_big.".$ex_picture[1];			
			$space_array['picture_small'] = $ex_picture[0]."_mid.".$ex_picture[1];			
		}	
		return $space_array;
	}
	/**
	 * 近期访客
	 *
	 * @param int $uid
	 * @return array
	 */
	function _get_visitor ( $uid ) {
		$visitor_array = $this->obj_space->getIndexVisitorList ( $uid );	
		if ( is_array ( $visitor_array ) ) {
			foreach ( $visitor_array as $k => $vv ) {
				if ( $vv['picture'] != '' ) {
					$ex_picture = explode( ".",$vv['picture'] );
					$visitor_array[$k]['picture'] = $ex_picture[0]."_big.".$ex_picture[1];			
					$visitor_array[$k]['picture_small'] = $ex_picture[0]."_mid.".$ex_picture[1];			
				}					
				$visitor_array[$k]['dateline'] = date ( 'Y-m-d', $visitor_array[$k]['dateline'] );	
			}	
		}	
		return $visitor_array;
	}
	/**
	 * 增加访问者记录
	 *
	 * @param int $uid
	 * @param int $vuid
	 */
	function _space_visitor_add ( $uid ) {
		if ( $uid != '' ) {
			//获取以前是否访问过
			$visitor_array = $this->obj_space->getSpaceVisitor ( $uid, $_SESSION ['s_login'] ['id'], "uid" ) ;
			if ( $visitor_array['uid'] != '' ) { //访问过
				//更新访问时间			
				$this->obj_space->updateSapceVisitor ( $uid, $_SESSION ['s_login'] ['id'] );		
			} else { //未访问过
				$input = array();
				$input['uid'] = $uid;
				$input['vuid'] = $_SESSION ['s_login'] ['id'];
				$input['vusername'] = $_SESSION ['s_login'] ['name'];
				$this->obj_space->addSapceVisitor ( $input );		
			}
		}
	}
	/**
	 * 统计访问人数
	 *
	 */
	function _count_view_num ( $uid ) {
		//取得访问日期
		$space_array = $this->obj_space->getSpaceInfo ( $uid, 'viewdate' );	
		if ( $space_array['viewdate'] != 0 ) {
			//判断是否为当前日期
			if ( strtotime( date( 'Y-m-d' , time() ) ) > $space_array['viewdate'] ) {
				//更新访问日期、当日访问数归0
				$this->obj_space->updateSpace ( $uid, array ( "viewdate" => strtotime( date( 'Y-m-d' , time() ) ), 'visitday' => '0' ) );
			}
			//更新当日访问人数、更新累计访问人数	
			$this->obj_space->updateSpaceView ( $uid );
		} else {
			//赋值为当前日期
			$this->obj_space->updateSpace ( $uid, array ( "viewdate" => strtotime( date( 'Y-m-d' , time() ) ) ) );
		}
	}	
}
$space = new Space ();
$space->main ();
unset ( $space );
?>